/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.internal.LazilyParsedNumber;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import velox.api.layer1.simplified.NumberConverter;
import velox.api.layer1.simplified.UserSettings;

public class ParameterFieldDeserializer
implements JsonDeserializer<UserSettings.ParameterField> {
    public UserSettings.ParameterField deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Field[] fields;
        Gson gson = new Gson();
        UserSettings.ParameterField parameterField = new UserSettings.ParameterField();
        JsonObject userSettingsAsJsonObject = json.getAsJsonObject();
        String className = userSettingsAsJsonObject.get("className").getAsString();
        Class<?> fieldNumberClass = null;
        try {
            fieldNumberClass = Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        for (Field field : fields = parameterField.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                String fieldName = field.getName();
                JsonElement element = userSettingsAsJsonObject.get(fieldName);
                Class<?> type = field.getType();
                Object object0 = gson.fromJson(element, this.getType(type));
                if (object0 != null) {
                    Class<?> objectClass = object0.getClass();
                    if (objectClass == LazilyParsedNumber.class) {
                        object0 = Double.parseDouble(element.getAsString());
                    }
                    if (Number.class.isAssignableFrom(objectClass) && Number.class.isAssignableFrom(fieldNumberClass)) {
                        object0 = NumberConverter.convert((Number)object0, fieldNumberClass);
                    }
                    if (Color.class.isAssignableFrom(fieldNumberClass) && fieldName.equals("defaultValue")) {
                        object0 = gson.fromJson(element, this.getType(fieldNumberClass));
                    }
                }
                field.set(parameterField, object0);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return parameterField;
    }

    Type getType(final Class<?> rawClass) {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[0];
            }

            @Override
            public Type getRawType() {
                return rawClass;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }
}

