/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import velox.api.layer1.layers.strategies.interfaces.WidgetRangeConsumer;
import velox.api.layer1.simplified.Indicator;
import velox.api.layer1.simplified.SimplifiedL1ApiLoader;
import velox.api.layer1.simplified.WidgetGroup;
import velox.api.layer1.simplified.WidgetRules;

public class WidgetRulesCalculator {
    public static String longToTransactTime(long moment) {
        ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(moment / 1000000L), ZoneId.systemDefault());
        String time = zdt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "Z";
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getIndex(List<ImmutablePair<Long, Double>> list, long timestamp) {
        List<ImmutablePair<Long, Double>> list2 = list;
        synchronized (list2) {
            int index = Collections.binarySearch(list, new ImmutablePair((Object)timestamp, (Object)new SimplifiedL1ApiLoader.Point()), (a, b) -> Long.compare((Long)a.getLeft(), (Long)b.getLeft()));
            if (index < 0) {
                index = -index - 1;
            }
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void packExtreme(double extreme, List<ImmutablePair<Long, Double>> result, boolean isMaximum, long timestamp) {
        if (!Double.isNaN(extreme)) {
            List<ImmutablePair<Long, Double>> list = result;
            synchronized (list) {
                result.add((ImmutablePair<Long, Double>)new ImmutablePair((Object)timestamp, (Object)extreme));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getTemporalExtreme(List<ImmutablePair<Long, Double>> extremes, boolean isMax, long timestamp, long widgetRangeLifeSpan) {
        double multiplier = isMax ? 1.0 : -1.0;
        double temporalExtreme = Double.NaN;
        List<ImmutablePair<Long, Double>> list = extremes;
        synchronized (list) {
            int indexStart = WidgetRulesCalculator.getIndex(extremes, timestamp - widgetRangeLifeSpan);
            int indexEnd = WidgetRulesCalculator.getIndex(extremes, timestamp);
            if (indexEnd == extremes.size() - 1) {
                ++indexEnd;
            }
            if (indexStart >= 0 && !extremes.isEmpty()) {
                List<ImmutablePair<Long, Double>> valuesWithinInterval = extremes.subList(indexStart, indexEnd);
                for (ImmutablePair<Long, Double> valuePair : valuesWithinInterval) {
                    double value = (Double)valuePair.getRight();
                    if (Double.isNaN(temporalExtreme)) {
                        temporalExtreme = value;
                    }
                    if (!(temporalExtreme * multiplier <= value * multiplier)) continue;
                    temporalExtreme = value;
                }
            }
            return temporalExtreme;
        }
    }

    public static ImmutableTriple<Double, Double, Long> processPoint(double value, long time, long nextTime, double lower, double upper, WidgetRules widgetRules, List<ImmutablePair<Long, ImmutablePair<Double, Double>>> sampledWidgetRanges, List<ImmutablePair<Long, ImmutablePair<Double, Double>>> spannedWidgetRanges) {
        lower = WidgetRulesCalculator.initializeOrUpdateLower(lower, value);
        upper = WidgetRulesCalculator.initializeOrUpdateUpper(upper, value);
        if (time > nextTime) {
            nextTime = time - time % nextTime;
            WidgetRulesCalculator.updateSampledWidgetRanges(nextTime, lower, upper, sampledWidgetRanges);
            WidgetRulesCalculator.updateSpannedWidgetRanges(nextTime, widgetRules.getLifeSpan(), sampledWidgetRanges, spannedWidgetRanges);
            lower = Double.NaN;
            upper = Double.NaN;
            nextTime += widgetRules.getLifeSpan() / 100L;
        }
        return new ImmutableTriple((Object)lower, (Object)upper, (Object)nextTime);
    }

    public static double initializeOrUpdateLower(double lower, double value) {
        if (Double.isNaN(lower) || lower > value) {
            lower = value;
        }
        return lower;
    }

    public static double initializeOrUpdateUpper(double upper, double value) {
        if (Double.isNaN(upper) || upper < value) {
            upper = value;
        }
        return upper;
    }

    public static List<Object> onBasicImplementationWidgetLifeSpanChanges(WidgetRules widgetRules, List<Pair<Long, SimplifiedL1ApiLoader.Point>> points) {
        double lower = Double.NaN;
        double upper = Double.NaN;
        LinkedList<ImmutablePair<Long, ImmutablePair<Double, Double>>> sampledWidgetRanges = new LinkedList<ImmutablePair<Long, ImmutablePair<Double, Double>>>();
        LinkedList<ImmutablePair<Long, ImmutablePair<Double, Double>>> spannedWidgetRanges = new LinkedList<ImmutablePair<Long, ImmutablePair<Double, Double>>>();
        if (points.size() >= 100) {
            long nextTime = (Long)points.get(0).getLeft() + widgetRules.getLifeSpan() / 100L;
            int size = points.size();
            for (int i = 0; i < size; ++i) {
                long time = (Long)points.get(i).getLeft();
                double value = ((SimplifiedL1ApiLoader.Point)points.get(i).getRight()).getValue();
                ImmutableTriple<Double, Double, Long> returnedValues = WidgetRulesCalculator.processPoint(value, time, nextTime, lower, upper, widgetRules, sampledWidgetRanges, spannedWidgetRanges);
                lower = (Double)returnedValues.left;
                upper = (Double)returnedValues.middle;
                nextTime = (Long)returnedValues.right;
            }
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(sampledWidgetRanges);
        list.add(spannedWidgetRanges);
        return list;
    }

    private static void updateSampledWidgetRanges(long nextTime, double lower, double upper, List<ImmutablePair<Long, ImmutablePair<Double, Double>>> sampledWidgetRanges) {
        ImmutablePair currentRange = new ImmutablePair((Object)lower, (Object)upper);
        sampledWidgetRanges.add((ImmutablePair<Long, ImmutablePair<Double, Double>>)new ImmutablePair((Object)nextTime, (Object)currentRange));
    }

    private static void updateSpannedWidgetRanges(long nextTime, long widgetLifeSpan, List<ImmutablePair<Long, ImmutablePair<Double, Double>>> sampledWidgetRanges, List<ImmutablePair<Long, ImmutablePair<Double, Double>>> spannedWidgetRanges) {
        int indexStart = WidgetRulesCalculator.getIndex1(sampledWidgetRanges, nextTime - widgetLifeSpan);
        int indexEnd = WidgetRulesCalculator.getIndex1(sampledWidgetRanges, nextTime);
        if (indexEnd == sampledWidgetRanges.size() - 1) {
            ++indexEnd;
        }
        if (indexStart >= 0 && !sampledWidgetRanges.isEmpty()) {
            List<ImmutablePair<Long, ImmutablePair<Double, Double>>> widgetRangesWithinLifeSpan = sampledWidgetRanges.subList(indexStart, indexEnd);
            double tempLower = Double.NaN;
            double tempUpper = Double.NaN;
            for (ImmutablePair<Long, ImmutablePair<Double, Double>> sampledWidgetRange : widgetRangesWithinLifeSpan) {
                ImmutablePair widgetRange = (ImmutablePair)sampledWidgetRange.getRight();
                double widgetRangeLower = (Double)widgetRange.getLeft();
                double widgetRangeUpper = (Double)widgetRange.getRight();
                tempLower = WidgetRulesCalculator.initializeOrUpdateLower(tempLower, widgetRangeLower);
                tempUpper = WidgetRulesCalculator.initializeOrUpdateUpper(tempUpper, widgetRangeUpper);
            }
            ImmutablePair spannedWidgetRange = new ImmutablePair((Object)tempLower, (Object)tempUpper);
            spannedWidgetRanges.add((ImmutablePair<Long, ImmutablePair<Double, Double>>)new ImmutablePair((Object)nextTime, (Object)spannedWidgetRange));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getIndex1(List<ImmutablePair<Long, ImmutablePair<Double, Double>>> list, long timestamp) {
        List<ImmutablePair<Long, ImmutablePair<Double, Double>>> list2 = list;
        synchronized (list2) {
            int index = Collections.binarySearch(list, new ImmutablePair((Object)timestamp, (Object)new SimplifiedL1ApiLoader.Point()), (a, b) -> Long.compare((Long)a.getLeft(), (Long)b.getLeft()));
            if (index < 0) {
                index = -index - 1;
            }
            return index;
        }
    }

    public void getActualWidgetRange() {
    }

    public static ImmutablePair<Double, Double> getTemporalMinMax(long leftTime, double lower, double upper, List<ImmutablePair<Long, ImmutablePair<Double, Double>>> spannedWidgetRanges) {
        double actualUpper;
        double actualLower;
        List<ImmutablePair<Long, ImmutablePair<Double, Double>>> temporalUnmodifiebleExtremesList = Collections.unmodifiableList(spannedWidgetRanges);
        int index = Collections.binarySearch(temporalUnmodifiebleExtremesList, new ImmutablePair((Object)leftTime, (Object)new SimplifiedL1ApiLoader.Point()), (a, b) -> Long.compare((Long)a.getLeft(), (Long)b.getLeft()));
        if (index < 0) {
            index = -index - 1;
        }
        if (index < temporalUnmodifiebleExtremesList.size()) {
            ImmutablePair temporalMinMax = (ImmutablePair)temporalUnmodifiebleExtremesList.get(index).getRight();
            actualLower = (Double)temporalMinMax.left;
            actualUpper = (Double)temporalMinMax.right;
        } else {
            int temporalExtremeLastIndex = temporalUnmodifiebleExtremesList.size() - 1;
            if (temporalExtremeLastIndex >= 0) {
                ImmutablePair temporalMinMax = (ImmutablePair)temporalUnmodifiebleExtremesList.get(temporalExtremeLastIndex).getRight();
                actualUpper = Double.isNaN(upper) || (Double)temporalMinMax.getRight() > upper ? (Double)temporalMinMax.getRight() : upper;
                actualLower = Double.isNaN(lower) || (Double)temporalMinMax.getLeft() < lower ? (Double)temporalMinMax.getLeft() : lower;
            } else {
                actualUpper = upper;
                actualLower = lower;
            }
        }
        return new ImmutablePair((Object)actualLower, (Object)actualUpper);
    }

    public static ImmutablePair<Double, Double> updateRangeToBeReported(ImmutablePair<Double, Double> actualRange, double latestReportedLower, double latestReportedUpper) {
        double actualLower = (Double)actualRange.left;
        double actualUpper = (Double)actualRange.right;
        if (Double.isNaN(actualLower) || actualLower != latestReportedLower || actualUpper != latestReportedUpper) {
            latestReportedLower = actualLower;
            latestReportedUpper = actualUpper;
            return new ImmutablePair((Object)latestReportedLower, (Object)latestReportedUpper);
        }
        return null;
    }

    public static ImmutablePair<Double, Double> reportRange(WidgetRangeConsumer consumer, double latestReportedLower, double latestReportedUpper) {
        if (consumer != null) {
            consumer.setForcedMinValue(Double.valueOf(latestReportedLower));
            consumer.setForcedMaxValue(Double.valueOf(latestReportedUpper));
            return new ImmutablePair((Object)latestReportedLower, (Object)latestReportedUpper);
        }
        return null;
    }

    public static ImmutablePair<Double, Double> adjustGroupRange(WidgetGroup widgetGroup) {
        List<Indicator> rangeInputIndicators = widgetGroup.getIndicatorWidgets();
        double minMinValue = Double.POSITIVE_INFINITY;
        double maxMaxValue = Double.NEGATIVE_INFINITY;
        for (SimplifiedL1ApiLoader.IndicatorImplementation indicatorImplementation : rangeInputIndicators) {
            minMinValue = Math.min(minMinValue, indicatorImplementation.latestReportedLower);
            maxMaxValue = Math.max(maxMaxValue, indicatorImplementation.latestReportedUpper);
        }
        if (Double.isNaN(minMinValue) || Double.isNaN(maxMaxValue)) {
            return null;
        }
        WidgetRules widgetRules = widgetGroup.getWidgetRules();
        if (widgetRules == null) {
            widgetRules = new WidgetRules();
        }
        Pair<Double, Double> pair = widgetRules.apply(minMinValue, maxMaxValue);
        return new ImmutablePair(pair.getLeft(), pair.getRight());
    }

    private static String listOfImmutablePairsToStringWithLongKeysToDates(List<ImmutablePair<Long, ImmutablePair<Double, Double>>> list) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (ImmutablePair<Long, ImmutablePair<Double, Double>> unit : list) {
            sb.append("[").append(WidgetRulesCalculator.longToTransactTime((Long)unit.left));
            sb.append(", ").append(unit.right).append("]");
            sb.append(", ");
        }
        int length = sb.length();
        sb.delete(length - 2, length - 1);
        sb.append("]");
        return sb.toString();
    }

    public static boolean isCalculationOrReportingAllowed(WidgetRangeConsumer consumer, WidgetRules widgetRules, WidgetGroup widgetGroup) {
        return consumer != null && consumer.isWidgetVisible() && (widgetRules != null || widgetGroup != null);
    }
}

