/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import java.lang.reflect.Type;
import java.math.BigDecimal;

public class NumberConverter {
    public static <T extends Number> T convert(Number value, Class<?> clazz) {
        Class<?> inputClazz = value.getClass();
        Number output = null;
        if (inputClazz == clazz) {
            output = value;
        } else if (inputClazz != Double.class || inputClazz != Float.class) {
            Number maxOutputTypeValue = NumberConverter.getMaxTypeValue(clazz);
            output = NumberConverter.compareNumbers(value, maxOutputTypeValue) > 0 ? (Number)maxOutputTypeValue : (Number)NumberConverter.getTypeValue(value, clazz);
        } else if (inputClazz == Double.class || inputClazz == Float.class) {
            if (inputClazz == clazz) {
                output = value;
            } else if (clazz == Integer.class || clazz == Long.class) {
                Double doubleValue = value.doubleValue();
                Long longValue = Math.round(doubleValue);
                output = NumberConverter.convert(longValue, clazz);
            }
        }
        return (T)output;
    }

    private static int compareNumbers(Number n1, Number n2) {
        BigDecimal n2c = new BigDecimal(n2.toString());
        BigDecimal n1c = new BigDecimal(n1.toString());
        return n1c.compareTo(n2c);
    }

    public static <T extends Number> Number getMaxTypeValue(Type type) {
        Number maxTypeValue = null;
        if (type == Byte.class) {
            maxTypeValue = (byte)127;
        } else if (type == Short.class) {
            maxTypeValue = (short)Short.MAX_VALUE;
        } else if (type == Integer.class) {
            maxTypeValue = Integer.MAX_VALUE;
        } else if (type == Long.class) {
            maxTypeValue = Long.MAX_VALUE;
        } else if (type == Float.class) {
            maxTypeValue = Float.valueOf(Float.MAX_VALUE);
        } else if (type == Double.class) {
            maxTypeValue = Double.MAX_VALUE;
        }
        return maxTypeValue;
    }

    private static <T extends Number> Number getTypeValue(Number value, Class<?> type) {
        Number output = null;
        if (type == Byte.class) {
            output = value.byteValue();
        } else if (type == Short.class) {
            output = value.shortValue();
        } else if (type == Integer.class) {
            output = value.intValue();
        } else if (type == Long.class) {
            output = value.longValue();
        } else if (type == Float.class) {
            output = Float.valueOf(value.floatValue());
        } else if (type == Double.class) {
            output = value.doubleValue();
        }
        return output;
    }
}

