/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import java.awt.Color;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import velox.api.layer1.Layer1ApiFinishable;
import velox.api.layer1.Layer1ApiInstrumentSpecificEnabledStateProvider;
import velox.api.layer1.Layer1ApiMboDataAdapter;
import velox.api.layer1.Layer1ApiMboDataListener;
import velox.api.layer1.Layer1ApiProvider;
import velox.api.layer1.Layer1CustomPanelsGetter;
import velox.api.layer1.annotations.Layer1TradingStrategy;
import velox.api.layer1.common.Log;
import velox.api.layer1.common.NanoClock;
import velox.api.layer1.data.BalanceInfo;
import velox.api.layer1.data.ExecutionInfo;
import velox.api.layer1.data.InstrumentInfo;
import velox.api.layer1.data.MarketMode;
import velox.api.layer1.data.OrderInfoUpdate;
import velox.api.layer1.data.OrderSendParameters;
import velox.api.layer1.data.OrderUpdateParameters;
import velox.api.layer1.data.StatusInfo;
import velox.api.layer1.data.TradeInfo;
import velox.api.layer1.layers.Layer1ApiInjectorRelay;
import velox.api.layer1.layers.strategies.interfaces.CalculatedResultListener;
import velox.api.layer1.layers.strategies.interfaces.CustomEventAggregatble;
import velox.api.layer1.layers.strategies.interfaces.CustomGeneratedEvent;
import velox.api.layer1.layers.strategies.interfaces.CustomGeneratedEventAliased;
import velox.api.layer1.layers.strategies.interfaces.InvalidateInterface;
import velox.api.layer1.layers.strategies.interfaces.Layer1IndicatorColorInterface;
import velox.api.layer1.layers.strategies.interfaces.Layer1PriceAxisRangeCalculatable;
import velox.api.layer1.layers.strategies.interfaces.Layer1StrategyAddInterface;
import velox.api.layer1.layers.strategies.interfaces.Layer1WidgetRangeInterface;
import velox.api.layer1.layers.strategies.interfaces.OnlineCalculatable;
import velox.api.layer1.layers.strategies.interfaces.OnlineValueCalculatorAdapter;
import velox.api.layer1.layers.strategies.interfaces.WidgetRangeConsumer;
import velox.api.layer1.layers.utils.OrderBook;
import velox.api.layer1.layers.utils.mbo.OrderBookMbo;
import velox.api.layer1.messages.CurrentTimeUserMessage;
import velox.api.layer1.messages.GeneratedEventInfo;
import velox.api.layer1.messages.Layer1ApiRequestCurrentTimeEvents;
import velox.api.layer1.messages.Layer1ApiUserMessageAddStrategyUpdateGenerator;
import velox.api.layer1.messages.UserMessageLayersChainCreatedTargeted;
import velox.api.layer1.messages.UserMessageRewindBase;
import velox.api.layer1.messages.indicators.AliasFilter;
import velox.api.layer1.messages.indicators.DataStructureInterface;
import velox.api.layer1.messages.indicators.IndicatorColorScheme;
import velox.api.layer1.messages.indicators.IndicatorLineStyle;
import velox.api.layer1.messages.indicators.Layer1ApiDataInterfaceRequestMessage;
import velox.api.layer1.messages.indicators.Layer1ApiUserMessageModifyIndicator;
import velox.api.layer1.messages.indicators.SettingsAccess;
import velox.api.layer1.messages.indicators.StrategyUpdateGenerator;
import velox.api.layer1.messages.indicators.StrategyUpdateGeneratorFilter;
import velox.api.layer1.messages.indicators.WidgetDisplayInfo;
import velox.api.layer1.settings.Layer1ConfigSettingsInterface;
import velox.api.layer1.settings.StrategySettingsVersion;
import velox.api.layer1.simplified.Api;
import velox.api.layer1.simplified.AxisGroup;
import velox.api.layer1.simplified.AxisRules;
import velox.api.layer1.simplified.BalanceListener;
import velox.api.layer1.simplified.Bar;
import velox.api.layer1.simplified.BarDataListener;
import velox.api.layer1.simplified.BboListener;
import velox.api.layer1.simplified.CustomModule;
import velox.api.layer1.simplified.CustomSettingsPanelProvider;
import velox.api.layer1.simplified.DepthDataListener;
import velox.api.layer1.simplified.HistoricalDataListener;
import velox.api.layer1.simplified.HistoricalModeListener;
import velox.api.layer1.simplified.Indicator;
import velox.api.layer1.simplified.IndicatorModifiable;
import velox.api.layer1.simplified.InitialState;
import velox.api.layer1.simplified.InstanceUtils;
import velox.api.layer1.simplified.IntervalListener;
import velox.api.layer1.simplified.Intervals;
import velox.api.layer1.simplified.LineStyle;
import velox.api.layer1.simplified.MarketByOrderDepthDataListener;
import velox.api.layer1.simplified.MultiInstrumentListener;
import velox.api.layer1.simplified.NoAutosubscription;
import velox.api.layer1.simplified.OrdersListener;
import velox.api.layer1.simplified.Parameter;
import velox.api.layer1.simplified.ParameterFieldDeserializer;
import velox.api.layer1.simplified.PositionListener;
import velox.api.layer1.simplified.SnapshotEndListener;
import velox.api.layer1.simplified.TimeListener;
import velox.api.layer1.simplified.TradeDataListener;
import velox.api.layer1.simplified.UserSettings;
import velox.api.layer1.simplified.UserSettingsWrapper;
import velox.api.layer1.simplified.WidgetGroup;
import velox.api.layer1.simplified.WidgetRules;
import velox.api.layer1.simplified.WidgetRulesCalculator;
import velox.api.layer1.utils.PriceRangeCalculationHelper;
import velox.colors.ColorsChangedListener;
import velox.gui.StrategyPanel;

public class SimplifiedL1ApiLoader<T extends CustomModule>
extends Layer1ApiInjectorRelay
implements Layer1ApiFinishable,
Layer1CustomPanelsGetter,
Layer1ConfigSettingsInterface,
Layer1IndicatorColorInterface,
Layer1ApiInstrumentSpecificEnabledStateProvider,
Layer1PriceAxisRangeCalculatable,
Layer1WidgetRangeInterface,
Layer1StrategyAddInterface {
    Object settingsAccessLocker = new Object();
    private static AtomicInteger generatorIndicatorIncrementalId = new AtomicInteger();
    public static final CustomEventAggregatble CUSTOM_TRADE_EVENTS_AGGREGATOR = new CustomEventAggregatble(){

        public CustomGeneratedEvent getInitialValue(long t) {
            return new CustomAggregationEvent(t, Collections.emptyMap());
        }

        public void aggregateAggregationWithValue(CustomGeneratedEvent aggregation, CustomGeneratedEvent value) {
            CustomAggregationEvent aggregationEvent = (CustomAggregationEvent)aggregation;
            CustomEvent valueEvent = (CustomEvent)value;
            aggregationEvent.indicators.put(valueEvent.indicatorId, valueEvent.indicatorPoint);
        }

        public void aggregateAggregationWithAggregation(CustomGeneratedEvent aggregation1, CustomGeneratedEvent aggregation2) {
            CustomAggregationEvent aggregationEvent1 = (CustomAggregationEvent)aggregation1;
            CustomAggregationEvent aggregationEvent2 = (CustomAggregationEvent)aggregation2;
            aggregationEvent1.indicators.putAll(aggregationEvent2.indicators);
        }
    };
    private static final Color DEFAULT_INDICATOR_COLOR = Color.WHITE;
    private static final String LOAD_SESSION_ID_POSTFIX = ".loadSessionId";
    private final Layer1ApiRequestCurrentTimeEvents requestCurrentTimeEventsMessage = new Layer1ApiRequestCurrentTimeEvents(true, 0L, TimeUnit.MILLISECONDS.toNanos(50L));
    private DataStructureInterface dataStructureInterface;
    private SettingsAccess settingsAccess;
    private Class<T> simpleStrategyClass;
    private Map<String, InstanceWrapper> instanceWrappers = new ConcurrentHashMap<String, InstanceWrapper>();
    public Map<String, Map<String, UserSettings.ParameterField>> initialUserSettings = new ConcurrentHashMap<String, Map<String, UserSettings.ParameterField>>();
    private Map<String, Runnable> invalidatePannelsFunctions = new ConcurrentHashMap<String, Runnable>();
    private final Mode mode;
    private final boolean multiInstrument;
    private Map<String, InstrumentInfo> instruments = new ConcurrentHashMap<String, InstrumentInfo>();
    private Map<String, OrderBook> orderBooks = new ConcurrentHashMap<String, OrderBook>();
    private Map<String, OrderBookMbo> orderBooksMbo = new ConcurrentHashMap<String, OrderBookMbo>();
    private Map<String, OrderInfoUpdate> orders = new ConcurrentHashMap<String, OrderInfoUpdate>();
    private Map<String, StatusInfo> statuses = new ConcurrentHashMap<String, StatusInfo>();
    private BalanceInfo balance;
    private Map<String, InitialState> initialStates = new ConcurrentHashMap<String, InitialState>();
    private HashMap<Pair<String, String>, Color> defaultColors = new HashMap();
    private Map<String, Runnable> strategyEnabledRecheckCallbacks = new ConcurrentHashMap<String, Runnable>();
    private long loadSessionId = 0L;
    private long runSessionId = NanoClock.currentTimeNanos();

    public SimplifiedL1ApiLoader(Layer1ApiProvider provider, Class<T> clazz) {
        super(provider);
        this.simpleStrategyClass = clazz;
        this.mode = HistoricalModeListener.class.isAssignableFrom(clazz) ? Mode.MIXED : (HistoricalDataListener.class.isAssignableFrom(clazz) ? Mode.GENERATORS : Mode.LIVE);
        this.multiInstrument = MultiInstrumentListener.class.isAssignableFrom(clazz);
    }

    public void onStrategyAdd() {
        this.loadSessionId = NanoClock.currentTimeNanos();
    }

    public void finish() {
        this.instanceWrappers.keySet().forEach(alias -> this.stopForInstrument((String)alias, false));
        this.requestCurrentTimeEventsMessage.setAdd(false);
        this.provider.sendUserMessage((Object)this.requestCurrentTimeEventsMessage);
    }

    public void setColor(String alias, String name, Color color) {
        throw new UnsupportedOperationException("Setting color not supported");
    }

    public Color getColor(String alias, String name) {
        return this.defaultColors.get(new ImmutablePair((Object)alias, (Object)name));
    }

    private void setSefaultColor(String alias, String name, Color color) {
        this.defaultColors.put((Pair<String, String>)new ImmutablePair((Object)alias, (Object)name), color);
    }

    public void addColorChangeListener(ColorsChangedListener listener) {
    }

    public void acceptSettingsInterface(SettingsAccess settingsAccess) {
        this.settingsAccess = settingsAccess;
        if (this.loadSessionId == 0L) {
            this.loadSessionId = ((LoadSessionIdWrapper)settingsAccess.getSettings(null, (String)new StringBuilder().append((String)this.simpleStrategyClass.getName()).append((String)LOAD_SESSION_ID_POSTFIX).toString(), LoadSessionIdWrapper.class)).loadSessionId;
        } else {
            settingsAccess.setSettings(null, this.simpleStrategyClass.getName() + LOAD_SESSION_ID_POSTFIX, (Object)new LoadSessionIdWrapper(this.loadSessionId), LoadSessionIdWrapper.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StrategyPanel[] getCustomGuiFor(String alias, String indicatorName) {
        StrategyPanel[] panels = new StrategyPanel[]{};
        InstanceWrapper instanceWrapper = this.instanceWrappers.get(alias);
        if (instanceWrapper == null) {
            panels = new StrategyPanel[]{new StrategyPanel("Please enable the module to configure")};
        } else if (instanceWrapper.instance instanceof CustomSettingsPanelProvider) {
            panels = instanceWrapper.getCustomSettingsPanels();
        } else {
            UserSettings settings;
            ArrayList<StrategyPanel> panelsList = new ArrayList<StrategyPanel>();
            Object object = this.settingsAccessLocker;
            synchronized (object) {
                String strategyFullName = this.simpleStrategyClass.getName();
                UserSettingsWrapper wrapper = (UserSettingsWrapper)this.settingsAccess.getSettings(alias, strategyFullName, UserSettingsWrapper.class);
                settings = wrapper.unwrap(UserSettings.class, UserSettings.ParameterField.class, ParameterFieldDeserializer.class);
                if (!settings.isEmpty()) {
                    InstanceUtils.setValuesFromSettings(settings, this.instanceWrappers.get(alias).getInstance(), Parameter.class);
                }
            }
            CustomModule instance = instanceWrapper.getInstance();
            StrategyPanel instrumentPanel = InstanceUtils.addCustomGui(instance, settings, "Settings", alias, this);
            panelsList.add(instrumentPanel);
            StrategyPanel colorPanel = InstanceUtils.getColorPanel(instance, this, alias);
            panelsList.add(0, colorPanel);
            panels = (StrategyPanel[])panelsList.stream().filter(p -> p != null).toArray(StrategyPanel[]::new);
        }
        if (panels.length == 0) {
            panels = new StrategyPanel[]{new StrategyPanel("This module is not configurable")};
        }
        if (panels.length > 0) {
            WeakReference<StrategyPanel> firstPanelReference = new WeakReference<StrategyPanel>(panels[0]);
            this.invalidatePannelsFunctions.put(alias, () -> {
                StrategyPanel strategyPanel = (StrategyPanel)firstPanelReference.get();
                if (strategyPanel != null) {
                    strategyPanel.requestReload();
                }
            });
        }
        return panels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void settingsChanged(String alias, UserSettings settings) {
        String strategyFullName = this.simpleStrategyClass.getName();
        Object object = this.settingsAccessLocker;
        synchronized (object) {
            settings.setLoadSessionId(this.loadSessionId);
            settings.setRunSessionId(this.runSessionId);
            settings.setInstrumentAlias(alias);
            UserSettingsWrapper wrapper = new UserSettingsWrapper();
            wrapper.wrap(settings);
            Object object2 = this.settingsAccessLocker;
            synchronized (object2) {
                this.settingsAccess.setSettings(alias, strategyFullName, (Object)wrapper, UserSettingsWrapper.class);
            }
        }
    }

    public void onStrategyCheckboxEnabled(String alias, boolean isEnabled) {
        Log.warn((String)("Enabled for " + alias + " " + isEnabled));
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference exception = new AtomicReference();
        this.inject(() -> {
            try {
                UserSettings settings = this.getUserSettings(alias);
                if (isEnabled) {
                    if (this.instruments.containsKey(alias)) {
                        this.startForInstrument(alias);
                    }
                    if (settings == null) {
                        settings = this.getUserSettings(alias);
                    }
                    settings.setLoadedAtStartup(true);
                    settings.setEnabled(true);
                } else {
                    this.stopForInstrument(alias, false);
                    settings.setLoadedAtStartup(true);
                    settings.setEnabled(false);
                }
                this.settingsChanged(alias, settings);
            }
            catch (Exception e) {
                exception.set(e);
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await();
            Log.warn((String)("Enabled for " + alias + " " + isEnabled));
            if (exception.get() != null) {
                throw new RuntimeException("Error while changing checkbox state", (Throwable)exception.get());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void startForInstrument(String alias) {
        InstanceWrapper instanceWrapper = new InstanceWrapper(alias);
        this.instanceWrappers.put(alias, instanceWrapper);
        instanceWrapper.start();
    }

    private void stopForInstrument(String alias, boolean invalidatePanels) {
        InstanceWrapper removedWrapper = this.instanceWrappers.remove(alias);
        if (removedWrapper != null) {
            removedWrapper.stop(invalidatePanels);
        }
    }

    public boolean isStrategyEnabled(String alias) {
        if (alias == null) {
            return false;
        }
        UserSettings settings = this.getUserSettings(alias);
        if (settings != null) {
            return settings.isEnabled();
        }
        return false;
    }

    public void setStrategyEnabledRecheckCallback(String alias, Runnable recheckCallback) {
        this.strategyEnabledRecheckCallbacks.put(alias, recheckCallback);
    }

    public void onUserMessage(Object data) {
        block5: {
            block6: {
                HashMap<String, InstrumentInfo> instrumentsCopy;
                block7: {
                    block4: {
                        super.onUserMessage(data);
                        if (data.getClass() != UserMessageLayersChainCreatedTargeted.class) break block4;
                        UserMessageLayersChainCreatedTargeted message = (UserMessageLayersChainCreatedTargeted)data;
                        if (message.targetClass != this.simpleStrategyClass) break block5;
                        this.provider.sendUserMessage((Object)new Layer1ApiDataInterfaceRequestMessage(dataStructureInterface -> {
                            this.dataStructureInterface = dataStructureInterface;
                        }));
                        this.requestCurrentTimeEventsMessage.setAdd(true);
                        this.provider.sendUserMessage((Object)this.requestCurrentTimeEventsMessage);
                        break block5;
                    }
                    if (!(data instanceof UserMessageRewindBase)) break block6;
                    instrumentsCopy = new HashMap<String, InstrumentInfo>(this.instruments);
                    if (this.mode != Mode.LIVE) break block7;
                    instrumentsCopy.keySet().forEach(alias -> this.removeInstrument((String)alias, false));
                    UserMessageRewindBase rewindMessage = (UserMessageRewindBase)data;
                    for (Map.Entry entry : rewindMessage.aliasToOrderBooksMap.entrySet()) {
                        String alias2 = (String)entry.getKey();
                        OrderBook orderBook = new OrderBook((OrderBook)entry.getValue());
                        InstrumentInfo instrumentInfo = (InstrumentInfo)instrumentsCopy.get(alias2);
                        if (instrumentInfo == null) continue;
                        OrderBookMbo orderBookMbo = new OrderBookMbo((OrderBookMbo)rewindMessage.aliasToOrderBooksMboMap.get(alias2));
                        this.addInstrument(alias2, instrumentInfo, orderBook, orderBookMbo);
                    }
                    break block5;
                }
                if (this.mode != Mode.MIXED) break block5;
                for (Map.Entry entry : instrumentsCopy.entrySet()) {
                    this.removeInstrument((String)entry.getKey(), false);
                    this.addInstrument((String)entry.getKey(), (InstrumentInfo)entry.getValue(), new OrderBook(), new OrderBookMbo());
                }
                break block5;
            }
            if (data instanceof CurrentTimeUserMessage) {
                for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                    instanceWrapper.setTime(this.getCurrentTime(), false);
                }
            }
        }
    }

    private Layer1ApiUserMessageModifyIndicator getUserMessageModify(final String userReadableIndicatorName, Layer1ApiUserMessageModifyIndicator.GraphType graphType, LineStyle lineStyle, int width, final Color defaultColor, final String indicatorAlias, boolean isAdd, OnlineCalculatable onlineCalculatable) {
        Layer1ApiUserMessageModifyIndicator message = Layer1ApiUserMessageModifyIndicator.builder(this.simpleStrategyClass, (String)userReadableIndicatorName).extendFullName(indicatorAlias).setIsAdd(isAdd).setIndicatorColorScheme(new IndicatorColorScheme(){
            private final String defaultColorName;
            {
                this.defaultColorName = userReadableIndicatorName;
            }

            public IndicatorColorScheme.ColorDescription[] getColors() {
                return new IndicatorColorScheme.ColorDescription[]{new IndicatorColorScheme.ColorDescription(SimplifiedL1ApiLoader.this.simpleStrategyClass, this.defaultColorName, defaultColor, false)};
            }

            public IndicatorColorScheme.ColorIntervalResponse getColorIntervalsList(double valueFrom, double valueTo) {
                return new IndicatorColorScheme.ColorIntervalResponse(new String[]{this.defaultColorName}, new double[0]);
            }

            public String getColorFor(Double value) {
                return this.defaultColorName;
            }
        }).setColorInterface((Layer1IndicatorColorInterface)this).setGraphType(graphType).setIsSupportWidget(true).setIsShowColorSettings(false).setIndicatorLineStyle(lineStyle.toIndicatorStyle(width)).setOnlineCalculatable(onlineCalculatable).setAliasFiler(new AliasFilter(){

            public boolean isDisplayedForAlias(String alias) {
                return alias.equals(indicatorAlias);
            }
        }).setWidgetDisplayInfo(new WidgetDisplayInfo(WidgetDisplayInfo.Type.SYMMETRIC, 0.0)).setIsWidgetEnabledByDefault(true).setIsEnableSettingsFromConfigPopup(true).build();
        return message;
    }

    private Layer1ApiUserMessageAddStrategyUpdateGenerator getGeneratorMessage(boolean isAdd, final String targetAlias, final InstanceWrapper listener) {
        return new Layer1ApiUserMessageAddStrategyUpdateGenerator(this.simpleStrategyClass, targetAlias, isAdd, true, (StrategyUpdateGenerator)new StrategyUpdateGeneratorWithFilter(){
            private boolean isRealtime = false;
            private Map<String, OrderBook> orderBooksInGenerator = new HashMap<String, OrderBook>();
            private Map<String, Set<String>> activeOrdersInGenerator = new HashMap<String, Set<String>>();
            private Consumer<CustomGeneratedEventAliased> consumer;
            private long realtimeTransferTime = Long.MAX_VALUE;

            public void setGeneratedEventsConsumer(Consumer<CustomGeneratedEventAliased> consumer) {
                this.consumer = consumer;
            }

            public Consumer<CustomGeneratedEventAliased> getGeneratedEventsConsumer() {
                return this.consumer;
            }

            public void onStatus(StatusInfo statusInfo) {
                if (SimplifiedL1ApiLoader.this.mode == Mode.GENERATORS || !this.isRealtime) {
                    listener.onStatus(statusInfo, true);
                }
            }

            public void onOrderUpdated(OrderInfoUpdate orderInfoUpdate) {
                if (SimplifiedL1ApiLoader.this.mode == Mode.GENERATORS || !this.isRealtime) {
                    listener.onOrderUpdated(orderInfoUpdate, true);
                }
            }

            public void onOrderExecuted(ExecutionInfo executionInfo) {
                if (SimplifiedL1ApiLoader.this.mode == Mode.GENERATORS || !this.isRealtime) {
                    listener.onOrderExecuted(executionInfo, true);
                }
            }

            public void onBalance(BalanceInfo balanceInfo) {
                if (SimplifiedL1ApiLoader.this.mode == Mode.GENERATORS || !this.isRealtime) {
                    listener.onBalance(balanceInfo, true);
                }
            }

            public void onTrade(String alias, double price, int size, TradeInfo tradeInfo) {
                if (SimplifiedL1ApiLoader.this.mode == Mode.GENERATORS || !this.isRealtime) {
                    listener.onTrade(alias, price, size, tradeInfo, true);
                }
            }

            public void onMarketMode(String alias, MarketMode marketMode) {
            }

            public void onDepth(String alias, boolean isBid, int price, int size) {
                if (SimplifiedL1ApiLoader.this.mode == Mode.GENERATORS || !this.isRealtime) {
                    if (this.isInterestedInAlias(alias) && this.isInterestedInMbp()) {
                        this.orderBooksInGenerator.get(alias).onUpdate(isBid, price, (long)size);
                    }
                    listener.onDepth(alias, isBid, price, size, true);
                }
            }

            public void onMboSend(String alias, String orderId, boolean isBid, int price, int size) {
                if (SimplifiedL1ApiLoader.this.mode == Mode.GENERATORS || !this.isRealtime) {
                    if (this.isInterestedInAlias(alias) && this.isInterestedInMbo() && !this.activeOrdersInGenerator.get(alias).add(orderId)) {
                        throw new IllegalStateException("Adding same order ID twice (" + orderId + "@" + alias + ")");
                    }
                    listener.send(alias, orderId, isBid, price, size, true);
                }
            }

            public void onMboReplace(String alias, String orderId, int price, int size) {
                if (SimplifiedL1ApiLoader.this.mode == Mode.GENERATORS || !this.isRealtime) {
                    listener.replace(alias, orderId, price, size, true);
                }
            }

            public void onMboCancel(String alias, String orderId) {
                if (SimplifiedL1ApiLoader.this.mode == Mode.GENERATORS || !this.isRealtime) {
                    if (this.isInterestedInAlias(alias) && this.isInterestedInMbo() && !this.activeOrdersInGenerator.get(alias).remove(orderId)) {
                        throw new IllegalStateException("Order ID does not exist (" + orderId + "@" + alias + ")");
                    }
                    listener.cancel(alias, orderId, true);
                }
            }

            public void onInstrumentAdded(String alias, InstrumentInfo instrumentInfo) {
                if (SimplifiedL1ApiLoader.this.mode == Mode.GENERATORS || !this.isRealtime) {
                    if (this.isInterestedInAlias(alias)) {
                        Set oldMboOrders;
                        OrderBook oldOrderBook;
                        if (this.isInterestedInMbp() && (oldOrderBook = this.orderBooksInGenerator.put(alias, new OrderBook())) != null) {
                            oldOrderBook.getBidMap().keySet().forEach(price -> listener.onDepth(alias, true, (int)price, 0, true));
                            oldOrderBook.getAskMap().keySet().forEach(price -> listener.onDepth(alias, false, (int)price, 0, true));
                        }
                        if (this.isInterestedInMbo() && (oldMboOrders = (Set)this.activeOrdersInGenerator.put(alias, new HashSet())) != null) {
                            oldMboOrders.forEach(orderId -> listener.cancel(alias, (String)orderId, true));
                        }
                    }
                    listener.onInstrumentAdded(alias, instrumentInfo, true);
                }
            }

            public void onInstrumentRemoved(String alias) {
            }

            public void onInstrumentNotFound(String symbol, String exchange, String type) {
            }

            public void onInstrumentAlreadySubscribed(String symbol, String exchange, String type) {
            }

            public void onUserMessage(Object data) {
            }

            public void setTime(long time) {
                if (SimplifiedL1ApiLoader.this.mode == Mode.MIXED && !this.isRealtime) {
                    if (this.realtimeTransferTime == Long.MAX_VALUE && time >= SimplifiedL1ApiLoader.this.getCurrentTime()) {
                        this.realtimeTransferTime = time + 1L;
                    }
                    if (time >= this.realtimeTransferTime) {
                        this.isRealtime = true;
                        listener.onRealtimeStart(time);
                    }
                }
                if (!this.isRealtime) {
                    listener.setTime(time, true);
                }
            }

            public Set<StrategyUpdateGeneratorFilter.StrategyUpdateGeneratorEventType> getGeneratorUpdateTypes() {
                HashSet<StrategyUpdateGeneratorFilter.StrategyUpdateGeneratorEventType> types = new HashSet<StrategyUpdateGeneratorFilter.StrategyUpdateGeneratorEventType>();
                types.add(StrategyUpdateGeneratorFilter.StrategyUpdateGeneratorEventType.INSTRUMENTS);
                types.add(StrategyUpdateGeneratorFilter.StrategyUpdateGeneratorEventType.TRADES);
                types.add(StrategyUpdateGeneratorFilter.StrategyUpdateGeneratorEventType.ORDERS);
                if (this.isInterestedInMbp()) {
                    types.add(StrategyUpdateGeneratorFilter.StrategyUpdateGeneratorEventType.DEPTH_MBP);
                }
                if (this.isInterestedInMbo()) {
                    types.add(StrategyUpdateGeneratorFilter.StrategyUpdateGeneratorEventType.DEPTH_MBO);
                }
                return types;
            }

            private boolean isInterestedInMbo() {
                return listener.marketByOrderDepthDataListeners.size() > 0;
            }

            private boolean isInterestedInMbp() {
                return listener.depthDataListeners.size() + listener.bboDataListeners.size() > 0;
            }

            public Set<String> getGeneratorAliases() {
                if (SimplifiedL1ApiLoader.this.multiInstrument) {
                    return null;
                }
                return Collections.singleton(targetAlias);
            }

            private boolean isInterestedInAlias(String alias) {
                return SimplifiedL1ApiLoader.this.multiInstrument || alias.equals(targetAlias);
            }
        }, new GeneratedEventInfo[]{new GeneratedEventInfo(CustomEvent.class, CustomAggregationEvent.class, CUSTOM_TRADE_EVENTS_AGGREGATOR)});
    }

    public void onInstrumentAdded(String alias, InstrumentInfo instrumentInfo) {
        InstanceUtils.isTypeAllowed(this.simpleStrategyClass, Parameter.class);
        super.onInstrumentAdded(alias, instrumentInfo);
        this.addInstrument(alias, instrumentInfo, new OrderBook(), new OrderBookMbo());
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.onInstrumentAdded(alias, instrumentInfo, false);
            }
        }
    }

    private void addInstrument(String alias, InstrumentInfo instrumentInfo, OrderBook orderBook, OrderBookMbo orderBookMbo) {
        this.instruments.put(alias, instrumentInfo);
        this.orderBooks.put(alias, orderBook);
        this.orderBooksMbo.put(alias, orderBookMbo);
        UserSettings settings = this.getUserSettings(alias);
        if (settings != null && settings.isLoadedAtStartup() && settings.isEnabled()) {
            this.startForInstrument(alias);
        }
    }

    public void onInstrumentRemoved(String alias) {
        super.onInstrumentRemoved(alias);
        this.removeInstrument(alias, true);
    }

    private void removeInstrument(String alias, boolean invalidatePanels) {
        this.stopForInstrument(alias, invalidatePanels);
        this.instruments.remove(alias);
        this.orderBooks.remove(alias);
        this.orderBooksMbo.remove(alias);
    }

    public void onDepth(String alias, boolean isBid, int price, int size) {
        Object orderBook;
        super.onDepth(alias, isBid, price, size);
        if (this.mode == Mode.LIVE && (orderBook = this.orderBooks.get(alias)) != null) {
            orderBook.onUpdate(isBid, price, (long)size);
        }
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.onDepth(alias, isBid, price, size, false);
            }
        } else {
            InstanceWrapper instanceWrapper = this.instanceWrappers.get(alias);
            if (instanceWrapper != null) {
                instanceWrapper.onDepth(alias, isBid, price, size, false);
            }
        }
    }

    public void onMboSend(String alias, String orderId, boolean isBid, int price, int size) {
        Object orderBook;
        super.onMboSend(alias, orderId, isBid, price, size);
        if (this.mode == Mode.LIVE && (orderBook = this.orderBooksMbo.get(alias)) != null) {
            orderBook.send(orderId, isBid, price, size);
        }
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.send(alias, orderId, isBid, price, size, false);
            }
        } else {
            InstanceWrapper instanceWrapper = this.instanceWrappers.get(alias);
            if (instanceWrapper != null) {
                instanceWrapper.send(alias, orderId, isBid, price, size, false);
            }
        }
    }

    public void onMboReplace(String alias, String orderId, int price, int size) {
        Object orderBook;
        super.onMboReplace(alias, orderId, price, size);
        if (this.mode == Mode.LIVE && (orderBook = this.orderBooksMbo.get(alias)) != null) {
            orderBook.replace(orderId, price, size);
        }
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.replace(alias, orderId, price, size, false);
            }
        } else {
            InstanceWrapper instanceWrapper = this.instanceWrappers.get(alias);
            if (instanceWrapper != null) {
                instanceWrapper.replace(alias, orderId, price, size, false);
            }
        }
    }

    public void onMboCancel(String alias, String orderId) {
        Object orderBook;
        super.onMboCancel(alias, orderId);
        if (this.mode == Mode.LIVE && (orderBook = this.orderBooksMbo.get(alias)) != null) {
            orderBook.cancel(orderId);
        }
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.cancel(alias, orderId, false);
            }
        } else {
            InstanceWrapper instanceWrapper = this.instanceWrappers.get(alias);
            if (instanceWrapper != null) {
                instanceWrapper.cancel(alias, orderId, false);
            }
        }
    }

    public void onTrade(String alias, double price, int size, TradeInfo tradeInfo) {
        super.onTrade(alias, price, size, tradeInfo);
        if (this.mode == Mode.LIVE) {
            Object initialState = this.initialStates.get(alias);
            if (initialState == null) {
                initialState = new InitialState();
                this.initialStates.put(alias, (InitialState)initialState);
            }
            ((InitialState)initialState).lastTradePrice = price;
            ((InitialState)initialState).lastTradeSize = size;
            ((InitialState)initialState).tradeInfo = tradeInfo;
        }
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.onTrade(alias, price, size, tradeInfo, false);
            }
        } else {
            InstanceWrapper instanceWrapper = this.instanceWrappers.get(alias);
            if (instanceWrapper != null) {
                instanceWrapper.onTrade(alias, price, size, tradeInfo, false);
            }
        }
    }

    public void onOrderUpdated(OrderInfoUpdate orderInfoUpdate) {
        super.onOrderUpdated(orderInfoUpdate);
        this.orders.put(orderInfoUpdate.orderId, orderInfoUpdate);
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.onOrderUpdated(orderInfoUpdate, false);
            }
        } else {
            InstanceWrapper instanceWrapper = this.instanceWrappers.get(orderInfoUpdate.instrumentAlias);
            if (instanceWrapper != null) {
                instanceWrapper.onOrderUpdated(orderInfoUpdate, false);
            }
        }
    }

    public void onOrderExecuted(ExecutionInfo executionInfo) {
        super.onOrderExecuted(executionInfo);
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.onOrderExecuted(executionInfo, false);
            }
        } else {
            String alias = this.orders.get((Object)executionInfo.orderId).instrumentAlias;
            InstanceWrapper instanceWrapper = this.instanceWrappers.get(alias);
            if (instanceWrapper != null) {
                instanceWrapper.onOrderExecuted(executionInfo, false);
            }
        }
    }

    public void onStatus(StatusInfo statusInfo) {
        super.onStatus(statusInfo);
        this.statuses.put(statusInfo.instrumentAlias, statusInfo);
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.onStatus(statusInfo, false);
            }
        } else {
            InstanceWrapper instanceWrapper = this.instanceWrappers.get(statusInfo.instrumentAlias);
            if (instanceWrapper != null) {
                instanceWrapper.onStatus(statusInfo, false);
            }
        }
    }

    public void onBalance(BalanceInfo balanceInfo) {
        super.onBalance(balanceInfo);
        this.balance = balanceInfo;
        for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
            instanceWrapper.onBalance(balanceInfo, false);
        }
    }

    public Map<String, Layer1PriceAxisRangeCalculatable.ResultPriceAxisInfo> getPriceRanges(String alias, double linesCount, Map<String, Layer1PriceAxisRangeCalculatable.InputPriceAxisInfo> inputInfo) {
        InstanceWrapper instanceWrapper = this.instanceWrappers.get(alias);
        if (instanceWrapper == null) {
            return PriceRangeCalculationHelper.getGoodNumbersCalculation((double)linesCount, inputInfo);
        }
        return instanceWrapper.getPriceRanges(linesCount, inputInfo);
    }

    public UserSettings createUserSettingsFromAnnotations(Object instance, Class<? extends Annotation> clazz, String alias, boolean settingsExist) {
        Map<String, UserSettings.ParameterField> aliasSettings = InstanceUtils.readSettingsFromAnnotations(instance, Parameter.class);
        UserSettings settings = settingsExist ? this.getUserSettings(alias) : new UserSettings();
        settings.setSettings(aliasSettings);
        return settings;
    }

    public void restartInstrument(String alias) {
        this.inject(() -> {
            this.stopForInstrument(alias, false);
            this.startForInstrument(alias);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserSettings getUserSettings(String alias) {
        UserSettingsWrapper wrapper;
        String strategyFullName = this.simpleStrategyClass.getName();
        boolean isTradingStrategy = this.simpleStrategyClass.getAnnotation(Layer1TradingStrategy.class) != null;
        Object object = this.settingsAccessLocker;
        synchronized (object) {
            wrapper = (UserSettingsWrapper)this.settingsAccess.getSettings(alias, strategyFullName, UserSettingsWrapper.class);
        }
        UserSettings settings = wrapper.unwrap(UserSettings.class, UserSettings.ParameterField.class, ParameterFieldDeserializer.class);
        if (settings != null && settings.getLoadSessionId() != this.loadSessionId) {
            Log.info((String)(strategyFullName + ": Strategy settings were saved before it was loaded last time, disabling for " + alias));
            settings.setEnabled(false);
        } else if (settings != null && settings.getRunSessionId() != this.runSessionId && isTradingStrategy) {
            Log.info((String)(strategyFullName + ": Strategy settings from previous session loaded for " + alias + ", disabling since it's a trading strategy."));
            settings.setEnabled(false);
        } else if (settings != null && !StringUtils.equals((CharSequence)settings.getInstrumentAlias(), (CharSequence)alias) && isTradingStrategy) {
            Log.info((String)("Strategy settings were inherited, since it's a trading strategy - disabling for " + alias));
            settings.setEnabled(false);
        }
        return settings;
    }

    public void setWidgetConsumer(String alias, String fullName, WidgetRangeConsumer consumer) {
        IndicatorImplementation implementation;
        InstanceWrapper wrapper = this.instanceWrappers.get(alias);
        if (wrapper != null && (implementation = (IndicatorImplementation)wrapper.indicators.get(fullName)) instanceof WidgetRangeProducer) {
            IndicatorImplementation producer = implementation;
            producer.setWidgetRangeConsumer(consumer);
        }
    }

    static /* synthetic */ Color access$000() {
        return DEFAULT_INDICATOR_COLOR;
    }

    @StrategySettingsVersion(currentVersion=1, compatibleVersions={})
    public static class LoadSessionIdWrapper {
        long loadSessionId = 0L;

        public LoadSessionIdWrapper() {
        }

        public LoadSessionIdWrapper(long loadSessionId) {
            this.loadSessionId = loadSessionId;
        }
    }

    private class InstanceWrapper
    implements Api {
        private static final String DIRECT_SETTINGS_POSTFIX = ".direct";
        private final CustomModule instance;
        private final String alias;
        private Map<String, IndicatorImplementation> indicators = new ConcurrentHashMap<String, IndicatorImplementation>();
        private final List<TimeListener> timeListeners = new ArrayList<TimeListener>();
        private final List<DepthDataListener> depthDataListeners = new ArrayList<DepthDataListener>();
        private final List<MarketByOrderDepthDataListener> marketByOrderDepthDataListeners = new ArrayList<MarketByOrderDepthDataListener>();
        private final List<SnapshotEndListener> snapshotEndListeners = new ArrayList<SnapshotEndListener>();
        private final List<TradeDataListener> tradeDataListeners = new ArrayList<TradeDataListener>();
        private final List<IntervalListener> intervalListeners = new ArrayList<IntervalListener>();
        private final List<BarDataListener> barDataListeners = new ArrayList<BarDataListener>();
        private final List<BboListener> bboDataListeners = new ArrayList<BboListener>();
        private final List<OrdersListener> ordersListeners = new ArrayList<OrdersListener>();
        private final List<PositionListener> statusListeners = new ArrayList<PositionListener>();
        private final List<BalanceListener> balanceListeners = new ArrayList<BalanceListener>();
        private final List<HistoricalModeListener> historicalModeListeners = new ArrayList<HistoricalModeListener>();
        private final List<MultiInstrumentListener> multiInstrumentListeners = new ArrayList<MultiInstrumentListener>();
        private boolean initializing;
        private boolean stopped;
        private long time = 0L;
        private boolean isRealtime = false;
        private long firstRealtimeEventTime = 0L;
        private String currentAlias;
        private Layer1ApiUserMessageAddStrategyUpdateGenerator generatorMessage;
        private long barInterval = -1L;
        private Map<String, Bar> currentBars = new HashMap<String, Bar>();
        private long timeNotificationInterval = -1L;
        private Map<String, OrderBook> submittedOrderBooks = new HashMap<String, OrderBook>();
        private boolean sendingSnapshots = false;
        private HashSet<String> snapshotEndsSent = new HashSet();
        private HashMap<String, Long> firstDepthUpdateTimes = new HashMap();

        public InstanceWrapper(String alias) {
            this.alias = alias;
            try {
                UserSettings settings;
                this.instance = (CustomModule)SimplifiedL1ApiLoader.this.simpleStrategyClass.newInstance();
                String strategyFullName = SimplifiedL1ApiLoader.this.simpleStrategyClass.getName();
                Map<String, UserSettings.ParameterField> settingsMap = InstanceUtils.readDefaultColorSettings(this.instance, Parameter.class);
                if (SimplifiedL1ApiLoader.this.initialUserSettings.get(strategyFullName) == null) {
                    SimplifiedL1ApiLoader.this.initialUserSettings.put(strategyFullName, settingsMap);
                }
                if ((settings = SimplifiedL1ApiLoader.this.getUserSettings(alias)) == null) {
                    settings = SimplifiedL1ApiLoader.this.createUserSettingsFromAnnotations(this.instance, Parameter.class, alias, false);
                    SimplifiedL1ApiLoader.this.settingsChanged(alias, settings);
                } else {
                    InstanceUtils.setValuesFromSettings(settings, this.getInstance(), Parameter.class);
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Failed to create instance", e);
            }
        }

        public CustomModule getInstance() {
            return this.instance;
        }

        public void start() {
            InitialState initialState = SimplifiedL1ApiLoader.this.initialStates.computeIfAbsent(this.alias, k -> new InitialState());
            if (SimplifiedL1ApiLoader.this.mode == Mode.LIVE) {
                initialState.currentTime = SimplifiedL1ApiLoader.this.getCurrentTime();
            }
            this.initializing = true;
            this.instance.initialize(this.alias, (InstrumentInfo)SimplifiedL1ApiLoader.this.instruments.get(this.alias), this, initialState);
            this.initializing = false;
            this.addListener(this.instance);
            if (SimplifiedL1ApiLoader.this.mode == Mode.GENERATORS || SimplifiedL1ApiLoader.this.mode == Mode.MIXED) {
                this.generatorMessage = SimplifiedL1ApiLoader.this.getGeneratorMessage(true, this.alias, this);
                SimplifiedL1ApiLoader.this.provider.sendUserMessage((Object)this.generatorMessage);
            } else {
                this.sendSnapshots();
            }
            Runnable invalidatePannelsFunction = (Runnable)SimplifiedL1ApiLoader.this.invalidatePannelsFunctions.get(this.alias);
            if (invalidatePannelsFunction != null) {
                invalidatePannelsFunction.run();
            }
        }

        private void sendSnapshots() {
            this.sendingSnapshots = true;
            Map instrumentInfosToSend = SimplifiedL1ApiLoader.this.multiInstrument ? SimplifiedL1ApiLoader.this.instruments : Collections.singletonMap(this.alias, SimplifiedL1ApiLoader.this.instruments.get(this.alias));
            for (Map.Entry entry : instrumentInfosToSend.entrySet()) {
                this.onInstrumentAdded((String)entry.getKey(), (InstrumentInfo)entry.getValue(), false);
            }
            Map orderBooksToSend = SimplifiedL1ApiLoader.this.multiInstrument ? SimplifiedL1ApiLoader.this.orderBooks : Collections.singletonMap(this.alias, SimplifiedL1ApiLoader.this.orderBooks.get(this.alias));
            for (Map.Entry entry : orderBooksToSend.entrySet()) {
                String string = (String)entry.getKey();
                OrderBook orderBook = (OrderBook)entry.getValue();
                for (Map.Entry entry2 : orderBook.getBidMap().entrySet()) {
                    this.onDepth(string, true, (Integer)entry2.getKey(), ((Long)entry2.getValue()).intValue(), false);
                }
                for (Map.Entry entry2 : orderBook.getAskMap().entrySet()) {
                    this.onDepth(string, false, (Integer)entry2.getKey(), ((Long)entry2.getValue()).intValue(), false);
                }
            }
            Map map = SimplifiedL1ApiLoader.this.multiInstrument ? SimplifiedL1ApiLoader.this.orderBooksMbo : Collections.singletonMap(this.alias, SimplifiedL1ApiLoader.this.orderBooksMbo.get(this.alias));
            for (Map.Entry entry : map.entrySet()) {
                String alias = (String)entry.getKey();
                OrderBookMbo orderBook = (OrderBookMbo)entry.getValue();
                orderBook.sendDataToListener(alias, (Layer1ApiMboDataListener)new Layer1ApiMboDataAdapter(){

                    public void onMboSend(String alias, String orderId, boolean isBid, int price, int size) {
                        InstanceWrapper.this.send(alias, orderId, isBid, price, size, false);
                    }
                });
            }
            for (Map.Entry entry : SimplifiedL1ApiLoader.this.orders.entrySet()) {
                this.onOrderUpdated((OrderInfoUpdate)entry.getValue(), false);
            }
            Map map2 = SimplifiedL1ApiLoader.this.multiInstrument ? SimplifiedL1ApiLoader.this.statuses : (SimplifiedL1ApiLoader.this.statuses.containsKey(this.alias) ? Collections.singletonMap(this.alias, SimplifiedL1ApiLoader.this.statuses.get(this.alias)) : Collections.emptyMap());
            for (Map.Entry entry : map2.entrySet()) {
                this.onStatus((StatusInfo)entry.getValue(), false);
            }
            if (SimplifiedL1ApiLoader.this.balance != null) {
                this.onBalance(SimplifiedL1ApiLoader.this.balance, false);
            }
            this.sendingSnapshots = false;
        }

        public void stop(boolean invalidatePanels) {
            Runnable invalidatePannelsFunction;
            this.stopped = true;
            this.instance.stop();
            this.indicators.values().forEach(IndicatorImplementation::remove);
            Layer1ApiUserMessageAddStrategyUpdateGenerator generatorMessage = SimplifiedL1ApiLoader.this.getGeneratorMessage(false, this.alias, this);
            SimplifiedL1ApiLoader.this.provider.sendUserMessage((Object)generatorMessage);
            if (invalidatePanels && (invalidatePannelsFunction = (Runnable)SimplifiedL1ApiLoader.this.invalidatePannelsFunctions.get(this.alias)) != null) {
                invalidatePannelsFunction.run();
            }
        }

        public void addListener(Object simplifiedListener) {
            if (SimplifiedL1ApiLoader.this.simpleStrategyClass.isAnnotationPresent(NoAutosubscription.class)) {
                return;
            }
            if (simplifiedListener instanceof TimeListener) {
                this.timeNotificationInterval = -1L;
                this.timeListeners.add((TimeListener)simplifiedListener);
            }
            if (simplifiedListener instanceof DepthDataListener) {
                this.depthDataListeners.add((DepthDataListener)simplifiedListener);
            }
            if (simplifiedListener instanceof MarketByOrderDepthDataListener) {
                this.marketByOrderDepthDataListeners.add((MarketByOrderDepthDataListener)simplifiedListener);
            }
            if (simplifiedListener instanceof SnapshotEndListener) {
                this.snapshotEndListeners.add((SnapshotEndListener)simplifiedListener);
            }
            if (simplifiedListener instanceof TradeDataListener) {
                this.tradeDataListeners.add((TradeDataListener)simplifiedListener);
            }
            if (simplifiedListener instanceof IntervalListener) {
                this.barInterval = ((IntervalListener)((Object)this.instance)).getInterval();
                if (this.barInterval < Intervals.MIN_INTERVAL) {
                    throw new IllegalArgumentException("BarDataListener#getBarInterval < Intervals#MIN_INTERVAL (" + this.barInterval + ")");
                }
                this.intervalListeners.add((IntervalListener)simplifiedListener);
            }
            if (simplifiedListener instanceof BarDataListener) {
                this.barDataListeners.add((BarDataListener)simplifiedListener);
            }
            if (simplifiedListener instanceof BboListener) {
                this.bboDataListeners.add((BboListener)simplifiedListener);
            }
            if (simplifiedListener instanceof OrdersListener) {
                this.ordersListeners.add((OrdersListener)simplifiedListener);
            }
            if (simplifiedListener instanceof PositionListener) {
                this.statusListeners.add((PositionListener)simplifiedListener);
            }
            if (simplifiedListener instanceof BalanceListener) {
                this.balanceListeners.add((BalanceListener)simplifiedListener);
            }
            if (simplifiedListener instanceof HistoricalModeListener) {
                this.historicalModeListeners.add((HistoricalModeListener)simplifiedListener);
            }
            if (simplifiedListener instanceof MultiInstrumentListener) {
                this.multiInstrumentListeners.add((MultiInstrumentListener)simplifiedListener);
            }
        }

        @Override
        public Indicator registerIndicator(String name, Layer1ApiUserMessageModifyIndicator.GraphType graphType, double initialValue) {
            if (!this.initializing) {
                throw new IllegalStateException("Registering indicators is only allowed inside CustomModule#initialize");
            }
            IndicatorImplementation indicatorImplementation = SimplifiedL1ApiLoader.this.mode == Mode.GENERATORS ? new IndicatorGeneratorImplementation(this.alias, name, graphType, this, generatorIndicatorIncrementalId.getAndIncrement(), initialValue) : new IndicatorBasicImplementation(this.alias, name, graphType, initialValue, this);
            indicatorImplementation.register();
            this.indicators.put(indicatorImplementation.getFullName(), indicatorImplementation);
            return indicatorImplementation;
        }

        @Override
        public IndicatorModifiable registerIndicatorModifiable(String name, Layer1ApiUserMessageModifyIndicator.GraphType graphType, double initialValue) {
            if (!this.initializing) {
                throw new IllegalStateException("Registering indicators is only allowed inside CustomModule#initialize");
            }
            IndicatorModifiableBasicImplementation indicatorImplementation = new IndicatorModifiableBasicImplementation(this.alias, name, graphType, initialValue, this);
            indicatorImplementation.register();
            this.indicators.put(indicatorImplementation.getFullName(), indicatorImplementation);
            return indicatorImplementation;
        }

        public void onDepth(String alias, boolean isBid, int price, int size, boolean fromGenerator) {
            if (this.eventShouldBePublished(fromGenerator) && (SimplifiedL1ApiLoader.this.multiInstrument || this.alias.equals(alias))) {
                this.setCurrentAlias(alias);
                if (!this.bboDataListeners.isEmpty() || !this.barDataListeners.isEmpty()) {
                    OrderBook submittedOrderBook = this.submittedOrderBooks.get(alias);
                    if (submittedOrderBook == null) {
                        submittedOrderBook = new OrderBook();
                        this.submittedOrderBooks.put(alias, submittedOrderBook);
                    }
                    submittedOrderBook.onUpdate(isBid, price, (long)size);
                    if (!this.bboDataListeners.isEmpty()) {
                        int bestPriceOnSameSide;
                        int n = bestPriceOnSameSide = isBid ? submittedOrderBook.getBestBidPriceOrNone() : submittedOrderBook.getBestAskPriceOrNone();
                        if (price == bestPriceOnSameSide) {
                            Map.Entry firstBidEntry = submittedOrderBook.getBidMap().firstEntry();
                            Map.Entry firstAskEntry = submittedOrderBook.getAskMap().firstEntry();
                            if (firstBidEntry != null && firstAskEntry != null) {
                                for (BboListener listener : this.bboDataListeners) {
                                    listener.onBbo((Integer)firstBidEntry.getKey(), ((Long)firstBidEntry.getValue()).intValue(), (Integer)firstAskEntry.getKey(), ((Long)firstAskEntry.getValue()).intValue());
                                }
                            }
                        }
                    }
                }
                this.invokeCurrentTimeListeners(fromGenerator, true);
                boolean snapshotEndSent = this.snapshotEndsSent.contains(alias);
                long firstDepthUpdateTime = this.firstDepthUpdateTimes.getOrDefault(alias, -1L);
                if (!snapshotEndSent && firstDepthUpdateTime == -1L) {
                    firstDepthUpdateTime = this.time;
                    this.firstDepthUpdateTimes.put(alias, firstDepthUpdateTime);
                }
                if (!snapshotEndSent && !this.sendingSnapshots && this.time > firstDepthUpdateTime) {
                    this.invokeSnapshotEndListeners(alias);
                }
                for (DepthDataListener listener : this.depthDataListeners) {
                    listener.onDepth(isBid, price, size);
                }
            }
        }

        public void send(String alias, String orderId, boolean isBid, int price, int size, boolean fromGenerator) {
            if (this.eventShouldBePublished(fromGenerator) && (SimplifiedL1ApiLoader.this.multiInstrument || this.alias.equals(alias))) {
                this.setCurrentAlias(alias);
                this.invokeCurrentTimeListeners(fromGenerator, true);
                for (MarketByOrderDepthDataListener listener : this.marketByOrderDepthDataListeners) {
                    listener.send(orderId, isBid, price, size);
                }
            }
        }

        public void replace(String alias, String orderId, int price, int size, boolean fromGenerator) {
            if (this.eventShouldBePublished(fromGenerator) && (SimplifiedL1ApiLoader.this.multiInstrument || this.alias.equals(alias))) {
                this.setCurrentAlias(alias);
                this.invokeCurrentTimeListeners(fromGenerator, true);
                for (MarketByOrderDepthDataListener listener : this.marketByOrderDepthDataListeners) {
                    listener.replace(orderId, price, size);
                }
            }
        }

        public void cancel(String alias, String orderId, boolean fromGenerator) {
            if (this.eventShouldBePublished(fromGenerator) && (SimplifiedL1ApiLoader.this.multiInstrument || this.alias.equals(alias))) {
                this.setCurrentAlias(alias);
                this.invokeCurrentTimeListeners(fromGenerator, true);
                for (MarketByOrderDepthDataListener listener : this.marketByOrderDepthDataListeners) {
                    listener.cancel(orderId);
                }
            }
        }

        private void invokeSnapshotEndListeners(String alias) {
            for (SnapshotEndListener listener : this.snapshotEndListeners) {
                listener.onSnapshotEnd();
            }
            this.snapshotEndsSent.add(alias);
        }

        public void onTrade(String alias, double price, int size, TradeInfo tradeInfo, boolean fromGenerator) {
            if (this.eventShouldBePublished(fromGenerator) && (SimplifiedL1ApiLoader.this.multiInstrument || this.alias.equals(alias))) {
                Bar currentBar;
                this.setCurrentAlias(alias);
                if (!this.snapshotEndsSent.contains(alias)) {
                    this.invokeSnapshotEndListeners(alias);
                }
                if ((currentBar = this.currentBars.get(alias)) == null) {
                    currentBar = new Bar();
                    this.currentBars.put(alias, currentBar);
                }
                currentBar.addTrade(tradeInfo.isBidAggressor, size, price);
                this.invokeCurrentTimeListeners(fromGenerator, true);
                for (TradeDataListener listener : this.tradeDataListeners) {
                    listener.onTrade(price, size, tradeInfo);
                }
            }
        }

        public void onOrderUpdated(OrderInfoUpdate orderInfoUpdate, boolean fromGenerator) {
            if (this.eventShouldBePublished(fromGenerator) && (SimplifiedL1ApiLoader.this.multiInstrument || this.alias.equals(this.alias))) {
                this.setCurrentAlias(this.alias);
                this.invokeCurrentTimeListeners(fromGenerator, true);
                for (OrdersListener listener : this.ordersListeners) {
                    listener.onOrderUpdated(orderInfoUpdate);
                }
            }
        }

        public void onOrderExecuted(ExecutionInfo executionInfo, boolean fromGenerator) {
            if (this.eventShouldBePublished(fromGenerator) && (SimplifiedL1ApiLoader.this.multiInstrument || this.alias.equals(this.alias))) {
                this.setCurrentAlias(this.alias);
                this.invokeCurrentTimeListeners(fromGenerator, true);
                for (OrdersListener listener : this.ordersListeners) {
                    listener.onOrderExecuted(executionInfo);
                }
            }
        }

        public void onStatus(StatusInfo statusInfo, boolean fromGenerator) {
            if (this.eventShouldBePublished(fromGenerator) && (SimplifiedL1ApiLoader.this.multiInstrument || this.alias.equals(this.alias))) {
                this.setCurrentAlias(this.alias);
                this.invokeCurrentTimeListeners(fromGenerator, true);
                for (PositionListener listener : this.statusListeners) {
                    listener.onPositionUpdate(statusInfo);
                }
            }
        }

        public void onBalance(BalanceInfo balanceInfo, boolean fromGenerator) {
            if (this.eventShouldBePublished(fromGenerator) && (SimplifiedL1ApiLoader.this.multiInstrument || this.alias.equals(this.alias))) {
                this.setCurrentAlias(this.alias);
                this.invokeCurrentTimeListeners(fromGenerator, true);
                for (BalanceListener listener : this.balanceListeners) {
                    listener.onBalance(SimplifiedL1ApiLoader.this.balance);
                }
            }
        }

        private boolean eventShouldBePublished(boolean fromGenerator) {
            if (this.stopped) {
                return false;
            }
            switch (SimplifiedL1ApiLoader.this.mode) {
                case GENERATORS: {
                    return fromGenerator;
                }
                case LIVE: {
                    return !fromGenerator;
                }
                case MIXED: {
                    if (this.isRealtime) {
                        return !fromGenerator && SimplifiedL1ApiLoader.this.getCurrentTime() >= this.firstRealtimeEventTime;
                    }
                    return fromGenerator;
                }
            }
            throw new UnsupportedOperationException("Unknown mode " + (Object)((Object)SimplifiedL1ApiLoader.this.mode));
        }

        private void invokeCurrentTimeListeners(boolean fromGenerator, boolean setTime) {
            if (setTime && !fromGenerator) {
                this.setTime(SimplifiedL1ApiLoader.this.getCurrentTime(), fromGenerator);
            }
            for (TimeListener listener : this.timeListeners) {
                listener.onTimestamp(this.time);
            }
        }

        private void setCurrentAlias(String currentAlias) {
            if (!currentAlias.equals(this.currentAlias)) {
                this.currentAlias = currentAlias;
                for (MultiInstrumentListener listener : this.multiInstrumentListeners) {
                    listener.onCurrentInstrument(currentAlias);
                }
            }
        }

        public void onInstrumentAdded(String alias, InstrumentInfo instrumentInfo, boolean fromGenerator) {
            if (this.eventShouldBePublished(fromGenerator) && SimplifiedL1ApiLoader.this.multiInstrument) {
                this.setCurrentAlias(alias);
                this.invokeCurrentTimeListeners(fromGenerator, true);
                for (MultiInstrumentListener listener : this.multiInstrumentListeners) {
                    listener.onInstrumentAdded(instrumentInfo);
                }
            }
        }

        public void setTime(long newTime, boolean fromGenerator) {
            if (!this.eventShouldBePublished(fromGenerator)) {
                return;
            }
            if (this.time != 0L) {
                while (this.getNextKeyTime(this.barInterval) <= newTime || this.getNextKeyTime(this.timeNotificationInterval) <= newTime) {
                    long notificationKeyTime;
                    long barKeyTime = this.getNextKeyTime(this.barInterval);
                    if (barKeyTime <= (notificationKeyTime = this.getNextKeyTime(this.timeNotificationInterval))) {
                        this.time = barKeyTime;
                        Map<String, OrderBook> orderBooksMap = SimplifiedL1ApiLoader.this.multiInstrument ? this.submittedOrderBooks : Collections.singletonMap(this.alias, this.submittedOrderBooks.get(this.alias));
                        for (Map.Entry<String, OrderBook> entry : orderBooksMap.entrySet()) {
                            String alias = entry.getKey();
                            OrderBook orderBook = entry.getValue();
                            Bar bar = this.currentBars.get(alias);
                            if (bar != null) {
                                Bar nextBar = new Bar(bar);
                                nextBar.startNext();
                                this.currentBars.put(alias, nextBar);
                            } else {
                                bar = new Bar();
                            }
                            this.invokeCurrentTimeListeners(fromGenerator, false);
                            for (IntervalListener intervalListener : this.intervalListeners) {
                                intervalListener.onInterval();
                            }
                            for (BarDataListener barDataListener : this.barDataListeners) {
                                barDataListener.onBar(orderBook, bar);
                            }
                        }
                        continue;
                    }
                    this.time = notificationKeyTime;
                    this.invokeCurrentTimeListeners(fromGenerator, false);
                }
            }
            this.time = newTime;
        }

        private long getNextKeyTime(long interval) {
            if (interval <= 0L) {
                return Long.MAX_VALUE;
            }
            long remainder = this.time % interval;
            if (remainder == 0L) {
                return this.time + interval;
            }
            return this.time + interval - remainder;
        }

        public long getTime() {
            return this.time;
        }

        public void onRealtimeStart(long firstRealtimeEventTime) {
            this.firstRealtimeEventTime = firstRealtimeEventTime;
            this.isRealtime = true;
            for (HistoricalModeListener listener : this.historicalModeListeners) {
                listener.onRealtimeStart();
            }
        }

        @Override
        public void sendOrder(OrderSendParameters orderSendParameters) {
            SimplifiedL1ApiLoader.this.sendOrder(orderSendParameters);
        }

        @Override
        public void updateOrder(OrderUpdateParameters orderUpdateParameters) {
            SimplifiedL1ApiLoader.this.updateOrder(orderUpdateParameters);
        }

        public <ST> ST getSettings(Class<? extends ST> settingsClass) {
            return (ST)SimplifiedL1ApiLoader.this.settingsAccess.getSettings(this.alias, SimplifiedL1ApiLoader.this.simpleStrategyClass.getCanonicalName() + DIRECT_SETTINGS_POSTFIX, settingsClass);
        }

        public <ST> void setSettings(ST settingsObject) {
            SimplifiedL1ApiLoader.this.settingsAccess.setSettings(this.alias, SimplifiedL1ApiLoader.this.simpleStrategyClass.getCanonicalName() + DIRECT_SETTINGS_POSTFIX, settingsObject, settingsObject.getClass());
        }

        @Override
        public void unload() {
            if (!this.stopped) {
                SwingUtilities.invokeLater(() -> {
                    SimplifiedL1ApiLoader.this.onStrategyCheckboxEnabled(this.alias, false);
                    Runnable strategyEnabledRecheckCallback = (Runnable)SimplifiedL1ApiLoader.this.strategyEnabledRecheckCallbacks.get(this.alias);
                    if (strategyEnabledRecheckCallback != null) {
                        strategyEnabledRecheckCallback.run();
                    }
                });
            }
        }

        @Override
        public void reload() {
            if (!this.stopped) {
                this.stopped = true;
                SimplifiedL1ApiLoader.this.inject(() -> {
                    SimplifiedL1ApiLoader.this.stopForInstrument(this.alias, false);
                    SimplifiedL1ApiLoader.this.startForInstrument(this.alias);
                });
            }
        }

        public StrategyPanel[] getCustomSettingsPanels() {
            StrategyPanel[] panels = ((CustomSettingsPanelProvider)((Object)this.instance)).getCustomSettingsPanels();
            return panels;
        }

        public Map<String, Layer1PriceAxisRangeCalculatable.ResultPriceAxisInfo> getPriceRanges(double linesCount, Map<String, Layer1PriceAxisRangeCalculatable.InputPriceAxisInfo> inputInfo) {
            HashMap<String, Layer1PriceAxisRangeCalculatable.ResultPriceAxisInfo> result = new HashMap<String, Layer1PriceAxisRangeCalculatable.ResultPriceAxisInfo>();
            for (Map.Entry<String, Layer1PriceAxisRangeCalculatable.InputPriceAxisInfo> entry : inputInfo.entrySet()) {
                AxisRules axisRules;
                String fullName = entry.getKey();
                IndicatorImplementation indicator = this.indicators.get(fullName);
                AxisGroup axisGroup = indicator.getAxisGroup();
                List<Indicator> rangeInputIndicators = axisGroup == null ? Collections.singletonList(indicator) : axisGroup.getIndicators();
                double minMinValue = Double.POSITIVE_INFINITY;
                double maxMaxValue = Double.NEGATIVE_INFINITY;
                for (IndicatorImplementation indicatorImplementation : rangeInputIndicators) {
                    Layer1PriceAxisRangeCalculatable.InputPriceAxisInfo inputPriceAxisInfo = inputInfo.get(indicatorImplementation.getFullName());
                    if (inputPriceAxisInfo == null) continue;
                    minMinValue = Math.min(minMinValue, inputPriceAxisInfo.minValue);
                    maxMaxValue = Math.max(maxMaxValue, inputPriceAxisInfo.maxValue);
                }
                AxisRules axisRules2 = axisRules = axisGroup == null ? indicator.getAxisRules() : axisGroup.getAxisRules();
                if (axisRules == null) {
                    axisRules = new AxisRules();
                }
                Pair<Double, Double> pair = axisRules.apply(minMinValue, maxMaxValue);
                result.put(fullName, PriceRangeCalculationHelper.getGoodNumbersCalculation((double)((Double)pair.getLeft()), (double)((Double)pair.getRight()), (double)linesCount));
            }
            return result;
        }

        @Override
        public void addTimeListeners(TimeListener timeListener) {
            this.checkIfManualSubscriptionAllowed();
            this.timeNotificationInterval = -1L;
            this.timeListeners.add(timeListener);
        }

        @Override
        public void addDepthDataListeners(DepthDataListener depthDataListener) {
            this.checkIfManualSubscriptionAllowed();
            this.depthDataListeners.add(depthDataListener);
        }

        @Override
        public void addMarketByOrderDepthDataListeners(MarketByOrderDepthDataListener marketByOrderDepthDataListener) {
            this.checkIfManualSubscriptionAllowed();
            this.marketByOrderDepthDataListeners.add(marketByOrderDepthDataListener);
        }

        @Override
        public void addSnapshotEndListeners(SnapshotEndListener snapshotEndListener) {
            this.checkIfManualSubscriptionAllowed();
            this.snapshotEndListeners.add(snapshotEndListener);
        }

        @Override
        public void addTradeDataListeners(TradeDataListener tradeDataListener) {
            this.checkIfManualSubscriptionAllowed();
            this.tradeDataListeners.add(tradeDataListener);
        }

        @Override
        public void addIntervalListeners(IntervalListener intervalListener) {
            this.checkIfManualSubscriptionAllowed();
            this.barInterval = ((IntervalListener)((Object)this.instance)).getInterval();
            if (this.barInterval < Intervals.MIN_INTERVAL) {
                throw new IllegalArgumentException("BarDataListener#getBarInterval < Intervals#MIN_INTERVAL (" + this.barInterval + ")");
            }
            this.intervalListeners.add(intervalListener);
        }

        @Override
        public void addBarDataListeners(BarDataListener barDataListener) {
            this.checkIfManualSubscriptionAllowed();
            this.barDataListeners.add(barDataListener);
        }

        @Override
        public void addBboDataListeners(BboListener bboListener) {
            this.checkIfManualSubscriptionAllowed();
            this.bboDataListeners.add(bboListener);
        }

        @Override
        public void addOrdersListeners(OrdersListener ordersListener) {
            this.checkIfManualSubscriptionAllowed();
            this.ordersListeners.add(ordersListener);
        }

        @Override
        public void addStatusListeners(PositionListener positionListener) {
            this.checkIfManualSubscriptionAllowed();
            this.statusListeners.add(positionListener);
        }

        @Override
        public void addBalanceListeners(BalanceListener balanceListener) {
            this.checkIfManualSubscriptionAllowed();
            this.balanceListeners.add(balanceListener);
        }

        @Override
        public void addHistoricalModeListeners(HistoricalModeListener historicalModeListener) {
            this.checkIfManualSubscriptionAllowed();
            this.historicalModeListeners.add(historicalModeListener);
        }

        @Override
        public void addMultiInstrumentListeners(MultiInstrumentListener multiInstrumentListener) {
            this.checkIfManualSubscriptionAllowed();
            this.multiInstrumentListeners.add(multiInstrumentListener);
        }

        private void checkIfManualSubscriptionAllowed() {
            if (!SimplifiedL1ApiLoader.this.simpleStrategyClass.isAnnotationPresent(NoAutosubscription.class)) {
                throw new IllegalAccessError("This method can only be used if annotation @" + NoAutosubscription.class.getSimpleName() + " is present");
            }
        }
    }

    private class IndicatorGeneratorImplementation
    extends IndicatorImplementation {
        private final int generatorIndicatorId;

        public IndicatorGeneratorImplementation(String alias, String name, Layer1ApiUserMessageModifyIndicator.GraphType graphType, InstanceWrapper wrapper, int generatorIndicatorId, double initialValue) {
            super(alias, name, graphType, initialValue, wrapper);
            this.generatorIndicatorId = generatorIndicatorId;
        }

        public void calculateValuesInRange(String indicatorName, String indicatorAlias, long t0, long intervalWidth, int intervalsNumber, CalculatedResultListener listener) {
            List result;
            Point currentPoint;
            if (intervalsNumber == 0) {
                listener.setCompleted();
                return;
            }
            if (WidgetRulesCalculator.isCalculationOrReportingAllowed(this.consumer, this.widgetRules, this.widgetGroup)) {
                long time = t0 + (long)intervalsNumber * intervalWidth;
                if (!this.spannedWidgetRanges.isEmpty() && (Long)((ImmutablePair)this.spannedWidgetRanges.get((int)0)).left < time) {
                    this.calculateAndReportWidgetRange(time);
                }
            }
            if ((currentPoint = this.getValueFromEvent((DataStructureInterface.TreeResponseInterval)(result = SimplifiedL1ApiLoader.this.dataStructureInterface.get(SimplifiedL1ApiLoader.this.simpleStrategyClass, this.alias, t0, intervalWidth, intervalsNumber, this.alias, new Class[]{CustomEvent.class})).get(0))) == null) {
                currentPoint = new Point(this.initialValue, 1);
            }
            Point previousResponse = currentPoint;
            for (int i = 1; i <= intervalsNumber; ++i) {
                Point response = this.getValueFromEvent((DataStructureInterface.TreeResponseInterval)result.get(i));
                if (response != null) {
                    currentPoint = response;
                }
                if (currentPoint == null) continue;
                double value = previousResponse.getSectionNumber() != currentPoint.getSectionNumber() ? Double.NaN : currentPoint.getValue();
                previousResponse = currentPoint;
                listener.provideResponse((Object)value);
            }
            listener.setCompleted();
        }

        private Point getValueFromEvent(DataStructureInterface.TreeResponseInterval treeResponseInterval) {
            Object object = treeResponseInterval.events.get(CustomEvent.class.toString());
            if (object != null) {
                return ((CustomAggregationEvent)object).indicators.get(this.generatorIndicatorId);
            }
            return null;
        }

        public OnlineValueCalculatorAdapter createOnlineValueCalculator(String indicatorName, final String indicatorAlias, long time, final Consumer<Object> listener, InvalidateInterface invalidateInterface) {
            return new OnlineValueCalculatorAdapter(){

                public void onUserMessage(Object data) {
                    if (data instanceof CustomGeneratedEventAliased) {
                        CustomGeneratedEventAliased aliasedEvent = (CustomGeneratedEventAliased)data;
                        if (indicatorAlias.equals(aliasedEvent.alias) && aliasedEvent.event instanceof CustomEvent) {
                            CustomEvent event = (CustomEvent)aliasedEvent.event;
                            if (event.indicatorId == IndicatorGeneratorImplementation.this.generatorIndicatorId) {
                                if (WidgetRulesCalculator.isCalculationOrReportingAllowed(IndicatorGeneratorImplementation.this.consumer, IndicatorGeneratorImplementation.this.widgetRules, IndicatorGeneratorImplementation.this.widgetGroup)) {
                                    long actualTime = event.getTime();
                                    IndicatorGeneratorImplementation.this.calculateAndReportWidgetRange(actualTime);
                                }
                                listener.accept(event.indicatorPoint.getValue());
                            }
                        }
                    }
                }
            };
        }

        @Override
        public void addPoint(double value) {
            Point point;
            if (Double.isNaN(value)) {
                point = new Point(value);
                ++this.sectionNumber;
            } else {
                point = new Point(value, this.sectionNumber);
            }
            ((InstanceWrapper)this.wrapper).generatorMessage.generator.getGeneratedEventsConsumer().accept(new CustomGeneratedEventAliased((CustomGeneratedEvent)new CustomEvent(this.wrapper.getTime(), this.generatorIndicatorId, point), this.alias));
            if (!Double.isNaN(value) && this.widgetRules != null && this.widgetRules.getLifeSpan() != Long.MAX_VALUE) {
                long time = this.wrapper.getTime();
                if (this.nextTime == 0L) {
                    this.nextTime = time + this.widgetRules.getLifeSpan() / 100L;
                }
                ImmutableTriple<Double, Double, Long> returnedValues = WidgetRulesCalculator.processPoint(value, time, this.nextTime, this.lower, this.upper, this.widgetRules, this.sampledWidgetRanges, this.spannedWidgetRanges);
                this.lower = (Double)returnedValues.left;
                this.upper = (Double)returnedValues.middle;
                this.nextTime = (Long)returnedValues.right;
            } else if (this.widgetGroup != null) {
                this.latestReportedLower = WidgetRulesCalculator.initializeOrUpdateLower(this.latestReportedLower, value);
                this.latestReportedUpper = WidgetRulesCalculator.initializeOrUpdateUpper(this.latestReportedUpper, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWidgetLifeSpanChanges(long lifeSpan) {
            List list = this.spannedWidgetRanges;
            synchronized (list) {
                List list2 = this.sampledWidgetRanges;
                synchronized (list2) {
                    this.spannedWidgetRanges = new LinkedList();
                    this.sampledWidgetRanges = new LinkedList();
                    if (SimplifiedL1ApiLoader.this.dataStructureInterface != null) {
                        long widgetRangeT0 = this.wrapper.getTime();
                        long nextTime = 0L;
                        List result = SimplifiedL1ApiLoader.this.dataStructureInterface.get(SimplifiedL1ApiLoader.this.simpleStrategyClass, this.alias, widgetRangeT0 - this.widgetRules.getLifeSpan(), this.widgetRules.getLifeSpan() / 100L, 101, this.alias, new Class[]{CustomEvent.class});
                        DataStructureInterface.TreeResponseInterval initialInterval = (DataStructureInterface.TreeResponseInterval)result.get(0);
                        if (!initialInterval.events.isEmpty()) {
                            Point currentValue = this.getValueFromEvent((DataStructureInterface.TreeResponseInterval)result.get(0));
                            for (int i = 1; i <= 101; ++i) {
                                Point newValue = this.getValueFromEvent((DataStructureInterface.TreeResponseInterval)result.get(i));
                                if (newValue != null) {
                                    currentValue = newValue;
                                }
                                if (Double.isNaN(currentValue.getValue())) continue;
                                long time = widgetRangeT0 + this.widgetRules.getLifeSpan() / 100L * (long)i;
                                if (nextTime == 0L) {
                                    nextTime = widgetRangeT0 + this.widgetRules.getLifeSpan() / 100L;
                                }
                                ImmutableTriple<Double, Double, Long> returnedValues = WidgetRulesCalculator.processPoint(currentValue.getValue(), time, nextTime, this.lower, this.upper, this.widgetRules, this.sampledWidgetRanges, this.spannedWidgetRanges);
                                this.lower = (Double)returnedValues.left;
                                this.upper = (Double)returnedValues.middle;
                                nextTime = (Long)returnedValues.right;
                            }
                        }
                    }
                }
            }
        }
    }

    private class IndicatorModifiableBasicImplementation
    extends IndicatorBasicImplementation
    implements IndicatorModifiable {
        private InvalidateInterface invalidateInerface;
        private long t0;
        private long intervalWidth;
        private long intervalsNumber;
        private AtomicBoolean isTimerLaunched;
        private final int timerDelayMillis = 200;

        public IndicatorModifiableBasicImplementation(String alias, String name, Layer1ApiUserMessageModifyIndicator.GraphType graphType, double initialValue, InstanceWrapper wrapper) {
            super(alias, name, graphType, initialValue, wrapper);
            this.timerDelayMillis = 200;
            this.isTimerLaunched = new AtomicBoolean(false);
        }

        @Override
        public void calculateValuesInRange(String indicatorName, String indicatorAlias, long t0, long intervalWidth, int intervalsNumber, CalculatedResultListener listener) {
            this.t0 = t0;
            this.intervalWidth = intervalWidth;
            this.intervalsNumber = intervalsNumber;
            super.calculateValuesInRange(indicatorName, indicatorAlias, t0, intervalWidth, intervalsNumber, listener);
        }

        @Override
        public OnlineValueCalculatorAdapter createOnlineValueCalculator(String indicatorName, String indicatorAlias, long time, final Consumer<Object> listener, InvalidateInterface invalidateInterface) {
            this.invalidateInerface = invalidateInterface;
            return new IndicatorBasicImplementation.OnlineCalculator(listener){

                @Override
                public void onLeftTimeChanged(long leftTime) {
                    IndicatorModifiableBasicImplementation.this.t0 = leftTime;
                    this.sendRelevantValue(listener);
                }

                public void onIntervalWidth(long intervalWidth) {
                    IndicatorModifiableBasicImplementation.this.intervalWidth = intervalWidth;
                }

                public void onIntervalsNumber(int intervalsNumber) {
                    IndicatorModifiableBasicImplementation.this.intervalsNumber = intervalsNumber;
                }
            };
        }

        @Override
        protected long getPointTime() {
            long time = SimplifiedL1ApiLoader.this.mode == Mode.GENERATORS ? this.wrapper.getTime() : (SimplifiedL1ApiLoader.this.mode == Mode.MIXED && !this.wrapper.isRealtime ? this.wrapper.getTime() : SimplifiedL1ApiLoader.this.getCurrentTime());
            return time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear(long fromTimestamp, long toTimestamp) {
            TreeMap treeMap = this.points;
            synchronized (treeMap) {
                this.points.subMap(fromTimestamp, toTimestamp).clear();
                if ((this.isWithinScreen(fromTimestamp) || this.isWithinScreen(toTimestamp) || this.isNextLeft(fromTimestamp) && this.isNextRight(toTimestamp)) && this.invalidateInerface != null) {
                    this.invalidateInterfaceWithDelay(200);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPoint(long timestamp, double value) {
            TreeMap treeMap = this.points;
            synchronized (treeMap) {
                Point newPoint;
                if (Double.isNaN(value)) {
                    newPoint = new Point(value);
                    long key = timestamp;
                    if (!this.isPreviousNullOrNan(this.points, key) && !this.isNextNullOrNan(this.points, key)) {
                        boolean isSectionEnd = false;
                        boolean isSectionNumberChanged = false;
                        while (isSectionEnd) {
                            Map.Entry higherEntry = this.points.higherEntry(key);
                            if (higherEntry == null) {
                                isSectionEnd = true;
                                continue;
                            }
                            Point nextPoint = (Point)higherEntry.getValue();
                            if (Double.isNaN(nextPoint.getValue())) {
                                isSectionEnd = true;
                                continue;
                            }
                            if (!isSectionNumberChanged) {
                                isSectionNumberChanged = true;
                                ++this.sectionNumber;
                            }
                            nextPoint.setSectionNumber(this.sectionNumber);
                            key = higherEntry.getKey();
                        }
                    } else {
                        ++this.sectionNumber;
                    }
                } else {
                    newPoint = new Point(value, this.sectionNumber);
                }
                this.points.put(timestamp, newPoint);
                if ((this.isWithinScreen(timestamp) || this.isNextToScreen(timestamp)) && this.invalidateInerface != null) {
                    this.invalidateInterfaceWithDelay(200);
                }
            }
        }

        private boolean isPreviousNullOrNan(TreeMap<Long, Point> points, long key) {
            boolean isPreviousNullOrNan = false;
            if (points.lowerEntry(key) == null) {
                isPreviousNullOrNan = true;
            } else {
                Point previousPoint = points.lowerEntry(key).getValue();
                if (Double.isNaN(previousPoint.getValue())) {
                    isPreviousNullOrNan = true;
                }
            }
            return isPreviousNullOrNan;
        }

        private boolean isNextNullOrNan(TreeMap<Long, Point> points, long key) {
            boolean isNextNullOrNan = false;
            if (points.higherEntry(key) == null) {
                isNextNullOrNan = true;
            } else {
                Point nextPoint = points.higherEntry(key).getValue();
                if (Double.isNaN(nextPoint.getValue())) {
                    isNextNullOrNan = true;
                }
            }
            return isNextNullOrNan;
        }

        private boolean isWithinScreen(long timeStamp) {
            return timeStamp >= this.t0 && timeStamp <= this.t0 + this.intervalsNumber * this.intervalWidth;
        }

        private boolean isNextToScreen(long timeStamp) {
            return timeStamp < this.t0 ? this.isNextLeft(timeStamp) : this.isNextRight(timeStamp);
        }

        private boolean isNextLeft(long timeStamp) {
            Long screenBorderFloorKey = this.points.floorKey(this.t0);
            return screenBorderFloorKey == null && timeStamp < this.t0 || screenBorderFloorKey != null && timeStamp >= screenBorderFloorKey;
        }

        private boolean isNextRight(long timeStamp) {
            long rightTime = this.t0 + this.intervalsNumber * this.intervalWidth;
            Long screenBorderCeilingKey = this.points.ceilingKey(rightTime);
            return screenBorderCeilingKey == null && timeStamp > rightTime || screenBorderCeilingKey != null && timeStamp <= screenBorderCeilingKey;
        }

        private void invalidateInterfaceWithDelay(final int millis) {
            if (!this.isTimerLaunched.get()) {
                this.isTimerLaunched.set(true);
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(millis);
                        }
                        catch (InterruptedException e) {
                            Log.warn((String)"", (Exception)e);
                        }
                        IndicatorModifiableBasicImplementation.this.invalidateInerface.invalidate();
                        IndicatorModifiableBasicImplementation.this.isTimerLaunched.set(false);
                    }
                });
                thread.setName("-> SimplifiedWrapper: invalidate interface for " + this.name);
                thread.start();
            }
        }
    }

    private class IndicatorBasicImplementation
    extends IndicatorImplementation {
        protected TreeMap<Long, Point> points;

        public IndicatorBasicImplementation(String alias, String name, Layer1ApiUserMessageModifyIndicator.GraphType graphType, double initialValue, InstanceWrapper wrapper) {
            super(alias, name, graphType, initialValue, wrapper);
            this.points = new TreeMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void calculateValuesInRange(String indicatorName, String indicatorAlias, long t0, long intervalWidth, int intervalsNumber, CalculatedResultListener listener) {
            ArrayList<Point> responses = new ArrayList<Point>();
            if (WidgetRulesCalculator.isCalculationOrReportingAllowed(this.consumer, this.widgetRules, this.widgetGroup)) {
                long actualTime = t0 + (long)intervalsNumber * intervalWidth;
                this.calculateAndReportWidgetRange(actualTime);
            }
            for (int i = 0; i < intervalsNumber; ++i) {
                long t = t0 + intervalWidth * (long)i;
                Point response = new Point(this.initialValue, 1);
                TreeMap<Long, Point> treeMap = this.points;
                synchronized (treeMap) {
                    Map.Entry<Long, Point> entry = this.points.floorEntry(t);
                    if (entry != null) {
                        Point point;
                        response = point = entry.getValue();
                    }
                }
                responses.add(response);
            }
            Point previousResponse = null;
            for (Point response : responses) {
                double value = response.getValue();
                if (previousResponse == null) {
                    previousResponse = response;
                }
                if (previousResponse.getSectionNumber() != response.getSectionNumber()) {
                    value = Double.NaN;
                }
                previousResponse = response;
                listener.provideResponse((Object)value);
            }
            listener.setCompleted();
        }

        public OnlineValueCalculatorAdapter createOnlineValueCalculator(String indicatorName, String indicatorAlias, long time, Consumer<Object> listener, InvalidateInterface invalidateInterface) {
            return new OnlineCalculator(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPoint(double value) {
            long time = 0L;
            TreeMap<Long, Point> treeMap = this.points;
            synchronized (treeMap) {
                Point newPoint;
                time = this.getPointTime();
                if (time == 0L) {
                    throw new IllegalStateException("time == 0 " + (Object)((Object)SimplifiedL1ApiLoader.this.mode) + " " + this.wrapper.isRealtime + " " + this.wrapper.getTime() + " " + SimplifiedL1ApiLoader.this.getCurrentTime());
                }
                if (Double.isNaN(value)) {
                    newPoint = new Point(value);
                    ++this.sectionNumber;
                } else {
                    newPoint = new Point(value, this.sectionNumber);
                }
                Point queryResult = this.points.get(time);
                if (queryResult == null || !Double.isNaN(queryResult.getValue())) {
                    this.points.put(time, newPoint);
                }
            }
            if (!Double.isNaN(value) && this.widgetRules != null && this.widgetRules.getLifeSpan() != Long.MAX_VALUE) {
                if (this.nextTime == 0L) {
                    this.nextTime = time + this.widgetRules.getLifeSpan() / 100L;
                }
                ImmutableTriple<Double, Double, Long> returnedValues = WidgetRulesCalculator.processPoint(value, time, this.nextTime, this.lower, this.upper, this.widgetRules, this.sampledWidgetRanges, this.spannedWidgetRanges);
                this.lower = (Double)returnedValues.left;
                this.upper = (Double)returnedValues.middle;
                this.nextTime = (Long)returnedValues.right;
            } else if (this.widgetGroup != null) {
                this.latestReportedLower = WidgetRulesCalculator.initializeOrUpdateLower(this.latestReportedLower, value);
                this.latestReportedUpper = WidgetRulesCalculator.initializeOrUpdateUpper(this.latestReportedUpper, value);
            }
        }

        protected long getPointTime() {
            long time = SimplifiedL1ApiLoader.this.mode == Mode.MIXED && !this.wrapper.isRealtime ? this.wrapper.getTime() : SimplifiedL1ApiLoader.this.getCurrentTime();
            return time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWidgetLifeSpanChanges(long lifeSpan) {
            List spannedWidgetRanges;
            List<Object> results;
            ArrayList<Pair<Long, Point>> pointz;
            TreeMap<Long, Point> treeMap = this.points;
            synchronized (treeMap) {
                pointz = new ArrayList<Pair<Long, Point>>(this.points.entrySet().size());
                this.points.entrySet().stream().forEach(entry -> pointz.add((Pair<Long, Point>)new ImmutablePair(entry.getKey(), entry.getValue())));
            }
            WidgetRules widgetRules = this.widgetRules;
            synchronized (widgetRules) {
                results = WidgetRulesCalculator.onBasicImplementationWidgetLifeSpanChanges(this.widgetRules, pointz);
            }
            List sampledWidgetRanges = (List)results.get(0);
            List list = spannedWidgetRanges = (List)results.get(1);
            synchronized (list) {
                List list2 = sampledWidgetRanges;
                synchronized (list2) {
                    this.spannedWidgetRanges.addAll(0, spannedWidgetRanges);
                    this.sampledWidgetRanges.addAll(0, sampledWidgetRanges);
                }
            }
        }

        protected class OnlineCalculator
        implements OnlineValueCalculatorAdapter {
            private Consumer<Object> listener;

            public OnlineCalculator(Consumer<Object> listener) {
                this.listener = listener;
            }

            public void onLeftTimeChanged(long leftTime) {
                this.sendRelevantValue(this.listener);
            }

            public void onUserMessage(Object data) {
                this.sendRelevantValue(this.listener);
                if (WidgetRulesCalculator.isCalculationOrReportingAllowed(IndicatorBasicImplementation.this.consumer, IndicatorBasicImplementation.this.widgetRules, IndicatorBasicImplementation.this.widgetGroup)) {
                    long actualTime = SimplifiedL1ApiLoader.this.mode == Mode.MIXED && !IndicatorBasicImplementation.this.wrapper.isRealtime ? IndicatorBasicImplementation.this.wrapper.getTime() : SimplifiedL1ApiLoader.this.getCurrentTime();
                    IndicatorBasicImplementation.this.calculateAndReportWidgetRange(actualTime);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void sendRelevantValue(Consumer<Object> listener) {
                double value = IndicatorBasicImplementation.this.initialValue;
                long actualTime = SimplifiedL1ApiLoader.this.mode == Mode.MIXED && !IndicatorBasicImplementation.this.wrapper.isRealtime ? IndicatorBasicImplementation.this.wrapper.getTime() : SimplifiedL1ApiLoader.this.getCurrentTime();
                TreeMap<Long, Point> treeMap = IndicatorBasicImplementation.this.points;
                synchronized (treeMap) {
                    Map.Entry<Long, Point> entry = IndicatorBasicImplementation.this.points.floorEntry(actualTime);
                    if (entry != null) {
                        Point point = entry.getValue();
                        value = point.getValue();
                    }
                }
                listener.accept(value);
            }
        }
    }

    abstract class IndicatorImplementation
    implements Indicator,
    OnlineCalculatable,
    WidgetRangeProducer {
        protected final String alias;
        protected final String name;
        protected final Layer1ApiUserMessageModifyIndicator.GraphType graphType;
        protected final double initialValue;
        protected final InstanceWrapper wrapper;
        protected final String fullName;
        protected Color color = SimplifiedL1ApiLoader.access$000();
        protected LineStyle lineStyle = LineStyle.SOLID;
        protected int width;
        protected AxisRules axisRules;
        protected AxisGroup axisGroup;
        protected WidgetRules widgetRules;
        protected WidgetGroup widgetGroup;
        protected int sectionNumber;
        protected WidgetRangeConsumer consumer;
        protected long nextTime;
        protected double lower;
        protected double upper;
        protected List<ImmutablePair<Long, ImmutablePair<Double, Double>>> sampledWidgetRanges;
        protected ImmutablePair<Double, Double> actualRange;
        protected double latestReportedLower;
        protected double latestReportedUpper;
        protected List<ImmutablePair<Long, ImmutablePair<Double, Double>>> spannedWidgetRanges;

        public IndicatorImplementation(String alias, String name, Layer1ApiUserMessageModifyIndicator.GraphType graphType, double initialValue, InstanceWrapper wrapper) {
            this.width = IndicatorLineStyle.DEFAULT.mainLineWidth;
            this.sectionNumber = 1;
            this.nextTime = 0L;
            this.lower = Double.NaN;
            this.upper = Double.NaN;
            this.sampledWidgetRanges = new LinkedList<ImmutablePair<Long, ImmutablePair<Double, Double>>>();
            this.latestReportedLower = Double.NaN;
            this.latestReportedUpper = Double.NaN;
            this.spannedWidgetRanges = new LinkedList<ImmutablePair<Long, ImmutablePair<Double, Double>>>();
            this.alias = alias;
            this.name = name;
            this.graphType = graphType;
            this.initialValue = initialValue;
            this.wrapper = wrapper;
            this.fullName = ((SimplifiedL1ApiLoader)SimplifiedL1ApiLoader.this).getUserMessageModify((String)name, (Layer1ApiUserMessageModifyIndicator.GraphType)graphType, (LineStyle)this.lineStyle, (int)this.width, (Color)this.color, (String)alias, (boolean)false, (OnlineCalculatable)this).fullName;
            SimplifiedL1ApiLoader.this.setSefaultColor(alias, name, this.color);
        }

        public String getFullName() {
            return this.fullName;
        }

        public void register() {
            Layer1ApiUserMessageModifyIndicator message = SimplifiedL1ApiLoader.this.getUserMessageModify(this.name, this.graphType, this.lineStyle, this.width, this.color, this.alias, true, this);
            SimplifiedL1ApiLoader.this.provider.sendUserMessage((Object)message);
        }

        public void remove() {
            Layer1ApiUserMessageModifyIndicator message = SimplifiedL1ApiLoader.this.getUserMessageModify(this.name, this.graphType, this.lineStyle, this.width, this.color, this.alias, false, this);
            SimplifiedL1ApiLoader.this.provider.sendUserMessage((Object)message);
        }

        private void doWithReload(Runnable action) {
            SimplifiedL1ApiLoader.this.inject(() -> {
                this.remove();
                action.run();
                this.register();
            });
        }

        @Override
        public void setColor(Color color) {
            this.doWithReload(() -> {
                this.color = color;
                SimplifiedL1ApiLoader.this.setSefaultColor(this.alias, this.name, color);
            });
        }

        @Override
        public void setWidth(int width) {
            this.doWithReload(() -> {
                this.width = width;
            });
        }

        @Override
        public void setLineStyle(LineStyle lineStyle) {
            this.doWithReload(() -> {
                this.lineStyle = lineStyle;
            });
        }

        @Override
        public void setAxisRules(AxisRules axisRules) {
            this.doWithReload(() -> {
                this.axisRules = axisRules;
            });
        }

        public AxisRules getAxisRules() {
            return this.axisRules;
        }

        public void setAxisGroup(AxisGroup axisGroup) {
            this.doWithReload(() -> {
                this.axisGroup = axisGroup;
            });
        }

        public void setWidgetGroup(WidgetGroup widgetGroup) {
            this.doWithReload(() -> {
                this.widgetGroup = widgetGroup;
                WidgetRules groupWidgetRules = widgetGroup.getWidgetRules();
                if (groupWidgetRules != null) {
                    this.setWidgetRules(groupWidgetRules);
                    if (groupWidgetRules.getWidgetDisplayInfo() != null && this.consumer != null) {
                        this.consumer.setWidgetDisplayInfo(groupWidgetRules.getWidgetDisplayInfo());
                    }
                }
            });
        }

        public AxisGroup getAxisGroup() {
            return this.axisGroup;
        }

        protected ImmutablePair<Double, Double> getUnlimitedRange(long actualTime) {
            if (this.widgetRules != null && this.widgetRules.getLifeSpan() != Long.MAX_VALUE) {
                return WidgetRulesCalculator.getTemporalMinMax(actualTime, this.lower, this.upper, this.spannedWidgetRanges);
            }
            return new ImmutablePair((Object)this.latestReportedLower, (Object)this.latestReportedUpper);
        }

        protected ImmutablePair<Double, Double> getLimitedRange(ImmutablePair<Double, Double> unlimitedRange) {
            return (ImmutablePair)this.widgetRules.apply((Double)unlimitedRange.getLeft(), (Double)unlimitedRange.getRight());
        }

        protected void calculateAndReportWidgetRange(long actualTime) {
            ImmutablePair<Double, Double> trange = this.getUnlimitedRange(actualTime);
            if (this.widgetRules != null && !Double.isNaN(this.widgetRules.getForcedMin())) {
                trange = this.getLimitedRange(trange);
            }
            ImmutablePair<Double, Double> updatedRange = WidgetRulesCalculator.updateRangeToBeReported(trange, this.latestReportedLower, this.latestReportedUpper);
            ImmutablePair<Double, Double> reportedRange = null;
            if (updatedRange != null && this.widgetGroup == null) {
                reportedRange = WidgetRulesCalculator.reportRange(this.consumer, (Double)updatedRange.getLeft(), (Double)updatedRange.getRight());
            } else if (this.widgetGroup != null && (updatedRange = WidgetRulesCalculator.adjustGroupRange(this.widgetGroup)) != null && ((Double)updatedRange.left != this.latestReportedLower || (Double)updatedRange.right != this.latestReportedUpper)) {
                reportedRange = WidgetRulesCalculator.reportRange(this.consumer, (Double)updatedRange.getLeft(), (Double)updatedRange.getRight());
            }
            if (reportedRange != null) {
                this.latestReportedLower = (Double)reportedRange.left;
                this.latestReportedUpper = (Double)reportedRange.right;
            }
        }

        protected abstract void onWidgetLifeSpanChanges(long var1);

        @Override
        public void setWidgetRules(WidgetRules widgetRules) {
            if (this.widgetRules == null) {
                this.widgetRules = widgetRules;
            } else {
                this.latestReportedLower = widgetRules.getForcedMin();
                this.latestReportedUpper = widgetRules.getForcedMax();
                long lifeSpan0 = this.widgetRules.getLifeSpan();
                long lifeSpan1 = widgetRules.getLifeSpan();
                this.widgetRules = widgetRules;
                if (lifeSpan0 != lifeSpan1) {
                    this.onWidgetLifeSpanChanges(lifeSpan1);
                }
            }
        }

        @Override
        public void setWidgetRangeConsumer(WidgetRangeConsumer consumer) {
            this.consumer = consumer;
            if (this.widgetRules != null && this.widgetRules.getWidgetDisplayInfo() != null) {
                consumer.setWidgetDisplayInfo(this.widgetRules.getWidgetDisplayInfo());
            }
            if (WidgetRulesCalculator.isCalculationOrReportingAllowed(consumer, this.widgetRules, this.widgetGroup)) {
                WidgetRulesCalculator.reportRange(consumer, this.latestReportedLower, this.latestReportedUpper);
            }
        }
    }

    private static class CustomAggregationEvent
    implements CustomGeneratedEvent {
        private static final long serialVersionUID = 1L;
        private final long time;
        public Map<Integer, Point> indicators = new HashMap<Integer, Point>();

        public CustomAggregationEvent(long time, Map<Integer, Point> indicators) {
            this.time = time;
            this.indicators.putAll(indicators);
        }

        public long getTime() {
            return this.time;
        }

        public Object clone() {
            return new CustomAggregationEvent(this.time, this.indicators);
        }
    }

    private static class CustomEvent
    implements CustomGeneratedEvent {
        private static final long serialVersionUID = 1L;
        private final long time;
        public final int indicatorId;
        public final Point indicatorPoint;

        public CustomEvent(long time, int indicatorId, Point indicatorValue) {
            this.time = time;
            this.indicatorId = indicatorId;
            this.indicatorPoint = indicatorValue;
        }

        public long getTime() {
            return this.time;
        }

        public Object clone() {
            return new CustomEvent(this.time, this.indicatorId, this.indicatorPoint);
        }

        public String toString() {
            return "CustomEvent [time=" + this.time + ", indicatorId=" + this.indicatorId + ", indicatorValue=" + this.indicatorPoint + "]";
        }
    }

    protected static class Point
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private double value;
        private int sectionNumber;

        public Point() {
        }

        public Point(double value) {
            this.value = value;
        }

        public Point(double value, int sectionNumber) {
            this.value = value;
            this.sectionNumber = sectionNumber;
        }

        public double getValue() {
            return this.value;
        }

        public int getSectionNumber() {
            return this.sectionNumber;
        }

        public void setSectionNumber(int sectionNumber) {
            this.sectionNumber = sectionNumber;
        }

        public String toString() {
            return "Point [value=" + this.value + ", sectionNumber=" + this.sectionNumber + "]";
        }
    }

    private static interface WidgetRangeProducer {
        public void setWidgetRangeConsumer(WidgetRangeConsumer var1);
    }

    private static interface StrategyUpdateGeneratorWithFilter
    extends StrategyUpdateGenerator,
    StrategyUpdateGeneratorFilter {
    }

    private static enum Mode {
        LIVE,
        GENERATORS,
        MIXED;

    }
}

