/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import velox.api.layer1.common.Log;
import velox.api.layer1.common.NanoClock;
import velox.api.layer1.layers.strategies.interfaces.CalculatedResultListener;
import velox.api.layer1.layers.strategies.interfaces.InvalidateInterface;
import velox.api.layer1.layers.strategies.interfaces.OnlineCalculatable;
import velox.api.layer1.layers.strategies.interfaces.OnlineValueCalculatorAdapter;
import velox.api.layer1.messages.indicators.Layer1ApiUserMessageModifyIndicator;
import velox.api.layer1.simplified.IconStorage;
import velox.api.layer1.simplified.IndicatorImplementation;
import velox.api.layer1.simplified.InstanceWrapper;
import velox.api.layer1.simplified.Point;
import velox.api.layer1.simplified.SimplifiedL1ApiLoader;
import velox.api.layer1.simplified.WidgetRules;
import velox.api.layer1.simplified.WidgetRulesCalculator;

class IndicatorBasicImplementation
extends IndicatorImplementation {
    protected static final int MAX_INMEMORY_POINTS = 200000;
    private static final double DROP_FRACTION = 0.2;
    private static final int DROP_SKIP_COUNT_MIN = 2;
    private static final int DROP_SKIP_COUNT_MAX = 3;
    private SimplifiedL1ApiLoader simplifiedL1ApiLoader;
    protected TreeMap<Long, Point> points = new TreeMap();
    protected TreeMap<Long, List<Integer>> icons = new TreeMap();

    public IndicatorBasicImplementation(SimplifiedL1ApiLoader simplifiedL1ApiLoader, String alias, String name, Layer1ApiUserMessageModifyIndicator.GraphType graphType, double initialValue, InstanceWrapper wrapper) {
        super(simplifiedL1ApiLoader, alias, name, graphType, initialValue, wrapper);
        this.simplifiedL1ApiLoader = simplifiedL1ApiLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateValuesInRange(String indicatorName, String indicatorAlias, long t0, long intervalWidth, int intervalsNumber, CalculatedResultListener listener) {
        if (WidgetRulesCalculator.isCalculationOrReportingAllowed(this.consumer, this.widgetRules, this.widgetGroup)) {
            long actualTime = t0 + (long)intervalsNumber * intervalWidth;
            this.calculateAndReportWidgetRange(actualTime);
        }
        Point previousPoint = null;
        for (int i = 0; i < intervalsNumber; ++i) {
            long t = t0 + intervalWidth * (long)i;
            Point currentPoint = new Point(this.initialValue, 1);
            TreeMap<Long, Point> treeMap = this.points;
            synchronized (treeMap) {
                Map.Entry<Long, Point> entry = this.points.floorEntry(t);
                if (entry != null) {
                    Point point;
                    currentPoint = point = entry.getValue();
                }
            }
            double value = currentPoint.getValue();
            if (previousPoint == null) {
                previousPoint = currentPoint;
            }
            if (previousPoint.getSectionNumber() != currentPoint.getSectionNumber()) {
                value = Double.NaN;
            }
            previousPoint = currentPoint;
            List<Object> iconsInPixel = new ArrayList();
            IconStorage iconStorage = this.iconStorage;
            synchronized (iconStorage) {
                if (!this.iconStorage.isClosed()) {
                    iconsInPixel = this.icons.subMap(t - intervalWidth, false, t, true).values().stream().flatMap(list -> list.stream().map(this.iconStorage::load)).collect(Collectors.toList());
                }
            }
            if (iconsInPixel.size() > 0) {
                List markers = iconsInPixel.stream().map(image -> image.marker).collect(Collectors.toList());
                listener.provideResponse((Object)new OnlineCalculatable.ValueBundle((Object)value, markers));
                continue;
            }
            listener.provideResponse((Object)value);
        }
        listener.setCompleted();
    }

    public OnlineValueCalculatorAdapter createOnlineValueCalculator(String indicatorName, String indicatorAlias, long time, Consumer<Object> listener, InvalidateInterface invalidateInterface) {
        return new OnlineCalculator(listener, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPoint(double value) {
        long time = 0L;
        TreeMap<Long, Point> treeMap = this.points;
        synchronized (treeMap) {
            Point newPoint;
            time = this.getPointTime();
            if (time == 0L) {
                throw new IllegalStateException("time == 0 " + (Object)((Object)this.simplifiedL1ApiLoader.mode) + " " + this.wrapper.isRealtime + " " + this.wrapper.getTime() + " " + this.simplifiedL1ApiLoader.getCurrentTime());
            }
            if (Double.isNaN(value)) {
                newPoint = new Point(value);
                ++this.sectionNumber;
            } else {
                newPoint = new Point(value, this.sectionNumber);
            }
            Point queryResult = this.points.get(time);
            if (queryResult == null || !Double.isNaN(queryResult.getValue())) {
                this.points.put(time, newPoint);
            }
            if (this.points.size() > 200000) {
                this.thinOutPoints();
            }
        }
        if (!Double.isNaN(value) && this.widgetRules != null && this.widgetRules.getLifeSpan() != Long.MAX_VALUE) {
            if (this.nextTime == 0L) {
                this.nextTime = time + this.widgetRules.getLifeSpan() / 100L;
            }
            ImmutableTriple<Double, Double, Long> returnedValues = WidgetRulesCalculator.processPoint(value, time, this.nextTime, this.lower, this.upper, this.widgetRules, this.sampledWidgetRanges, this.spannedWidgetRanges);
            this.lower = (Double)returnedValues.left;
            this.upper = (Double)returnedValues.middle;
            this.nextTime = (Long)returnedValues.right;
        } else if (this.widgetGroup != null) {
            this.latestReportedLower = WidgetRulesCalculator.initializeOrUpdateLower(this.latestReportedLower, value);
            this.latestReportedUpper = WidgetRulesCalculator.initializeOrUpdateUpper(this.latestReportedUpper, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIcon(double value, BufferedImage icon, int iconCenterX, int iconCenterY) {
        IconStorage iconStorage = this.iconStorage;
        synchronized (iconStorage) {
            if (!this.iconStorage.isClosed()) {
                long time = this.getPointTime();
                if (time == 0L) {
                    throw new IllegalStateException("time == 0 " + (Object)((Object)this.simplifiedL1ApiLoader.mode) + " " + this.wrapper.isRealtime + " " + this.wrapper.getTime() + " " + this.simplifiedL1ApiLoader.getCurrentTime());
                }
                IconStorage.IconInfo imageInfo = this.makeIcon(value, icon, iconCenterX, iconCenterY);
                this.icons.computeIfAbsent(time, v -> new ArrayList(1)).add(imageInfo.imageId);
            }
        }
    }

    protected long getPointTime() {
        long time = this.simplifiedL1ApiLoader.mode == SimplifiedL1ApiLoader.Mode.MIXED && !this.wrapper.isRealtime ? this.wrapper.getTime() : this.simplifiedL1ApiLoader.getCurrentTime();
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWidgetLifeSpanChanges(long lifeSpan) {
        List spannedWidgetRanges;
        List<Object> results;
        ArrayList<Pair<Long, Point>> pointz;
        TreeMap<Long, Point> treeMap = this.points;
        synchronized (treeMap) {
            pointz = new ArrayList<Pair<Long, Point>>(this.points.entrySet().size());
            this.points.entrySet().stream().forEach(entry -> pointz.add((Pair<Long, Point>)new ImmutablePair(entry.getKey(), entry.getValue())));
        }
        WidgetRules widgetRules = this.widgetRules;
        synchronized (widgetRules) {
            results = WidgetRulesCalculator.onBasicImplementationWidgetLifeSpanChanges(this.widgetRules, pointz);
        }
        List sampledWidgetRanges = (List)results.get(0);
        List list = spannedWidgetRanges = (List)results.get(1);
        synchronized (list) {
            List list2 = sampledWidgetRanges;
            synchronized (list2) {
                this.spannedWidgetRanges.addAll(0, spannedWidgetRanges);
                this.sampledWidgetRanges.addAll(0, sampledWidgetRanges);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void thinOutPoints() {
        TreeMap<Long, Point> treeMap = this.points;
        synchronized (treeMap) {
            Log.info((String)(this.simplifiedL1ApiLoader.simpleStrategyClass.getName() + " indicator generated too many points (" + this.points.size() + "), removing the oldest ones"));
            long dropStartTime = NanoClock.currentTimeNanos();
            Iterator<Map.Entry<Long, Point>> iterator = this.points.entrySet().iterator();
            int randomPart = 2;
            int pointsToDrop = (int)((double)this.points.size() * 0.2);
            while (pointsToDrop > 0) {
                iterator.next();
                iterator.remove();
                --pointsToDrop;
                for (int i = 2 + (int)(Math.random() * (double)randomPart); i > 0; --i) {
                    iterator.next();
                }
            }
            Log.debug((String)("Dots dropped in " + (double)(NanoClock.currentTimeNanos() - dropStartTime) / 1000000.0 + "ms, new points count " + this.points.size()));
        }
    }

    protected class OnlineCalculator
    implements OnlineValueCalculatorAdapter {
        private Consumer<Object> listener;
        private long lastPublishedIconTime;
        private int lastPublishedIconIndexWithinBlock;

        public OnlineCalculator(Consumer<Object> listener, long creationTime) {
            this.listener = listener;
            this.lastPublishedIconTime = creationTime;
            this.lastPublishedIconIndexWithinBlock = 0;
        }

        public void onLeftTimeChanged(long leftTime) {
            this.sendRelevantValue(this.listener);
        }

        public void onUserMessage(Object data) {
            this.sendRelevantValue(this.listener);
            if (WidgetRulesCalculator.isCalculationOrReportingAllowed(IndicatorBasicImplementation.this.consumer, IndicatorBasicImplementation.this.widgetRules, IndicatorBasicImplementation.this.widgetGroup)) {
                long actualTime = ((IndicatorBasicImplementation)IndicatorBasicImplementation.this).simplifiedL1ApiLoader.mode == SimplifiedL1ApiLoader.Mode.MIXED && !IndicatorBasicImplementation.this.wrapper.isRealtime ? IndicatorBasicImplementation.this.wrapper.getTime() : IndicatorBasicImplementation.this.simplifiedL1ApiLoader.getCurrentTime();
                IndicatorBasicImplementation.this.calculateAndReportWidgetRange(actualTime);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendRelevantValue(Consumer<Object> listener) {
            Object entry;
            double value = IndicatorBasicImplementation.this.initialValue;
            long actualTime = ((IndicatorBasicImplementation)IndicatorBasicImplementation.this).simplifiedL1ApiLoader.mode == SimplifiedL1ApiLoader.Mode.MIXED && !IndicatorBasicImplementation.this.wrapper.isRealtime ? IndicatorBasicImplementation.this.wrapper.getTime() : IndicatorBasicImplementation.this.simplifiedL1ApiLoader.getCurrentTime();
            TreeMap<Long, Point> treeMap = IndicatorBasicImplementation.this.points;
            synchronized (treeMap) {
                entry = IndicatorBasicImplementation.this.points.floorEntry(actualTime);
                if (entry != null) {
                    Point point = entry.getValue();
                    value = point.getValue();
                }
            }
            List<Object> iconsToAdd = new ArrayList();
            entry = IndicatorBasicImplementation.this.iconStorage;
            synchronized (entry) {
                if (!IndicatorBasicImplementation.this.iconStorage.isClosed()) {
                    iconsToAdd = this.lastPublishedIconTime <= actualTime ? IndicatorBasicImplementation.this.icons.subMap(this.lastPublishedIconTime, true, actualTime, true).entrySet().stream().flatMap(e -> {
                        List iconsInPixel = (List)e.getValue();
                        long iconsTime = (Long)e.getKey();
                        List iconsToPublish = iconsTime == this.lastPublishedIconTime ? iconsInPixel.subList(this.lastPublishedIconIndexWithinBlock + 1, iconsInPixel.size()) : iconsInPixel;
                        this.lastPublishedIconTime = iconsTime;
                        this.lastPublishedIconIndexWithinBlock = iconsInPixel.size() - 1;
                        return iconsToPublish.stream();
                    }).map(IndicatorBasicImplementation.this.iconStorage::load).collect(Collectors.toList()) : Collections.emptyList();
                }
            }
            if (iconsToAdd.size() > 0) {
                List markers = iconsToAdd.stream().map(image -> image.marker).collect(Collectors.toList());
                listener.accept(new OnlineCalculatable.ValueBundle((Object)value, markers));
            } else {
                listener.accept(value);
            }
        }
    }
}

