/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import velox.api.layer1.layers.strategies.interfaces.OnlineCalculatable;
import velox.api.layer1.layers.strategies.interfaces.WidgetRangeConsumer;
import velox.api.layer1.messages.indicators.IndicatorLineStyle;
import velox.api.layer1.messages.indicators.Layer1ApiUserMessageModifyIndicator;
import velox.api.layer1.simplified.AxisGroup;
import velox.api.layer1.simplified.AxisRules;
import velox.api.layer1.simplified.IconStorage;
import velox.api.layer1.simplified.Indicator;
import velox.api.layer1.simplified.InstanceWrapper;
import velox.api.layer1.simplified.LineStyle;
import velox.api.layer1.simplified.SimplifiedL1ApiLoader;
import velox.api.layer1.simplified.WidgetGroup;
import velox.api.layer1.simplified.WidgetRangeProducer;
import velox.api.layer1.simplified.WidgetRules;
import velox.api.layer1.simplified.WidgetRulesCalculator;

abstract class IndicatorImplementation
implements Indicator,
OnlineCalculatable,
WidgetRangeProducer {
    private SimplifiedL1ApiLoader simplifiedL1ApiLoader;
    protected final String alias;
    protected final String name;
    protected final Layer1ApiUserMessageModifyIndicator.GraphType graphType;
    protected final double initialValue;
    protected final InstanceWrapper wrapper;
    protected final String fullName;
    protected Color color = SimplifiedL1ApiLoader.DEFAULT_INDICATOR_COLOR;
    protected LineStyle lineStyle = LineStyle.SOLID;
    protected int renderPriority = -1;
    protected int width;
    protected AxisRules axisRules;
    protected AxisGroup axisGroup;
    protected WidgetRules widgetRules;
    protected WidgetGroup widgetGroup;
    protected int sectionNumber;
    protected int nextIconId;
    protected IconStorage iconStorage;
    protected WidgetRangeConsumer consumer;
    protected long nextTime;
    protected double lower;
    protected double upper;
    protected List<ImmutablePair<Long, ImmutablePair<Double, Double>>> sampledWidgetRanges;
    protected ImmutablePair<Double, Double> actualRange;
    protected double latestReportedLower;
    protected double latestReportedUpper;
    protected List<ImmutablePair<Long, ImmutablePair<Double, Double>>> spannedWidgetRanges;

    public IndicatorImplementation(SimplifiedL1ApiLoader simplifiedL1ApiLoader, String alias, String name, Layer1ApiUserMessageModifyIndicator.GraphType graphType, double initialValue, InstanceWrapper wrapper) {
        this.width = IndicatorLineStyle.DEFAULT.mainLineWidth;
        this.sectionNumber = 1;
        this.nextIconId = 1;
        this.iconStorage = new IconStorage();
        this.nextTime = 0L;
        this.lower = Double.NaN;
        this.upper = Double.NaN;
        this.sampledWidgetRanges = new LinkedList<ImmutablePair<Long, ImmutablePair<Double, Double>>>();
        this.latestReportedLower = Double.NaN;
        this.latestReportedUpper = Double.NaN;
        this.spannedWidgetRanges = new LinkedList<ImmutablePair<Long, ImmutablePair<Double, Double>>>();
        this.simplifiedL1ApiLoader = simplifiedL1ApiLoader;
        this.alias = alias;
        this.name = name;
        this.graphType = graphType;
        this.initialValue = initialValue;
        this.wrapper = wrapper;
        this.fullName = simplifiedL1ApiLoader.getUserMessageModify((String)name, (Layer1ApiUserMessageModifyIndicator.GraphType)graphType, (LineStyle)this.lineStyle, (int)this.renderPriority, (int)this.width, (Color)this.color, (String)alias, (boolean)false, (OnlineCalculatable)this).fullName;
        simplifiedL1ApiLoader.setSefaultColor(alias, name, this.color);
    }

    public String getFullName() {
        return this.fullName;
    }

    public void register() {
        Layer1ApiUserMessageModifyIndicator message = this.simplifiedL1ApiLoader.getUserMessageModify(this.name, this.graphType, this.lineStyle, this.renderPriority, this.width, this.color, this.alias, true, this);
        this.simplifiedL1ApiLoader.sendUserMessageAsync(message);
    }

    public void remove() {
        Layer1ApiUserMessageModifyIndicator message = this.simplifiedL1ApiLoader.getUserMessageModify(this.name, this.graphType, this.lineStyle, this.renderPriority, this.width, this.color, this.alias, false, this);
        this.simplifiedL1ApiLoader.sendUserMessageAsync(message);
    }

    private void doWithReload(Runnable action) {
        this.simplifiedL1ApiLoader.loaderInject(() -> {
            this.remove();
            action.run();
            this.register();
        });
    }

    @Override
    public void setColor(Color color) {
        this.doWithReload(() -> {
            this.color = color;
            this.simplifiedL1ApiLoader.setSefaultColor(this.alias, this.name, color);
        });
    }

    @Override
    public void setWidth(int width) {
        this.doWithReload(() -> {
            this.width = width;
        });
    }

    @Override
    public void setLineStyle(LineStyle lineStyle) {
        this.doWithReload(() -> {
            this.lineStyle = lineStyle;
        });
    }

    @Override
    public void setRenderPriority(int renderPriority) {
        this.doWithReload(() -> {
            this.renderPriority = renderPriority;
        });
    }

    @Override
    public void setAxisRules(AxisRules axisRules) {
        this.doWithReload(() -> {
            this.axisRules = axisRules;
        });
    }

    public AxisRules getAxisRules() {
        return this.axisRules;
    }

    public void setAxisGroup(AxisGroup axisGroup) {
        this.doWithReload(() -> {
            this.axisGroup = axisGroup;
        });
    }

    public void setWidgetGroup(WidgetGroup widgetGroup) {
        this.doWithReload(() -> {
            this.widgetGroup = widgetGroup;
            WidgetRules groupWidgetRules = widgetGroup.getWidgetRules();
            if (groupWidgetRules != null) {
                this.setWidgetRules(groupWidgetRules);
                if (groupWidgetRules.getWidgetDisplayInfo() != null && this.consumer != null) {
                    this.consumer.setWidgetDisplayInfo(groupWidgetRules.getWidgetDisplayInfo());
                }
            }
        });
    }

    public AxisGroup getAxisGroup() {
        return this.axisGroup;
    }

    protected ImmutablePair<Double, Double> getUnlimitedRange(long actualTime) {
        if (this.widgetRules != null && this.widgetRules.getLifeSpan() != Long.MAX_VALUE) {
            return WidgetRulesCalculator.getTemporalMinMax(actualTime, this.lower, this.upper, this.spannedWidgetRanges);
        }
        return new ImmutablePair((Object)this.latestReportedLower, (Object)this.latestReportedUpper);
    }

    protected ImmutablePair<Double, Double> getLimitedRange(ImmutablePair<Double, Double> unlimitedRange) {
        return (ImmutablePair)this.widgetRules.apply((Double)unlimitedRange.getLeft(), (Double)unlimitedRange.getRight());
    }

    protected void calculateAndReportWidgetRange(long actualTime) {
        ImmutablePair<Double, Double> trange = this.getUnlimitedRange(actualTime);
        if (this.widgetRules != null && !Double.isNaN(this.widgetRules.getForcedMin())) {
            trange = this.getLimitedRange(trange);
        }
        ImmutablePair<Double, Double> updatedRange = WidgetRulesCalculator.updateRangeToBeReported(trange, this.latestReportedLower, this.latestReportedUpper);
        ImmutablePair<Double, Double> reportedRange = null;
        if (updatedRange != null && this.widgetGroup == null) {
            reportedRange = WidgetRulesCalculator.reportRange(this.consumer, (Double)updatedRange.getLeft(), (Double)updatedRange.getRight());
        } else if (this.widgetGroup != null && (updatedRange = WidgetRulesCalculator.adjustGroupRange(this.widgetGroup)) != null && ((Double)updatedRange.left != this.latestReportedLower || (Double)updatedRange.right != this.latestReportedUpper)) {
            reportedRange = WidgetRulesCalculator.reportRange(this.consumer, (Double)updatedRange.getLeft(), (Double)updatedRange.getRight());
        }
        if (reportedRange != null) {
            this.latestReportedLower = (Double)reportedRange.left;
            this.latestReportedUpper = (Double)reportedRange.right;
        }
    }

    protected IconStorage.IconInfo makeIcon(double value, BufferedImage icon, int iconCenterX, int iconCenterY) {
        BufferedImage iconCopy = new BufferedImage(icon.getWidth(), icon.getHeight(), 2);
        Graphics iconCopyGraphics = iconCopy.getGraphics();
        iconCopyGraphics.drawImage(icon, 0, 0, null);
        iconCopyGraphics.dispose();
        IconStorage.IconInfo imageInfo = new IconStorage.IconInfo();
        imageInfo.imageId = this.nextIconId++;
        imageInfo.marker = new OnlineCalculatable.Marker(value, -iconCenterX, -iconCopy.getHeight() + 1 + iconCenterY, iconCopy);
        this.iconStorage.save(imageInfo);
        return imageInfo;
    }

    protected abstract void onWidgetLifeSpanChanges(long var1);

    @Override
    public void setWidgetRules(WidgetRules widgetRules) {
        if (this.widgetRules == null) {
            this.widgetRules = widgetRules;
        } else {
            this.latestReportedLower = widgetRules.getForcedMin();
            this.latestReportedUpper = widgetRules.getForcedMax();
            long lifeSpan0 = this.widgetRules.getLifeSpan();
            long lifeSpan1 = widgetRules.getLifeSpan();
            this.widgetRules = widgetRules;
            if (lifeSpan0 != lifeSpan1) {
                this.onWidgetLifeSpanChanges(lifeSpan1);
            }
        }
    }

    @Override
    public void setWidgetRangeConsumer(WidgetRangeConsumer consumer) {
        this.consumer = consumer;
        if (this.widgetRules != null && this.widgetRules.getWidgetDisplayInfo() != null) {
            consumer.setWidgetDisplayInfo(this.widgetRules.getWidgetDisplayInfo());
        }
        if (WidgetRulesCalculator.isCalculationOrReportingAllowed(consumer, this.widgetRules, this.widgetGroup)) {
            WidgetRulesCalculator.reportRange(consumer, this.latestReportedLower, this.latestReportedUpper);
        }
    }

    public void dispose() {
        this.iconStorage.close();
    }
}

