/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import quickfix.RuntimeError;
import velox.api.layer1.common.DirectoryResolver;
import velox.api.layer1.common.Log;
import velox.api.layer1.layers.strategies.interfaces.OnlineCalculatable;

class IconStorage
implements AutoCloseable {
    private static final Path TEMP_DIRECTORY = DirectoryResolver.getBookmapDirectoryByName((String)"API").resolve("SimplifiedL1ImageCache");
    private static final long MAX_INMEMORY_BUFFER = 0x400000L;
    private Map<Integer, InMemoryIconInfo> inMemoryIconInfos = new HashMap<Integer, InMemoryIconInfo>();
    private BidiMap<Long, Integer> hashByOffset = new DualHashBidiMap();
    private HashMap<Integer, Integer> hashUsesCount = new HashMap();
    private final File imagesTempFolder;
    private final File storageFile;
    private final RandomAccessFile storageRandomAccessFile;
    private FileLock storageFileLock;
    private long storageRandomAccessFileNextOffset = 0L;
    private boolean closed = false;
    private Cache<Long, BufferedImage> memoryCache = CacheBuilder.newBuilder().maximumWeight(0x400000L).weigher((k, v) -> {
        BufferedImage bufferedImage = (BufferedImage)v;
        return bufferedImage.getHeight() * bufferedImage.getWidth() * 4;
    }).expireAfterAccess(10L, TimeUnit.MINUTES).build();

    public IconStorage() {
        try {
            this.imagesTempFolder = TEMP_DIRECTORY.toFile().getAbsoluteFile();
            if (!this.imagesTempFolder.exists()) {
                this.imagesTempFolder.mkdir();
            }
            this.cleanOldFiles();
            this.storageFile = File.createTempFile("icons-", null, this.imagesTempFolder).getAbsoluteFile();
            this.storageRandomAccessFile = new RandomAccessFile(this.storageFile, "rw");
            this.storageFileLock = this.storageRandomAccessFile.getChannel().tryLock();
        }
        catch (IOException e) {
            throw new RuntimeError((Throwable)e);
        }
    }

    private void cleanOldFiles() {
        for (File file : this.imagesTempFolder.listFiles()) {
            File absoluteFile = file.getAbsoluteFile();
            if (!absoluteFile.isFile()) continue;
            FileLock lock = null;
            RandomAccessFile raFile = null;
            try {
                raFile = new RandomAccessFile(absoluteFile, "rw");
                lock = raFile.getChannel().tryLock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
            }
            catch (IOException e) {
                Log.info((String)("Failed to check lock on file " + absoluteFile), (Exception)e);
            }
            try {
                if (lock != null && lock.isValid()) {
                    lock.release();
                }
                if (raFile != null) {
                    raFile.close();
                }
            }
            catch (IOException e) {
                Log.info((String)("Failed to release lock on file " + absoluteFile), (Exception)e);
            }
            if (lock == null) continue;
            absoluteFile.delete();
        }
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            try {
                this.storageFileLock.release();
                this.storageRandomAccessFile.close();
                boolean deleted = this.storageFile.delete();
                Log.info((String)("storageFile deletion return: " + deleted));
            }
            catch (IOException e) {
                throw new RuntimeException();
            }
            this.closed = true;
        }
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable t) {
            Log.error((String)"Failed to finalize", (Throwable)t);
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(IconInfo iconInfo) {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        BufferedImage icon = iconInfo.marker.icon;
        InMemoryIconInfo inMemoryIconInfo = new InMemoryIconInfo();
        inMemoryIconInfo.markerY = iconInfo.marker.markerY;
        inMemoryIconInfo.iconOffsetX = iconInfo.marker.iconOffsetX;
        inMemoryIconInfo.iconOffsetY = iconInfo.marker.iconOffsetY;
        inMemoryIconInfo.imageWidth = iconInfo.marker.icon.getWidth();
        inMemoryIconInfo.imageHeight = iconInfo.marker.icon.getHeight();
        int[] imageInts = icon.getRGB(0, 0, icon.getWidth(), icon.getHeight(), null, 0, icon.getWidth());
        ByteBuffer byteBuffer = ByteBuffer.allocate(imageInts.length * 4);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.put(imageInts);
        byte[] imageBytes = byteBuffer.array();
        int hash = Arrays.hashCode(imageBytes);
        Long offset = (Long)this.hashByOffset.getKey((Object)hash);
        if (offset == null) {
            try {
                RandomAccessFile randomAccessFile = this.storageRandomAccessFile;
                synchronized (randomAccessFile) {
                    offset = this.storageRandomAccessFileNextOffset;
                    this.storageRandomAccessFileNextOffset += (long)imageBytes.length;
                    this.storageRandomAccessFile.seek(offset);
                    this.storageRandomAccessFile.write(imageBytes);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to save icon to cache", e);
            }
            this.hashByOffset.put((Object)offset, (Object)hash);
            this.hashUsesCount.put(hash, 1);
        } else {
            this.hashUsesCount.compute(hash, (h, count) -> count + 1);
        }
        inMemoryIconInfo.imageOffsetInFile = offset;
        this.memoryCache.put((Object)offset, (Object)icon);
        this.inMemoryIconInfos.put(iconInfo.imageId, inMemoryIconInfo);
    }

    public IconInfo load(int iconId) {
        BufferedImage icon;
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        InMemoryIconInfo inMemoryIconInfo = this.inMemoryIconInfos.get(iconId);
        try {
            icon = (BufferedImage)this.memoryCache.get((Object)inMemoryIconInfo.imageOffsetInFile, () -> {
                RandomAccessFile randomAccessFile = this.storageRandomAccessFile;
                synchronized (randomAccessFile) {
                    this.storageRandomAccessFile.seek(inMemoryIconInfo.imageOffsetInFile);
                    ByteBuffer byteBuffer = ByteBuffer.allocate(inMemoryIconInfo.imageWidth * inMemoryIconInfo.imageHeight * 4);
                    this.storageRandomAccessFile.readFully(byteBuffer.array());
                    IntBuffer asIntBuffer = byteBuffer.asIntBuffer();
                    int[] imageInts = new int[inMemoryIconInfo.imageWidth * inMemoryIconInfo.imageHeight];
                    asIntBuffer.get(imageInts);
                    BufferedImage image = new BufferedImage(inMemoryIconInfo.imageWidth, inMemoryIconInfo.imageHeight, 2);
                    image.setRGB(0, 0, image.getWidth(), image.getHeight(), imageInts, 0, image.getWidth());
                    return image;
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        IconInfo iconInfo = new IconInfo();
        iconInfo.imageId = iconId;
        iconInfo.marker = new OnlineCalculatable.Marker(inMemoryIconInfo.markerY, inMemoryIconInfo.iconOffsetX, inMemoryIconInfo.iconOffsetY, icon);
        return iconInfo;
    }

    public void remove(int iconId) {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        InMemoryIconInfo removedInfo = this.inMemoryIconInfos.remove(iconId);
        Integer hash = (Integer)this.hashByOffset.get((Object)removedInfo.imageOffsetInFile);
        this.hashUsesCount.compute(hash, (h, count) -> count == 1 ? null : Integer.valueOf(count - 1));
    }

    private static class InMemoryIconInfo {
        double markerY;
        int iconOffsetX;
        int iconOffsetY;
        public long imageOffsetInFile;
        public int imageWidth;
        public int imageHeight;

        private InMemoryIconInfo() {
        }
    }

    public static class IconInfo {
        int imageId;
        OnlineCalculatable.Marker marker;
    }
}

