/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import velox.api.layer1.common.Log;
import velox.api.layer1.layers.strategies.interfaces.CalculatedResultListener;
import velox.api.layer1.layers.strategies.interfaces.InvalidateInterface;
import velox.api.layer1.layers.strategies.interfaces.OnlineValueCalculatorAdapter;
import velox.api.layer1.messages.indicators.Layer1ApiUserMessageModifyIndicator;
import velox.api.layer1.simplified.IndicatorBasicImplementation;
import velox.api.layer1.simplified.IndicatorModifiable;
import velox.api.layer1.simplified.InstanceWrapper;
import velox.api.layer1.simplified.Point;
import velox.api.layer1.simplified.SimplifiedL1ApiLoader;

class IndicatorModifiableBasicImplementation
extends IndicatorBasicImplementation
implements IndicatorModifiable {
    private SimplifiedL1ApiLoader simplifiedL1ApiLoader;
    private InvalidateInterface invalidateInerface;
    private long t0;
    private long intervalWidth;
    private long intervalsNumber;
    private AtomicBoolean isTimerLaunched;
    private final int timerDelayMillis = 200;

    public IndicatorModifiableBasicImplementation(SimplifiedL1ApiLoader simplifiedL1ApiLoader, String alias, String name, Layer1ApiUserMessageModifyIndicator.GraphType graphType, double initialValue, InstanceWrapper wrapper) {
        super(simplifiedL1ApiLoader, alias, name, graphType, initialValue, wrapper);
        this.simplifiedL1ApiLoader = simplifiedL1ApiLoader;
        this.isTimerLaunched = new AtomicBoolean(false);
    }

    @Override
    public void calculateValuesInRange(String indicatorName, String indicatorAlias, long t0, long intervalWidth, int intervalsNumber, CalculatedResultListener listener) {
        this.t0 = t0;
        this.intervalWidth = intervalWidth;
        this.intervalsNumber = intervalsNumber;
        super.calculateValuesInRange(indicatorName, indicatorAlias, t0, intervalWidth, intervalsNumber, listener);
    }

    @Override
    public OnlineValueCalculatorAdapter createOnlineValueCalculator(String indicatorName, String indicatorAlias, long time, final Consumer<Object> listener, InvalidateInterface invalidateInterface) {
        this.invalidateInerface = invalidateInterface;
        return new IndicatorBasicImplementation.OnlineCalculator(listener, time){

            @Override
            public void onLeftTimeChanged(long leftTime) {
                IndicatorModifiableBasicImplementation.this.t0 = leftTime;
                this.sendRelevantValue(listener);
            }

            public void onIntervalWidth(long intervalWidth) {
                IndicatorModifiableBasicImplementation.this.intervalWidth = intervalWidth;
            }

            public void onIntervalsNumber(int intervalsNumber) {
                IndicatorModifiableBasicImplementation.this.intervalsNumber = intervalsNumber;
            }
        };
    }

    @Override
    protected long getPointTime() {
        long time = this.simplifiedL1ApiLoader.mode == SimplifiedL1ApiLoader.Mode.GENERATORS ? this.wrapper.getTime() : (this.simplifiedL1ApiLoader.mode == SimplifiedL1ApiLoader.Mode.MIXED && !this.wrapper.isRealtime ? this.wrapper.getTime() : this.simplifiedL1ApiLoader.getCurrentTime());
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(long fromTimestamp, long toTimestamp) {
        Object object = this.points;
        synchronized (object) {
            this.points.subMap(fromTimestamp, toTimestamp).clear();
            if ((this.isWithinScreen(fromTimestamp) || this.isWithinScreen(toTimestamp) || this.isNextLeft(fromTimestamp) && this.isNextRight(toTimestamp)) && this.invalidateInerface != null) {
                this.invalidateInterfaceWithDelay(200);
            }
        }
        object = this.iconStorage;
        synchronized (object) {
            if (!this.iconStorage.isClosed()) {
                SortedMap removedSubmap = this.icons.subMap(fromTimestamp, toTimestamp);
                removedSubmap.values().stream().flatMap(Collection::stream).forEach(this.iconStorage::remove);
                removedSubmap.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPoint(long timestamp, double value) {
        TreeMap treeMap = this.points;
        synchronized (treeMap) {
            Point newPoint;
            if (Double.isNaN(value)) {
                newPoint = new Point(value);
                long key = timestamp;
                if (!this.isPreviousNullOrNan(this.points, key) && !this.isNextNullOrNan(this.points, key)) {
                    boolean isSectionEnd = false;
                    boolean isSectionNumberChanged = false;
                    while (isSectionEnd) {
                        Map.Entry higherEntry = this.points.higherEntry(key);
                        if (higherEntry == null) {
                            isSectionEnd = true;
                            continue;
                        }
                        Point nextPoint = (Point)higherEntry.getValue();
                        if (Double.isNaN(nextPoint.getValue())) {
                            isSectionEnd = true;
                            continue;
                        }
                        if (!isSectionNumberChanged) {
                            isSectionNumberChanged = true;
                            ++this.sectionNumber;
                        }
                        nextPoint.setSectionNumber(this.sectionNumber);
                        key = higherEntry.getKey();
                    }
                } else {
                    ++this.sectionNumber;
                }
            } else {
                newPoint = new Point(value, this.sectionNumber);
            }
            this.points.put(timestamp, newPoint);
            if (this.points.size() > 200000) {
                this.thinOutPoints();
            }
            if ((this.isWithinScreen(timestamp) || this.isNextToScreen(timestamp)) && timestamp != this.getPointTime() && this.invalidateInerface != null) {
                this.invalidateInterfaceWithDelay(200);
            }
        }
    }

    private boolean isPreviousNullOrNan(TreeMap<Long, Point> points, long key) {
        boolean isPreviousNullOrNan = false;
        if (points.lowerEntry(key) == null) {
            isPreviousNullOrNan = true;
        } else {
            Point previousPoint = points.lowerEntry(key).getValue();
            if (Double.isNaN(previousPoint.getValue())) {
                isPreviousNullOrNan = true;
            }
        }
        return isPreviousNullOrNan;
    }

    private boolean isNextNullOrNan(TreeMap<Long, Point> points, long key) {
        boolean isNextNullOrNan = false;
        if (points.higherEntry(key) == null) {
            isNextNullOrNan = true;
        } else {
            Point nextPoint = points.higherEntry(key).getValue();
            if (Double.isNaN(nextPoint.getValue())) {
                isNextNullOrNan = true;
            }
        }
        return isNextNullOrNan;
    }

    private boolean isWithinScreen(long timeStamp) {
        return timeStamp >= this.t0 && timeStamp <= this.t0 + this.intervalsNumber * this.intervalWidth;
    }

    private boolean isNextToScreen(long timeStamp) {
        return timeStamp < this.t0 ? this.isNextLeft(timeStamp) : this.isNextRight(timeStamp);
    }

    private boolean isNextLeft(long timeStamp) {
        Long screenBorderFloorKey = this.points.floorKey(this.t0);
        return screenBorderFloorKey == null && timeStamp < this.t0 || screenBorderFloorKey != null && timeStamp >= screenBorderFloorKey;
    }

    private boolean isNextRight(long timeStamp) {
        long rightTime = this.t0 + this.intervalsNumber * this.intervalWidth;
        Long screenBorderCeilingKey = this.points.ceilingKey(rightTime);
        return screenBorderCeilingKey == null && timeStamp > rightTime || screenBorderCeilingKey != null && timeStamp <= screenBorderCeilingKey;
    }

    private void invalidateInterfaceWithDelay(final int millis) {
        if (!this.isTimerLaunched.get()) {
            this.isTimerLaunched.set(true);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException e) {
                        Log.warn((String)"", (Exception)e);
                    }
                    IndicatorModifiableBasicImplementation.this.invalidateInerface.invalidate();
                    IndicatorModifiableBasicImplementation.this.isTimerLaunched.set(false);
                }
            });
            thread.setName("-> SimplifiedWrapper: invalidate interface for " + this.name);
            thread.start();
        }
    }
}

