/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import java.awt.Color;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import velox.api.layer1.Layer1ApiFinishable;
import velox.api.layer1.Layer1ApiInstrumentSpecificEnabledStateProvider;
import velox.api.layer1.Layer1ApiProvider;
import velox.api.layer1.Layer1CustomPanelsGetter;
import velox.api.layer1.annotations.Layer1TradingStrategy;
import velox.api.layer1.common.Log;
import velox.api.layer1.common.NanoClock;
import velox.api.layer1.data.BalanceInfo;
import velox.api.layer1.data.ExecutionInfo;
import velox.api.layer1.data.InstrumentInfo;
import velox.api.layer1.data.OrderInfoUpdate;
import velox.api.layer1.data.StatusInfo;
import velox.api.layer1.data.TradeInfo;
import velox.api.layer1.layers.Layer1ApiInjectorRelay;
import velox.api.layer1.layers.strategies.interfaces.CustomEventAggregatble;
import velox.api.layer1.layers.strategies.interfaces.CustomGeneratedEvent;
import velox.api.layer1.layers.strategies.interfaces.Layer1IndicatorColorInterface;
import velox.api.layer1.layers.strategies.interfaces.Layer1PriceAxisRangeCalculatable;
import velox.api.layer1.layers.strategies.interfaces.Layer1StrategyAddInterface;
import velox.api.layer1.layers.strategies.interfaces.Layer1WidgetRangeInterface;
import velox.api.layer1.layers.strategies.interfaces.OnlineCalculatable;
import velox.api.layer1.layers.strategies.interfaces.WidgetRangeConsumer;
import velox.api.layer1.layers.utils.OrderBook;
import velox.api.layer1.layers.utils.mbo.OrderBookMbo;
import velox.api.layer1.messages.CurrentTimeUserMessage;
import velox.api.layer1.messages.GeneratedEventInfo;
import velox.api.layer1.messages.Layer1ApiRequestCurrentTimeEvents;
import velox.api.layer1.messages.Layer1ApiUserMessageAddStrategyUpdateGenerator;
import velox.api.layer1.messages.UserMessageLayersChainCreatedTargeted;
import velox.api.layer1.messages.UserMessageRewindBase;
import velox.api.layer1.messages.indicators.AliasFilter;
import velox.api.layer1.messages.indicators.DataStructureInterface;
import velox.api.layer1.messages.indicators.IndicatorColorScheme;
import velox.api.layer1.messages.indicators.Layer1ApiDataInterfaceRequestMessage;
import velox.api.layer1.messages.indicators.Layer1ApiUserMessageModifyIndicator;
import velox.api.layer1.messages.indicators.SettingsAccess;
import velox.api.layer1.messages.indicators.StrategyUpdateGenerator;
import velox.api.layer1.messages.indicators.WidgetDisplayInfo;
import velox.api.layer1.settings.Layer1ConfigSettingsInterface;
import velox.api.layer1.simplified.CustomAggregationEvent;
import velox.api.layer1.simplified.CustomEvent;
import velox.api.layer1.simplified.CustomModule;
import velox.api.layer1.simplified.CustomSettingsPanelProvider;
import velox.api.layer1.simplified.DeactivatableStrategyUpdateGeneratorWithFilter;
import velox.api.layer1.simplified.HistoricalDataListener;
import velox.api.layer1.simplified.HistoricalModeListener;
import velox.api.layer1.simplified.IndicatorImplementation;
import velox.api.layer1.simplified.InitialState;
import velox.api.layer1.simplified.InstanceUtils;
import velox.api.layer1.simplified.InstanceWrapper;
import velox.api.layer1.simplified.LineStyle;
import velox.api.layer1.simplified.LoadSessionIdWrapper;
import velox.api.layer1.simplified.MessageListener;
import velox.api.layer1.simplified.MultiInstrumentListener;
import velox.api.layer1.simplified.Parameter;
import velox.api.layer1.simplified.ParameterFieldDeserializer;
import velox.api.layer1.simplified.UserSettings;
import velox.api.layer1.simplified.UserSettingsWrapper;
import velox.api.layer1.simplified.WidgetRangeProducer;
import velox.api.layer1.utils.PriceRangeCalculationHelper;
import velox.colors.ColorsChangedListener;
import velox.gui.StrategyPanel;

public class SimplifiedL1ApiLoader<T extends CustomModule>
extends Layer1ApiInjectorRelay
implements Layer1ApiFinishable,
Layer1CustomPanelsGetter,
Layer1ConfigSettingsInterface,
Layer1IndicatorColorInterface,
Layer1ApiInstrumentSpecificEnabledStateProvider,
Layer1PriceAxisRangeCalculatable,
Layer1WidgetRangeInterface,
Layer1StrategyAddInterface {
    Object settingsAccessLocker = new Object();
    static AtomicInteger generatorIndicatorIncrementalId = new AtomicInteger();
    public static final CustomEventAggregatble CUSTOM_TRADE_EVENTS_AGGREGATOR = new CustomEventAggregatble(){

        public CustomGeneratedEvent getInitialValue(long t) {
            return new CustomAggregationEvent(t, Collections.emptyMap(), Collections.emptyMap());
        }

        public void aggregateAggregationWithValue(CustomGeneratedEvent aggregation, CustomGeneratedEvent value) {
            CustomAggregationEvent aggregationEvent = (CustomAggregationEvent)aggregation;
            CustomEvent valueEvent = (CustomEvent)value;
            if (valueEvent.indicatorPoint != null) {
                aggregationEvent.indicators.put(valueEvent.indicatorId, valueEvent.indicatorPoint);
            }
            if (valueEvent.iconId != null) {
                aggregationEvent.icons.computeIfAbsent(valueEvent.indicatorId, k -> new ArrayList(1)).add(valueEvent.iconId);
            }
        }

        public void aggregateAggregationWithAggregation(CustomGeneratedEvent aggregation1, CustomGeneratedEvent aggregation2) {
            CustomAggregationEvent aggregationEvent1 = (CustomAggregationEvent)aggregation1;
            CustomAggregationEvent aggregationEvent2 = (CustomAggregationEvent)aggregation2;
            aggregationEvent1.indicators.putAll(aggregationEvent2.indicators);
            for (Map.Entry<Integer, List<Integer>> entry : aggregationEvent2.icons.entrySet()) {
                aggregationEvent1.icons.computeIfAbsent(entry.getKey(), k -> new ArrayList(((List)entry.getValue()).size())).addAll((Collection)entry.getValue());
            }
        }
    };
    static final Color DEFAULT_INDICATOR_COLOR = Color.WHITE;
    private static final String LOAD_SESSION_ID_POSTFIX = ".loadSessionId";
    private static final String GET_CUSTOM_DISABLED_SETTINGS_PANELS_METHOD_NAME = "getCustomDisabledSettingsPanels";
    private final Layer1ApiRequestCurrentTimeEvents requestCurrentTimeEventsMessage = new Layer1ApiRequestCurrentTimeEvents(true, 0L, TimeUnit.MILLISECONDS.toNanos(50L));
    DataStructureInterface dataStructureInterface;
    SettingsAccess settingsAccess;
    Class<T> simpleStrategyClass;
    private Map<String, InstanceWrapper> instanceWrappers = new ConcurrentHashMap<String, InstanceWrapper>();
    public Map<String, Map<String, UserSettings.ParameterField>> initialUserSettings = new ConcurrentHashMap<String, Map<String, UserSettings.ParameterField>>();
    Map<String, Runnable> invalidatePannelsFunctions = new ConcurrentHashMap<String, Runnable>();
    final Mode mode;
    final boolean multiInstrument;
    Map<String, InstrumentInfo> instruments = new ConcurrentHashMap<String, InstrumentInfo>();
    Map<String, OrderBook> orderBooks = new ConcurrentHashMap<String, OrderBook>();
    Map<String, OrderBookMbo> orderBooksMbo = new ConcurrentHashMap<String, OrderBookMbo>();
    Map<String, OrderInfoUpdate> orders = new ConcurrentHashMap<String, OrderInfoUpdate>();
    Map<String, StatusInfo> statuses = new ConcurrentHashMap<String, StatusInfo>();
    BalanceInfo balance;
    Map<String, InitialState> initialStates = new ConcurrentHashMap<String, InitialState>();
    Map<String, Runnable> strategyEnabledRecheckCallbacks = new ConcurrentHashMap<String, Runnable>();
    private HashMap<Pair<String, String>, Color> defaultColors = new HashMap();
    private long loadSessionId = 0L;
    private long runSessionId = NanoClock.currentTimeNanos();
    private ExecutorService userMessageExectuor = Executors.newSingleThreadExecutor();

    public SimplifiedL1ApiLoader(Layer1ApiProvider provider, Class<T> clazz) {
        super(provider);
        this.simpleStrategyClass = clazz;
        this.mode = HistoricalModeListener.class.isAssignableFrom(clazz) ? Mode.MIXED : (HistoricalDataListener.class.isAssignableFrom(clazz) ? Mode.GENERATORS : Mode.LIVE);
        this.multiInstrument = MultiInstrumentListener.class.isAssignableFrom(clazz);
    }

    public void onStrategyAdd() {
        this.loadSessionId = NanoClock.currentTimeNanos();
    }

    public void finish() {
        this.instanceWrappers.keySet().forEach(alias -> this.stopForInstrument((String)alias, false));
        this.requestCurrentTimeEventsMessage.setAdd(false);
        this.provider.sendUserMessage((Object)this.requestCurrentTimeEventsMessage);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.userMessageExectuor.execute(countDownLatch::countDown);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.userMessageExectuor.shutdown();
        super.close();
    }

    public void setColor(String alias, String name, Color color) {
        throw new UnsupportedOperationException("Setting color not supported");
    }

    public Color getColor(String alias, String name) {
        return this.defaultColors.get(new ImmutablePair((Object)alias, (Object)name));
    }

    void setSefaultColor(String alias, String name, Color color) {
        this.defaultColors.put((Pair<String, String>)new ImmutablePair((Object)alias, (Object)name), color);
    }

    public void addColorChangeListener(ColorsChangedListener listener) {
    }

    public void acceptSettingsInterface(SettingsAccess settingsAccess) {
        this.settingsAccess = settingsAccess;
        if (this.loadSessionId == 0L) {
            this.loadSessionId = ((LoadSessionIdWrapper)settingsAccess.getSettings(null, (String)new StringBuilder().append((String)this.simpleStrategyClass.getName()).append((String)LOAD_SESSION_ID_POSTFIX).toString(), LoadSessionIdWrapper.class)).loadSessionId;
        } else {
            settingsAccess.setSettings(null, this.simpleStrategyClass.getName() + LOAD_SESSION_ID_POSTFIX, (Object)new LoadSessionIdWrapper(this.loadSessionId), LoadSessionIdWrapper.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StrategyPanel[] getCustomGuiFor(String alias, String indicatorName) {
        StrategyPanel[] panels = new StrategyPanel[]{};
        InstanceWrapper instanceWrapper = this.instanceWrappers.get(alias);
        if (instanceWrapper == null) {
            try {
                Method getCustomSettingsPanelsMethod = this.simpleStrategyClass.getDeclaredMethod(GET_CUSTOM_DISABLED_SETTINGS_PANELS_METHOD_NAME, new Class[0]);
                panels = (StrategyPanel[])getCustomSettingsPanelsMethod.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                panels = new StrategyPanel[]{new StrategyPanel("Please enable the module to configure")};
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Failed to invoke \"public static StrategyPanel[] getCustomDisabledSettingsPanels()\", this might be caused by either signature mismatch or exception thrown by the method", e);
            }
        } else if (!instanceWrapper.areCustomSettingsPanelsReady()) {
            panels = new StrategyPanel[]{new StrategyPanel("Initializing...")};
        } else if (instanceWrapper.getInstance() instanceof CustomSettingsPanelProvider) {
            panels = instanceWrapper.getCustomSettingsPanels();
        } else {
            UserSettings settings;
            ArrayList<StrategyPanel> panelsList = new ArrayList<StrategyPanel>();
            Object object = this.settingsAccessLocker;
            synchronized (object) {
                String strategyFullName = this.simpleStrategyClass.getName();
                UserSettingsWrapper wrapper = (UserSettingsWrapper)this.settingsAccess.getSettings(alias, strategyFullName, UserSettingsWrapper.class);
                settings = wrapper.unwrap(UserSettings.class, UserSettings.ParameterField.class, ParameterFieldDeserializer.class);
                if (!settings.isEmpty()) {
                    InstanceUtils.setValuesFromSettings(settings, this.instanceWrappers.get(alias).getInstance(), Parameter.class);
                }
            }
            CustomModule instance = instanceWrapper.getInstance();
            StrategyPanel instrumentPanel = InstanceUtils.addCustomGui(instance, settings, "Settings", alias, this);
            panelsList.add(instrumentPanel);
            StrategyPanel colorPanel = InstanceUtils.getColorPanel(instance, this, alias);
            panelsList.add(0, colorPanel);
            panels = (StrategyPanel[])panelsList.stream().filter(p -> p != null).toArray(StrategyPanel[]::new);
        }
        if (panels.length == 0) {
            panels = new StrategyPanel[]{new StrategyPanel("This module is not configurable")};
        }
        if (panels.length > 0) {
            WeakReference<StrategyPanel> firstPanelReference = new WeakReference<StrategyPanel>(panels[0]);
            this.invalidatePannelsFunctions.put(alias, () -> {
                StrategyPanel strategyPanel = (StrategyPanel)firstPanelReference.get();
                if (strategyPanel != null) {
                    strategyPanel.requestReload();
                }
            });
        }
        return panels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void settingsChanged(String alias, UserSettings settings) {
        String strategyFullName = this.simpleStrategyClass.getName();
        Object object = this.settingsAccessLocker;
        synchronized (object) {
            settings.setLoadSessionId(this.loadSessionId);
            settings.setRunSessionId(this.runSessionId);
            settings.setInstrumentAlias(alias);
            UserSettingsWrapper wrapper = new UserSettingsWrapper();
            wrapper.wrap(settings);
            Object object2 = this.settingsAccessLocker;
            synchronized (object2) {
                this.settingsAccess.setSettings(alias, strategyFullName, (Object)wrapper, UserSettingsWrapper.class);
            }
        }
    }

    public void onStrategyCheckboxEnabled(String alias, boolean isEnabled) {
        Log.warn((String)("Enabled for " + alias + " " + isEnabled));
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference exception = new AtomicReference();
        this.inject(() -> {
            try {
                UserSettings settings = this.getUserSettings(alias);
                if (isEnabled) {
                    if (this.instruments.containsKey(alias)) {
                        this.startForInstrument(alias);
                    }
                    if (settings == null) {
                        settings = this.getUserSettings(alias);
                    }
                    settings.setLoadedAtStartup(true);
                    settings.setEnabled(true);
                } else {
                    this.stopForInstrument(alias, false);
                    settings.setLoadedAtStartup(true);
                    settings.setEnabled(false);
                }
                this.settingsChanged(alias, settings);
            }
            catch (Exception e) {
                exception.set(e);
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await();
            Log.warn((String)("Enabled for " + alias + " " + isEnabled));
            if (exception.get() != null) {
                throw new RuntimeException("Error while changing checkbox state", (Throwable)exception.get());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    void startForInstrument(String alias) {
        InstanceWrapper instanceWrapper = new InstanceWrapper(this, alias);
        this.instanceWrappers.put(alias, instanceWrapper);
        instanceWrapper.start();
    }

    void stopForInstrument(String alias, boolean invalidatePanels) {
        InstanceWrapper removedWrapper = this.instanceWrappers.remove(alias);
        if (removedWrapper != null) {
            removedWrapper.stop(invalidatePanels);
        }
    }

    public boolean isStrategyEnabled(String alias) {
        if (alias == null) {
            return false;
        }
        UserSettings settings = this.getUserSettings(alias);
        if (settings != null) {
            return settings.isEnabled();
        }
        return false;
    }

    public void setStrategyEnabledRecheckCallback(String alias, Runnable recheckCallback) {
        this.strategyEnabledRecheckCallbacks.put(alias, recheckCallback);
    }

    public void onUserMessage(Object data) {
        block6: {
            block7: {
                HashMap<String, InstrumentInfo> instrumentsCopy;
                block8: {
                    block5: {
                        super.onUserMessage(data);
                        for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                            CustomModule customModule = instanceWrapper.getInstance();
                            if (!(customModule instanceof MessageListener)) continue;
                            ((MessageListener)((Object)customModule)).onUserMessage(data);
                        }
                        if (data.getClass() != UserMessageLayersChainCreatedTargeted.class) break block5;
                        UserMessageLayersChainCreatedTargeted message = (UserMessageLayersChainCreatedTargeted)data;
                        if (message.targetClass != this.simpleStrategyClass) break block6;
                        this.provider.sendUserMessage((Object)new Layer1ApiDataInterfaceRequestMessage(dataStructureInterface -> {
                            this.dataStructureInterface = dataStructureInterface;
                        }));
                        this.requestCurrentTimeEventsMessage.setAdd(true);
                        this.provider.sendUserMessage((Object)this.requestCurrentTimeEventsMessage);
                        break block6;
                    }
                    if (!(data instanceof UserMessageRewindBase)) break block7;
                    instrumentsCopy = new HashMap<String, InstrumentInfo>(this.instruments);
                    if (this.mode != Mode.LIVE) break block8;
                    instrumentsCopy.keySet().forEach(alias -> this.removeInstrument((String)alias, false));
                    UserMessageRewindBase rewindMessage = (UserMessageRewindBase)data;
                    for (Map.Entry entry : rewindMessage.aliasToOrderBooksMap.entrySet()) {
                        String alias2 = (String)entry.getKey();
                        OrderBook orderBook = new OrderBook((OrderBook)entry.getValue());
                        InstrumentInfo instrumentInfo = (InstrumentInfo)instrumentsCopy.get(alias2);
                        if (instrumentInfo == null) continue;
                        OrderBookMbo orderBookMbo = new OrderBookMbo((OrderBookMbo)rewindMessage.aliasToOrderBooksMboMap.get(alias2));
                        this.addInstrument(alias2, instrumentInfo, orderBook, orderBookMbo);
                    }
                    break block6;
                }
                if (this.mode != Mode.MIXED) break block6;
                for (Map.Entry entry : instrumentsCopy.entrySet()) {
                    this.removeInstrument((String)entry.getKey(), false);
                    this.addInstrument((String)entry.getKey(), (InstrumentInfo)entry.getValue(), new OrderBook(), new OrderBookMbo());
                }
                break block6;
            }
            if (data instanceof CurrentTimeUserMessage) {
                for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                    instanceWrapper.setTime(this.getCurrentTime(), false);
                }
            }
        }
    }

    Layer1ApiUserMessageModifyIndicator getUserMessageModify(final String userReadableIndicatorName, Layer1ApiUserMessageModifyIndicator.GraphType graphType, LineStyle lineStyle, int renderPriority, int width, final Color defaultColor, final String indicatorAlias, boolean isAdd, OnlineCalculatable onlineCalculatable) {
        Layer1ApiUserMessageModifyIndicator.Builder builder = Layer1ApiUserMessageModifyIndicator.builder(this.simpleStrategyClass, (String)userReadableIndicatorName).extendFullName(indicatorAlias).setIsAdd(isAdd).setIndicatorColorScheme(new IndicatorColorScheme(){
            private final String defaultColorName;
            {
                this.defaultColorName = userReadableIndicatorName;
            }

            public IndicatorColorScheme.ColorDescription[] getColors() {
                return new IndicatorColorScheme.ColorDescription[]{new IndicatorColorScheme.ColorDescription(SimplifiedL1ApiLoader.this.simpleStrategyClass, this.defaultColorName, defaultColor, false)};
            }

            public IndicatorColorScheme.ColorIntervalResponse getColorIntervalsList(double valueFrom, double valueTo) {
                return new IndicatorColorScheme.ColorIntervalResponse(new String[]{this.defaultColorName}, new double[0]);
            }

            public String getColorFor(Double value) {
                return this.defaultColorName;
            }
        }).setColorInterface((Layer1IndicatorColorInterface)this).setGraphType(graphType).setIsSupportWidget(true).setIsShowColorSettings(false).setIndicatorLineStyle(lineStyle.toIndicatorStyle(width)).setOnlineCalculatable(onlineCalculatable).setAliasFiler(new AliasFilter(){

            public boolean isDisplayedForAlias(String alias) {
                return alias.equals(indicatorAlias);
            }
        }).setWidgetDisplayInfo(new WidgetDisplayInfo(WidgetDisplayInfo.Type.SYMMETRIC, 0.0)).setIsWidgetEnabledByDefault(true).setIsEnableSettingsFromConfigPopup(true);
        if (renderPriority != -1) {
            builder.setGraphLayerRenderPriority(renderPriority).setIconLayerRanderPriotity(renderPriority);
        }
        Layer1ApiUserMessageModifyIndicator message = builder.build();
        return message;
    }

    Layer1ApiUserMessageAddStrategyUpdateGenerator getGeneratorMessage(boolean isAdd, String targetAlias, DeactivatableStrategyUpdateGeneratorWithFilter generator) {
        return new Layer1ApiUserMessageAddStrategyUpdateGenerator(this.simpleStrategyClass, targetAlias, isAdd, true, (StrategyUpdateGenerator)generator, new GeneratedEventInfo[]{new GeneratedEventInfo(CustomEvent.class, CustomAggregationEvent.class, CUSTOM_TRADE_EVENTS_AGGREGATOR)});
    }

    public void onInstrumentAdded(String alias, InstrumentInfo instrumentInfo) {
        InstanceUtils.isTypeAllowed(this.simpleStrategyClass, Parameter.class);
        super.onInstrumentAdded(alias, instrumentInfo);
        this.addInstrument(alias, instrumentInfo, new OrderBook(), new OrderBookMbo());
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.onInstrumentAdded(alias, instrumentInfo, false);
            }
        }
    }

    private void addInstrument(String alias, InstrumentInfo instrumentInfo, OrderBook orderBook, OrderBookMbo orderBookMbo) {
        this.instruments.put(alias, instrumentInfo);
        this.orderBooks.put(alias, orderBook);
        this.orderBooksMbo.put(alias, orderBookMbo);
        UserSettings settings = this.getUserSettings(alias);
        if (settings != null && settings.isLoadedAtStartup() && settings.isEnabled()) {
            this.startForInstrument(alias);
        }
    }

    public void onInstrumentRemoved(String alias) {
        super.onInstrumentRemoved(alias);
        this.removeInstrument(alias, true);
    }

    private void removeInstrument(String alias, boolean invalidatePanels) {
        this.stopForInstrument(alias, invalidatePanels);
        this.instruments.remove(alias);
        this.orderBooks.remove(alias);
        this.orderBooksMbo.remove(alias);
    }

    public void onDepth(String alias, boolean isBid, int price, int size) {
        Object orderBook;
        super.onDepth(alias, isBid, price, size);
        if (this.mode == Mode.LIVE && (orderBook = this.orderBooks.get(alias)) != null) {
            orderBook.onUpdate(isBid, price, (long)size);
        }
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.onDepth(alias, isBid, price, size, false);
            }
        } else {
            InstanceWrapper instanceWrapper = this.instanceWrappers.get(alias);
            if (instanceWrapper != null) {
                instanceWrapper.onDepth(alias, isBid, price, size, false);
            }
        }
    }

    public void onMboSend(String alias, String orderId, boolean isBid, int price, int size) {
        Object orderBook;
        super.onMboSend(alias, orderId, isBid, price, size);
        if (this.mode == Mode.LIVE && (orderBook = this.orderBooksMbo.get(alias)) != null) {
            orderBook.send(orderId, isBid, price, size);
        }
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.send(alias, orderId, isBid, price, size, false);
            }
        } else {
            InstanceWrapper instanceWrapper = this.instanceWrappers.get(alias);
            if (instanceWrapper != null) {
                instanceWrapper.send(alias, orderId, isBid, price, size, false);
            }
        }
    }

    public void onMboReplace(String alias, String orderId, int price, int size) {
        Object orderBook;
        super.onMboReplace(alias, orderId, price, size);
        if (this.mode == Mode.LIVE && (orderBook = this.orderBooksMbo.get(alias)) != null) {
            orderBook.replace(orderId, price, size);
        }
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.replace(alias, orderId, price, size, false);
            }
        } else {
            InstanceWrapper instanceWrapper = this.instanceWrappers.get(alias);
            if (instanceWrapper != null) {
                instanceWrapper.replace(alias, orderId, price, size, false);
            }
        }
    }

    public void onMboCancel(String alias, String orderId) {
        Object orderBook;
        super.onMboCancel(alias, orderId);
        if (this.mode == Mode.LIVE && (orderBook = this.orderBooksMbo.get(alias)) != null) {
            orderBook.cancel(orderId);
        }
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.cancel(alias, orderId, false);
            }
        } else {
            InstanceWrapper instanceWrapper = this.instanceWrappers.get(alias);
            if (instanceWrapper != null) {
                instanceWrapper.cancel(alias, orderId, false);
            }
        }
    }

    public void onTrade(String alias, double price, int size, TradeInfo tradeInfo) {
        super.onTrade(alias, price, size, tradeInfo);
        if (this.mode == Mode.LIVE) {
            Object initialState = this.initialStates.get(alias);
            if (initialState == null) {
                initialState = new InitialState();
                this.initialStates.put(alias, (InitialState)initialState);
            }
            ((InitialState)initialState).lastTradePrice = price;
            ((InitialState)initialState).lastTradeSize = size;
            ((InitialState)initialState).tradeInfo = tradeInfo;
        }
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.onTrade(alias, price, size, tradeInfo, false);
            }
        } else {
            InstanceWrapper instanceWrapper = this.instanceWrappers.get(alias);
            if (instanceWrapper != null) {
                instanceWrapper.onTrade(alias, price, size, tradeInfo, false);
            }
        }
    }

    public void onOrderUpdated(OrderInfoUpdate orderInfoUpdate) {
        super.onOrderUpdated(orderInfoUpdate);
        this.orders.put(orderInfoUpdate.orderId, orderInfoUpdate);
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.onOrderUpdated(orderInfoUpdate, false);
            }
        } else {
            InstanceWrapper instanceWrapper = this.instanceWrappers.get(orderInfoUpdate.instrumentAlias);
            if (instanceWrapper != null) {
                instanceWrapper.onOrderUpdated(orderInfoUpdate, false);
            }
        }
    }

    public void onOrderExecuted(ExecutionInfo executionInfo) {
        super.onOrderExecuted(executionInfo);
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.onOrderExecuted(executionInfo, false);
            }
        } else {
            String alias = this.orders.get((Object)executionInfo.orderId).instrumentAlias;
            InstanceWrapper instanceWrapper = this.instanceWrappers.get(alias);
            if (instanceWrapper != null) {
                instanceWrapper.onOrderExecuted(executionInfo, false);
            }
        }
    }

    public void onStatus(StatusInfo statusInfo) {
        super.onStatus(statusInfo);
        this.statuses.put(statusInfo.instrumentAlias, statusInfo);
        if (this.multiInstrument) {
            for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
                instanceWrapper.onStatus(statusInfo, false);
            }
        } else {
            InstanceWrapper instanceWrapper = this.instanceWrappers.get(statusInfo.instrumentAlias);
            if (instanceWrapper != null) {
                instanceWrapper.onStatus(statusInfo, false);
            }
        }
    }

    public void onBalance(BalanceInfo balanceInfo) {
        super.onBalance(balanceInfo);
        this.balance = balanceInfo;
        for (InstanceWrapper instanceWrapper : this.instanceWrappers.values()) {
            instanceWrapper.onBalance(balanceInfo, false);
        }
    }

    public Map<String, Layer1PriceAxisRangeCalculatable.ResultPriceAxisInfo> getPriceRanges(String alias, double linesCount, Map<String, Layer1PriceAxisRangeCalculatable.InputPriceAxisInfo> inputInfo) {
        InstanceWrapper instanceWrapper = this.instanceWrappers.get(alias);
        if (instanceWrapper == null) {
            return PriceRangeCalculationHelper.getGoodNumbersCalculation((double)linesCount, inputInfo);
        }
        return instanceWrapper.getPriceRanges(linesCount, inputInfo);
    }

    public UserSettings createUserSettingsFromAnnotations(Object instance, Class<? extends Annotation> clazz, String alias, boolean settingsExist) {
        Map<String, UserSettings.ParameterField> aliasSettings = InstanceUtils.readSettingsFromAnnotations(instance, Parameter.class);
        UserSettings settings = settingsExist ? this.getUserSettings(alias) : new UserSettings();
        settings.setSettings(aliasSettings);
        return settings;
    }

    public void restartInstrument(String alias) {
        this.inject(() -> {
            this.stopForInstrument(alias, false);
            this.startForInstrument(alias);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserSettings getUserSettings(String alias) {
        UserSettingsWrapper wrapper;
        String strategyFullName = this.simpleStrategyClass.getName();
        boolean isTradingStrategy = this.simpleStrategyClass.getAnnotation(Layer1TradingStrategy.class) != null;
        Object object = this.settingsAccessLocker;
        synchronized (object) {
            wrapper = (UserSettingsWrapper)this.settingsAccess.getSettings(alias, strategyFullName, UserSettingsWrapper.class);
        }
        UserSettings settings = wrapper.unwrap(UserSettings.class, UserSettings.ParameterField.class, ParameterFieldDeserializer.class);
        if (settings != null && settings.getLoadSessionId() != this.loadSessionId) {
            Log.info((String)(strategyFullName + ": Strategy settings were saved before it was loaded last time, disabling for " + alias));
            settings.setEnabled(false);
        } else if (settings != null && settings.getRunSessionId() != this.runSessionId && isTradingStrategy) {
            Log.info((String)(strategyFullName + ": Strategy settings from previous session loaded for " + alias + ", disabling since it's a trading strategy."));
            settings.setEnabled(false);
        } else if (settings != null && !StringUtils.equals((CharSequence)settings.getInstrumentAlias(), (CharSequence)alias) && isTradingStrategy) {
            Log.info((String)("Strategy settings were inherited, since it's a trading strategy - disabling for " + alias));
            settings.setEnabled(false);
        }
        return settings;
    }

    public void setWidgetConsumer(String alias, String fullName, WidgetRangeConsumer consumer) {
        IndicatorImplementation implementation;
        InstanceWrapper wrapper = this.instanceWrappers.get(alias);
        if (wrapper != null && (implementation = wrapper.indicators.get(fullName)) instanceof WidgetRangeProducer) {
            IndicatorImplementation producer = implementation;
            producer.setWidgetRangeConsumer(consumer);
        }
    }

    void loaderInject(Runnable r) {
        super.inject(r);
    }

    public void sendUserMessageAsync(Object data) {
        this.userMessageExectuor.execute(() -> this.sendUserMessage(data));
    }

    public Object sendUserMessage(Object data) {
        return super.sendUserMessage(data);
    }

    public static enum Mode {
        LIVE,
        GENERATORS,
        MIXED;

    }
}

