/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import velox.api.layer1.messages.indicators.IndicatorLineStyle;

public enum LineStyle {
    SOLID("Solid", IndicatorLineStyle.DEFAULT),
    SHORT_DASH("Short dash", new IndicatorLineStyle(-256, 1, 0, -3856, 1, 0)),
    LONG_DASH("Long dash", new IndicatorLineStyle(-256, 2, 0, -256, 1, 0)),
    DOT("Dot", new IndicatorLineStyle(21845, 2, 0, 21845, 1, 0)),
    DASH_DOT("Dot-dash", new IndicatorLineStyle(-171, 2, 0, -171, 1, 0));

    private final String stringRepresentation;
    private final IndicatorLineStyle baseStyle;

    private LineStyle(String stringRepresentation, IndicatorLineStyle baseStyle) {
        this.stringRepresentation = stringRepresentation;
        this.baseStyle = baseStyle;
    }

    public IndicatorLineStyle toIndicatorStyle(int width) {
        return new IndicatorLineStyle(this.baseStyle.mainLineStyleMask, this.baseStyle.mainLineStyleMultiplier, width, this.baseStyle.rightLineStyleMask, this.baseStyle.rightLineStyleMultiplier, width);
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

