/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.tuple.Pair;
import velox.api.layer1.Layer1ApiMboDataAdapter;
import velox.api.layer1.Layer1ApiMboDataListener;
import velox.api.layer1.Layer1ApiProvider;
import velox.api.layer1.common.Log;
import velox.api.layer1.data.BalanceInfo;
import velox.api.layer1.data.ExecutionInfo;
import velox.api.layer1.data.InstrumentInfo;
import velox.api.layer1.data.OrderInfoUpdate;
import velox.api.layer1.data.OrderSendParameters;
import velox.api.layer1.data.OrderUpdateParameters;
import velox.api.layer1.data.StatusInfo;
import velox.api.layer1.data.TradeInfo;
import velox.api.layer1.layers.strategies.interfaces.Layer1PriceAxisRangeCalculatable;
import velox.api.layer1.layers.utils.OrderBook;
import velox.api.layer1.layers.utils.mbo.OrderBookMboUnsorted;
import velox.api.layer1.messages.Layer1ApiUserMessageAddStrategyUpdateGenerator;
import velox.api.layer1.messages.indicators.Layer1ApiUserMessageModifyIndicator;
import velox.api.layer1.simplified.Api;
import velox.api.layer1.simplified.AxisGroup;
import velox.api.layer1.simplified.AxisRules;
import velox.api.layer1.simplified.BalanceListener;
import velox.api.layer1.simplified.Bar;
import velox.api.layer1.simplified.BarDataListener;
import velox.api.layer1.simplified.BboListener;
import velox.api.layer1.simplified.CustomModule;
import velox.api.layer1.simplified.CustomSettingsPanelProvider;
import velox.api.layer1.simplified.DeactivatableStrategyUpdateGeneratorWithFilter;
import velox.api.layer1.simplified.DepthDataListener;
import velox.api.layer1.simplified.HistoricalModeListener;
import velox.api.layer1.simplified.Indicator;
import velox.api.layer1.simplified.IndicatorArrayImplementation;
import velox.api.layer1.simplified.IndicatorBasicImplementation;
import velox.api.layer1.simplified.IndicatorGeneratorImplementation;
import velox.api.layer1.simplified.IndicatorImplementation;
import velox.api.layer1.simplified.IndicatorModifiable;
import velox.api.layer1.simplified.IndicatorModifiableBasicImplementation;
import velox.api.layer1.simplified.InitialState;
import velox.api.layer1.simplified.InstanceUtils;
import velox.api.layer1.simplified.IntervalListener;
import velox.api.layer1.simplified.Intervals;
import velox.api.layer1.simplified.MarketByOrderDepthDataListener;
import velox.api.layer1.simplified.MultiInstrumentListener;
import velox.api.layer1.simplified.NoAutosubscription;
import velox.api.layer1.simplified.OrdersListener;
import velox.api.layer1.simplified.Parameter;
import velox.api.layer1.simplified.PositionListener;
import velox.api.layer1.simplified.SimplifiedL1ApiLoader;
import velox.api.layer1.simplified.SnapshotEndListener;
import velox.api.layer1.simplified.TimeListener;
import velox.api.layer1.simplified.TradeDataListener;
import velox.api.layer1.simplified.UserSettings;
import velox.api.layer1.utils.PriceRangeCalculationHelper;
import velox.gui.StrategyPanel;

class InstanceWrapper
implements Api {
    private static final String DIRECT_SETTINGS_POSTFIX = ".direct";
    private SimplifiedL1ApiLoader<? extends CustomModule> simplifiedL1ApiLoader;
    private final CustomModule instance;
    private final String alias;
    Map<String, IndicatorImplementation> indicators = new ConcurrentHashMap<String, IndicatorImplementation>();
    final List<DepthDataListener> depthDataListeners = new ArrayList<DepthDataListener>();
    final List<MarketByOrderDepthDataListener> marketByOrderDepthDataListeners = new ArrayList<MarketByOrderDepthDataListener>();
    final List<BboListener> bboDataListeners = new ArrayList<BboListener>();
    final List<BarDataListener> barDataListeners = new ArrayList<BarDataListener>();
    private final List<TimeListener> timeListeners = new ArrayList<TimeListener>();
    private final List<SnapshotEndListener> snapshotEndListeners = new ArrayList<SnapshotEndListener>();
    private final List<TradeDataListener> tradeDataListeners = new ArrayList<TradeDataListener>();
    private final List<IntervalListener> intervalListeners = new ArrayList<IntervalListener>();
    private final List<OrdersListener> ordersListeners = new ArrayList<OrdersListener>();
    private final List<PositionListener> statusListeners = new ArrayList<PositionListener>();
    private final List<BalanceListener> balanceListeners = new ArrayList<BalanceListener>();
    private final List<HistoricalModeListener> historicalModeListeners = new ArrayList<HistoricalModeListener>();
    private final List<MultiInstrumentListener> multiInstrumentListeners = new ArrayList<MultiInstrumentListener>();
    private boolean initializing;
    private boolean stopped;
    private boolean customSettingsPanelsReady;
    private long time = 0L;
    boolean isRealtime = false;
    private long firstRealtimeEventTime = 0L;
    private String currentAlias;
    Layer1ApiUserMessageAddStrategyUpdateGenerator generatorMessage;
    private long interval = -1L;
    private Map<String, Bar> currentBars = new HashMap<String, Bar>();
    private Map<String, OrderBook> submittedOrderBooks = new HashMap<String, OrderBook>();
    private boolean sendingSnapshots = false;
    private HashSet<String> snapshotEndsSent = new HashSet();
    private HashMap<String, Long> firstDepthUpdateTimes = new HashMap();
    private HashMap<String, DeactivatableStrategyUpdateGeneratorWithFilter> activeGenerators = new HashMap();

    public InstanceWrapper(SimplifiedL1ApiLoader<? extends CustomModule> simplifiedL1ApiLoader, String alias) {
        this.simplifiedL1ApiLoader = simplifiedL1ApiLoader;
        this.alias = alias;
        try {
            UserSettings settings;
            this.instance = (CustomModule)simplifiedL1ApiLoader.simpleStrategyClass.newInstance();
            String strategyFullName = simplifiedL1ApiLoader.simpleStrategyClass.getName();
            Map<String, UserSettings.ParameterField> settingsMap = InstanceUtils.readDefaultColorSettings(this.instance, Parameter.class);
            if (simplifiedL1ApiLoader.initialUserSettings.get(strategyFullName) == null) {
                simplifiedL1ApiLoader.initialUserSettings.put(strategyFullName, settingsMap);
            }
            if ((settings = simplifiedL1ApiLoader.getUserSettings(alias)) == null) {
                settings = simplifiedL1ApiLoader.createUserSettingsFromAnnotations(this.instance, Parameter.class, alias, false);
                simplifiedL1ApiLoader.settingsChanged(alias, settings);
            } else {
                InstanceUtils.setValuesFromSettings(settings, this.getInstance(), Parameter.class);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Failed to create instance", e);
        }
    }

    public CustomModule getInstance() {
        return this.instance;
    }

    public void start() {
        InitialState initialState = this.simplifiedL1ApiLoader.initialStates.computeIfAbsent(this.alias, k -> new InitialState());
        if (this.simplifiedL1ApiLoader.mode == SimplifiedL1ApiLoader.Mode.LIVE) {
            initialState.currentTime = this.simplifiedL1ApiLoader.getCurrentTime();
        }
        this.initializing = true;
        this.instance.initialize(this.alias, this.simplifiedL1ApiLoader.instruments.get(this.alias), this, initialState);
        this.initializing = false;
        this.addListener(this.instance);
        if (this.simplifiedL1ApiLoader.mode == SimplifiedL1ApiLoader.Mode.GENERATORS || this.simplifiedL1ApiLoader.mode == SimplifiedL1ApiLoader.Mode.MIXED) {
            DeactivatableStrategyUpdateGeneratorWithFilter generator = new DeactivatableStrategyUpdateGeneratorWithFilter(this.simplifiedL1ApiLoader, this.alias, this);
            this.generatorMessage = this.simplifiedL1ApiLoader.getGeneratorMessage(true, this.alias, generator);
            this.activeGenerators.put(this.generatorMessage.fullName, generator);
            this.simplifiedL1ApiLoader.sendUserMessageAsync(this.generatorMessage);
        } else {
            this.sendSnapshots();
        }
        SwingUtilities.invokeLater(() -> {
            this.customSettingsPanelsReady = true;
            Runnable invalidatePannelsFunction = this.simplifiedL1ApiLoader.invalidatePannelsFunctions.get(this.alias);
            if (invalidatePannelsFunction != null) {
                invalidatePannelsFunction.run();
            }
        });
    }

    private void sendSnapshots() {
        this.sendingSnapshots = true;
        Map<String, InstrumentInfo> instrumentInfosToSend = this.simplifiedL1ApiLoader.multiInstrument ? this.simplifiedL1ApiLoader.instruments : Collections.singletonMap(this.alias, this.simplifiedL1ApiLoader.instruments.get(this.alias));
        for (Map.Entry<String, InstrumentInfo> entry : instrumentInfosToSend.entrySet()) {
            this.onInstrumentAdded(entry.getKey(), entry.getValue(), false);
        }
        Map<String, OrderBook> orderBooksToSend = this.simplifiedL1ApiLoader.multiInstrument ? this.simplifiedL1ApiLoader.orderBooks : Collections.singletonMap(this.alias, this.simplifiedL1ApiLoader.orderBooks.get(this.alias));
        for (Map.Entry<String, OrderBook> entry : orderBooksToSend.entrySet()) {
            String string = entry.getKey();
            OrderBook orderBook = entry.getValue();
            for (Map.Entry entry2 : orderBook.getBidMap().entrySet()) {
                this.onDepth(string, true, (Integer)entry2.getKey(), ((Long)entry2.getValue()).intValue(), false);
            }
            for (Map.Entry entry2 : orderBook.getAskMap().entrySet()) {
                this.onDepth(string, false, (Integer)entry2.getKey(), ((Long)entry2.getValue()).intValue(), false);
            }
        }
        Map<String, OrderBookMboUnsorted> map = this.simplifiedL1ApiLoader.multiInstrument ? this.simplifiedL1ApiLoader.orderBooksMbo : Collections.singletonMap(this.alias, this.simplifiedL1ApiLoader.orderBooksMbo.get(this.alias));
        for (Map.Entry<String, OrderBookMboUnsorted> entry : map.entrySet()) {
            String alias = entry.getKey();
            OrderBookMboUnsorted orderBook = entry.getValue();
            orderBook.sendDataToListener(alias, (Layer1ApiMboDataListener)new Layer1ApiMboDataAdapter(){

                public void onMboSend(String alias, String orderId, boolean isBid, int price, int size) {
                    InstanceWrapper.this.send(alias, orderId, isBid, price, size, false);
                }
            });
        }
        for (Map.Entry<String, OrderInfoUpdate> entry : this.simplifiedL1ApiLoader.orders.entrySet()) {
            this.onOrderUpdated(entry.getValue(), false);
        }
        Map<String, StatusInfo> map2 = this.simplifiedL1ApiLoader.multiInstrument ? this.simplifiedL1ApiLoader.statuses : (this.simplifiedL1ApiLoader.statuses.containsKey(this.alias) ? Collections.singletonMap(this.alias, this.simplifiedL1ApiLoader.statuses.get(this.alias)) : Collections.emptyMap());
        for (Map.Entry<String, StatusInfo> entry : map2.entrySet()) {
            this.onStatus(entry.getValue(), false);
        }
        if (this.simplifiedL1ApiLoader.balance != null) {
            this.onBalance(this.simplifiedL1ApiLoader.balance, false);
        }
        this.sendingSnapshots = false;
    }

    public void stop(boolean invalidatePanels) {
        Runnable invalidatePannelsFunction;
        this.stopped = true;
        this.instance.stop();
        this.indicators.values().forEach(IndicatorImplementation::remove);
        this.indicators.values().forEach(IndicatorImplementation::dispose);
        DeactivatableStrategyUpdateGeneratorWithFilter generator = new DeactivatableStrategyUpdateGeneratorWithFilter(this.simplifiedL1ApiLoader, this.alias, this);
        Layer1ApiUserMessageAddStrategyUpdateGenerator generatorMessage = this.simplifiedL1ApiLoader.getGeneratorMessage(false, this.alias, generator);
        DeactivatableStrategyUpdateGeneratorWithFilter activeGenerator = this.activeGenerators.get(generatorMessage.fullName);
        if (activeGenerator != null) {
            activeGenerator.deactivate();
            this.activeGenerators.remove(generatorMessage.fullName);
        }
        this.simplifiedL1ApiLoader.sendUserMessageAsync(generatorMessage);
        if (invalidatePanels && (invalidatePannelsFunction = this.simplifiedL1ApiLoader.invalidatePannelsFunctions.get(this.alias)) != null) {
            invalidatePannelsFunction.run();
        }
    }

    public void addListener(Object simplifiedListener) {
        if (this.simplifiedL1ApiLoader.simpleStrategyClass.isAnnotationPresent(NoAutosubscription.class)) {
            return;
        }
        if (simplifiedListener instanceof TimeListener) {
            this.timeListeners.add((TimeListener)simplifiedListener);
        }
        if (simplifiedListener instanceof DepthDataListener) {
            this.depthDataListeners.add((DepthDataListener)simplifiedListener);
        }
        if (simplifiedListener instanceof MarketByOrderDepthDataListener) {
            this.marketByOrderDepthDataListeners.add((MarketByOrderDepthDataListener)simplifiedListener);
        }
        if (simplifiedListener instanceof SnapshotEndListener) {
            this.snapshotEndListeners.add((SnapshotEndListener)simplifiedListener);
        }
        if (simplifiedListener instanceof TradeDataListener) {
            this.tradeDataListeners.add((TradeDataListener)simplifiedListener);
        }
        if (simplifiedListener instanceof IntervalListener) {
            this.interval = ((IntervalListener)((Object)this.instance)).getInterval();
            if (this.interval < Intervals.MIN_INTERVAL) {
                throw new IllegalArgumentException("IntervalListener#getInterval < Intervals#MIN_INTERVAL (" + this.interval + ")");
            }
            this.intervalListeners.add((IntervalListener)simplifiedListener);
        }
        if (simplifiedListener instanceof BarDataListener) {
            this.barDataListeners.add((BarDataListener)simplifiedListener);
        }
        if (simplifiedListener instanceof BboListener) {
            this.bboDataListeners.add((BboListener)simplifiedListener);
        }
        if (simplifiedListener instanceof OrdersListener) {
            this.ordersListeners.add((OrdersListener)simplifiedListener);
        }
        if (simplifiedListener instanceof PositionListener) {
            this.statusListeners.add((PositionListener)simplifiedListener);
        }
        if (simplifiedListener instanceof BalanceListener) {
            this.balanceListeners.add((BalanceListener)simplifiedListener);
        }
        if (simplifiedListener instanceof HistoricalModeListener) {
            this.historicalModeListeners.add((HistoricalModeListener)simplifiedListener);
        }
        if (simplifiedListener instanceof MultiInstrumentListener) {
            this.multiInstrumentListeners.add((MultiInstrumentListener)simplifiedListener);
        }
    }

    @Override
    public Indicator registerIndicator(String name, Layer1ApiUserMessageModifyIndicator.GraphType graphType, double initialValue, boolean showLineByDefault, boolean showWidgetByDefault) {
        if (!this.initializing) {
            throw new IllegalStateException("Registering indicators is only allowed inside CustomModule#initialize");
        }
        IndicatorImplementation indicatorImplementation = this.simplifiedL1ApiLoader.mode == SimplifiedL1ApiLoader.Mode.GENERATORS ? new IndicatorGeneratorImplementation(this.simplifiedL1ApiLoader, this.alias, name, graphType, initialValue, showWidgetByDefault, showLineByDefault, this, SimplifiedL1ApiLoader.generatorIndicatorIncrementalId.getAndIncrement()) : new IndicatorBasicImplementation(this.simplifiedL1ApiLoader, this.alias, name, graphType, initialValue, showWidgetByDefault, showLineByDefault, this);
        indicatorImplementation.register();
        this.indicators.put(indicatorImplementation.getFullName(), indicatorImplementation);
        return indicatorImplementation;
    }

    @Override
    public IndicatorModifiable registerIndicatorModifiable(String name, Layer1ApiUserMessageModifyIndicator.GraphType graphType, double initialValue, boolean showLineByDefault, boolean showWidgetByDefault) {
        return this.registerIndicatorModifiable(name, graphType, initialValue, showLineByDefault, showWidgetByDefault, false, null);
    }

    public IndicatorModifiable registerIndicatorModifiable(String name, Layer1ApiUserMessageModifyIndicator.GraphType graphType, double initialValue, boolean fullClearOnly, BiFunction<Double, Double, Double> aggregationFunction) {
        return this.registerIndicatorModifiable(name, graphType, initialValue, true, true, fullClearOnly, aggregationFunction);
    }

    public IndicatorModifiable registerIndicatorModifiable(String name, Layer1ApiUserMessageModifyIndicator.GraphType graphType, double initialValue, boolean showLineByDefault, boolean showWidgetByDefault, boolean fullClearOnly, BiFunction<Double, Double, Double> aggregationFunction) {
        IndicatorImplementation indicatorImplementation;
        if (!this.initializing) {
            throw new IllegalStateException("Registering indicators is only allowed inside CustomModule#initialize");
        }
        if (fullClearOnly) {
            indicatorImplementation = new IndicatorArrayImplementation(this.simplifiedL1ApiLoader, this.alias, name, graphType, initialValue, showWidgetByDefault, showLineByDefault, aggregationFunction, this);
        } else if (aggregationFunction == null) {
            indicatorImplementation = new IndicatorModifiableBasicImplementation((SimplifiedL1ApiLoader)this.simplifiedL1ApiLoader, this.alias, name, graphType, initialValue, showWidgetByDefault, showLineByDefault, this);
        } else {
            throw new IllegalArgumentException("Unsupported parameter combination: partial modification is not allowed for indicators with aggregator function");
        }
        indicatorImplementation.register();
        this.indicators.put(indicatorImplementation.getFullName(), indicatorImplementation);
        return (IndicatorModifiable)((Object)indicatorImplementation);
    }

    public void onDepth(String alias, boolean isBid, int price, int size, boolean fromGenerator) {
        if (this.eventShouldBePublished(fromGenerator) && (this.simplifiedL1ApiLoader.multiInstrument || this.alias.equals(alias))) {
            this.setCurrentAlias(alias);
            if (!this.bboDataListeners.isEmpty() || !this.barDataListeners.isEmpty()) {
                OrderBook submittedOrderBook = this.submittedOrderBooks.get(alias);
                if (submittedOrderBook == null) {
                    submittedOrderBook = new OrderBook();
                    this.submittedOrderBooks.put(alias, submittedOrderBook);
                }
                submittedOrderBook.onUpdate(isBid, price, (long)size);
                if (!this.bboDataListeners.isEmpty()) {
                    int bestPriceOnSameSide;
                    int n = bestPriceOnSameSide = isBid ? submittedOrderBook.getBestBidPriceOrNone() : submittedOrderBook.getBestAskPriceOrNone();
                    if (price == bestPriceOnSameSide) {
                        Map.Entry firstBidEntry = submittedOrderBook.getBidMap().firstEntry();
                        Map.Entry firstAskEntry = submittedOrderBook.getAskMap().firstEntry();
                        if (firstBidEntry != null && firstAskEntry != null) {
                            for (BboListener listener : this.bboDataListeners) {
                                listener.onBbo((Integer)firstBidEntry.getKey(), ((Long)firstBidEntry.getValue()).intValue(), (Integer)firstAskEntry.getKey(), ((Long)firstAskEntry.getValue()).intValue());
                            }
                        }
                    }
                }
            }
            this.invokeCurrentTimeListeners(fromGenerator, true);
            boolean snapshotEndSent = this.snapshotEndsSent.contains(alias);
            long firstDepthUpdateTime = this.firstDepthUpdateTimes.getOrDefault(alias, -1L);
            if (!snapshotEndSent && firstDepthUpdateTime == -1L) {
                firstDepthUpdateTime = this.time;
                this.firstDepthUpdateTimes.put(alias, firstDepthUpdateTime);
            }
            if (!snapshotEndSent && !this.sendingSnapshots && this.time > firstDepthUpdateTime) {
                this.invokeSnapshotEndListeners(alias);
            }
            for (DepthDataListener listener : this.depthDataListeners) {
                listener.onDepth(isBid, price, size);
            }
        }
    }

    public void send(String alias, String orderId, boolean isBid, int price, int size, boolean fromGenerator) {
        if (this.eventShouldBePublished(fromGenerator) && (this.simplifiedL1ApiLoader.multiInstrument || this.alias.equals(alias))) {
            this.setCurrentAlias(alias);
            this.invokeCurrentTimeListeners(fromGenerator, true);
            for (MarketByOrderDepthDataListener listener : this.marketByOrderDepthDataListeners) {
                listener.send(orderId, isBid, price, size);
            }
        }
    }

    public void replace(String alias, String orderId, int price, int size, boolean fromGenerator) {
        if (this.eventShouldBePublished(fromGenerator) && (this.simplifiedL1ApiLoader.multiInstrument || this.alias.equals(alias))) {
            this.setCurrentAlias(alias);
            this.invokeCurrentTimeListeners(fromGenerator, true);
            for (MarketByOrderDepthDataListener listener : this.marketByOrderDepthDataListeners) {
                listener.replace(orderId, price, size);
            }
        }
    }

    public void cancel(String alias, String orderId, boolean fromGenerator) {
        if (this.eventShouldBePublished(fromGenerator) && (this.simplifiedL1ApiLoader.multiInstrument || this.alias.equals(alias))) {
            this.setCurrentAlias(alias);
            this.invokeCurrentTimeListeners(fromGenerator, true);
            for (MarketByOrderDepthDataListener listener : this.marketByOrderDepthDataListeners) {
                listener.cancel(orderId);
            }
        }
    }

    private void invokeSnapshotEndListeners(String alias) {
        for (SnapshotEndListener listener : this.snapshotEndListeners) {
            listener.onSnapshotEnd();
        }
        this.snapshotEndsSent.add(alias);
    }

    public void onTrade(String alias, double price, int size, TradeInfo tradeInfo, boolean fromGenerator) {
        if (this.eventShouldBePublished(fromGenerator) && (this.simplifiedL1ApiLoader.multiInstrument || this.alias.equals(alias))) {
            Bar currentBar;
            this.setCurrentAlias(alias);
            if (!this.snapshotEndsSent.contains(alias)) {
                this.invokeSnapshotEndListeners(alias);
            }
            if ((currentBar = this.currentBars.get(alias)) == null) {
                currentBar = new Bar();
                this.currentBars.put(alias, currentBar);
            }
            currentBar.addTrade(tradeInfo.isBidAggressor, size, price);
            this.invokeCurrentTimeListeners(fromGenerator, true);
            for (TradeDataListener listener : this.tradeDataListeners) {
                listener.onTrade(price, size, tradeInfo);
            }
        }
    }

    public void onOrderUpdated(OrderInfoUpdate orderInfoUpdate, boolean fromGenerator) {
        if (this.eventShouldBePublished(fromGenerator) && (this.simplifiedL1ApiLoader.multiInstrument || this.alias.equals(this.alias))) {
            this.setCurrentAlias(this.alias);
            this.invokeCurrentTimeListeners(fromGenerator, true);
            for (OrdersListener listener : this.ordersListeners) {
                listener.onOrderUpdated(orderInfoUpdate);
            }
        }
    }

    public void onOrderExecuted(ExecutionInfo executionInfo, boolean fromGenerator) {
        if (this.eventShouldBePublished(fromGenerator) && (this.simplifiedL1ApiLoader.multiInstrument || this.alias.equals(this.alias))) {
            this.setCurrentAlias(this.alias);
            this.invokeCurrentTimeListeners(fromGenerator, true);
            for (OrdersListener listener : this.ordersListeners) {
                listener.onOrderExecuted(executionInfo);
            }
        }
    }

    public void onStatus(StatusInfo statusInfo, boolean fromGenerator) {
        if (this.eventShouldBePublished(fromGenerator) && (this.simplifiedL1ApiLoader.multiInstrument || this.alias.equals(this.alias))) {
            this.setCurrentAlias(this.alias);
            this.invokeCurrentTimeListeners(fromGenerator, true);
            for (PositionListener listener : this.statusListeners) {
                listener.onPositionUpdate(statusInfo);
            }
        }
    }

    public void onBalance(BalanceInfo balanceInfo, boolean fromGenerator) {
        if (this.eventShouldBePublished(fromGenerator) && (this.simplifiedL1ApiLoader.multiInstrument || this.alias.equals(this.alias))) {
            this.setCurrentAlias(this.alias);
            this.invokeCurrentTimeListeners(fromGenerator, true);
            for (BalanceListener listener : this.balanceListeners) {
                listener.onBalance(this.simplifiedL1ApiLoader.balance);
            }
        }
    }

    private boolean eventShouldBePublished(boolean fromGenerator) {
        if (this.stopped) {
            return false;
        }
        switch (this.simplifiedL1ApiLoader.mode) {
            case GENERATORS: {
                return fromGenerator;
            }
            case LIVE: {
                return !fromGenerator;
            }
            case MIXED: {
                if (this.isRealtime) {
                    return !fromGenerator && this.simplifiedL1ApiLoader.getCurrentTime() >= this.firstRealtimeEventTime;
                }
                return fromGenerator;
            }
        }
        throw new UnsupportedOperationException("Unknown mode " + this.simplifiedL1ApiLoader.mode);
    }

    private void invokeCurrentTimeListeners(boolean fromGenerator, boolean setTime) {
        if (setTime && !fromGenerator) {
            this.setTime(this.simplifiedL1ApiLoader.getCurrentTime(), fromGenerator);
        }
        for (TimeListener listener : this.timeListeners) {
            listener.onTimestamp(this.time);
        }
    }

    private void setCurrentAlias(String currentAlias) {
        if (!currentAlias.equals(this.currentAlias)) {
            this.currentAlias = currentAlias;
            for (MultiInstrumentListener listener : this.multiInstrumentListeners) {
                listener.onCurrentInstrument(currentAlias);
            }
        }
    }

    public void onInstrumentAdded(String alias, InstrumentInfo instrumentInfo, boolean fromGenerator) {
        if (this.eventShouldBePublished(fromGenerator) && this.simplifiedL1ApiLoader.multiInstrument) {
            this.setCurrentAlias(alias);
            this.invokeCurrentTimeListeners(fromGenerator, true);
            for (MultiInstrumentListener listener : this.multiInstrumentListeners) {
                listener.onInstrumentAdded(instrumentInfo);
            }
        }
    }

    public void setTime(long newTime, boolean fromGenerator) {
        if (!this.eventShouldBePublished(fromGenerator)) {
            return;
        }
        if (this.time != 0L) {
            while (this.getNextKeyTime(this.interval) <= newTime) {
                this.time = this.simplifiedL1ApiLoader.mode == SimplifiedL1ApiLoader.Mode.GENERATORS ? newTime : this.getNextKeyTime(this.interval);
                this.invokeCurrentTimeListeners(fromGenerator, false);
                for (IntervalListener listener : this.intervalListeners) {
                    listener.onInterval();
                }
                Map<String, OrderBook> orderBooksMap = this.simplifiedL1ApiLoader.multiInstrument ? this.submittedOrderBooks : Collections.singletonMap(this.alias, this.submittedOrderBooks.get(this.alias));
                for (Map.Entry<String, OrderBook> entry : orderBooksMap.entrySet()) {
                    String alias = entry.getKey();
                    OrderBook orderBook = entry.getValue();
                    Bar bar = this.currentBars.get(alias);
                    if (bar != null) {
                        Bar nextBar = new Bar(bar);
                        nextBar.startNext();
                        this.currentBars.put(alias, nextBar);
                    } else {
                        bar = new Bar();
                    }
                    for (BarDataListener listener : this.barDataListeners) {
                        listener.onBar(orderBook, bar);
                    }
                }
            }
        }
        this.time = newTime;
    }

    private long getNextKeyTime(long interval) {
        if (interval <= 0L) {
            return Long.MAX_VALUE;
        }
        long remainder = this.time % interval;
        if (remainder == 0L) {
            return this.time + interval;
        }
        return this.time + interval - remainder;
    }

    public long getTime() {
        return this.time;
    }

    public void onRealtimeStart(long firstRealtimeEventTime) {
        this.firstRealtimeEventTime = firstRealtimeEventTime;
        this.isRealtime = true;
        for (HistoricalModeListener listener : this.historicalModeListeners) {
            listener.onRealtimeStart();
        }
    }

    @Override
    public void sendOrder(OrderSendParameters orderSendParameters) {
        this.simplifiedL1ApiLoader.sendOrder(orderSendParameters);
    }

    @Override
    public void updateOrder(OrderUpdateParameters orderUpdateParameters) {
        this.simplifiedL1ApiLoader.updateOrder(orderUpdateParameters);
    }

    public <ST> ST getSettings(Class<? extends ST> settingsClass) {
        return (ST)this.simplifiedL1ApiLoader.settingsAccess.getSettings(this.alias, this.simplifiedL1ApiLoader.simpleStrategyClass.getCanonicalName() + DIRECT_SETTINGS_POSTFIX, settingsClass);
    }

    public <ST> void setSettings(ST settingsObject) {
        this.simplifiedL1ApiLoader.settingsAccess.setSettings(this.alias, this.simplifiedL1ApiLoader.simpleStrategyClass.getCanonicalName() + DIRECT_SETTINGS_POSTFIX, settingsObject, settingsObject.getClass());
    }

    @Override
    public void unload() {
        if (!this.stopped) {
            SwingUtilities.invokeLater(() -> {
                this.simplifiedL1ApiLoader.onStrategyCheckboxEnabled(this.alias, false);
                Runnable strategyEnabledRecheckCallback = this.simplifiedL1ApiLoader.strategyEnabledRecheckCallbacks.get(this.alias);
                if (strategyEnabledRecheckCallback != null) {
                    strategyEnabledRecheckCallback.run();
                }
            });
        }
    }

    @Override
    public void reload() {
        if (!this.stopped) {
            this.stopped = true;
            this.simplifiedL1ApiLoader.loaderInject(() -> {
                this.simplifiedL1ApiLoader.stopForInstrument(this.alias, false);
                this.simplifiedL1ApiLoader.startForInstrument(this.alias);
            });
        }
    }

    public StrategyPanel[] getCustomSettingsPanels() {
        StrategyPanel[] panels = ((CustomSettingsPanelProvider)((Object)this.instance)).getCustomSettingsPanels();
        return panels;
    }

    public boolean areCustomSettingsPanelsReady() {
        return this.customSettingsPanelsReady;
    }

    public Map<String, Layer1PriceAxisRangeCalculatable.ResultPriceAxisInfo> getPriceRanges(double linesCount, Map<String, Layer1PriceAxisRangeCalculatable.InputPriceAxisInfo> inputInfo) {
        HashMap<String, Layer1PriceAxisRangeCalculatable.ResultPriceAxisInfo> result = new HashMap<String, Layer1PriceAxisRangeCalculatable.ResultPriceAxisInfo>();
        for (Map.Entry<String, Layer1PriceAxisRangeCalculatable.InputPriceAxisInfo> entry : inputInfo.entrySet()) {
            AxisRules axisRules;
            String fullName = entry.getKey();
            IndicatorImplementation indicator = this.indicators.get(fullName);
            if (indicator == null) {
                Log.warn((String)"Missing indicator during getPriceRanges, ok if it's reloading");
                return PriceRangeCalculationHelper.getGoodNumbersCalculation((double)linesCount, inputInfo);
            }
            AxisGroup axisGroup = indicator.getAxisGroup();
            List<Indicator> rangeInputIndicators = axisGroup == null ? Collections.singletonList(indicator) : axisGroup.getIndicators();
            double minMinValue = Double.POSITIVE_INFINITY;
            double maxMaxValue = Double.NEGATIVE_INFINITY;
            for (IndicatorImplementation indicatorImplementation : rangeInputIndicators) {
                Layer1PriceAxisRangeCalculatable.InputPriceAxisInfo inputPriceAxisInfo = inputInfo.get(indicatorImplementation.getFullName());
                if (inputPriceAxisInfo == null) continue;
                minMinValue = Math.min(minMinValue, inputPriceAxisInfo.minValue);
                maxMaxValue = Math.max(maxMaxValue, inputPriceAxisInfo.maxValue);
            }
            AxisRules axisRules2 = axisRules = axisGroup == null ? indicator.getAxisRules() : axisGroup.getAxisRules();
            if (axisRules == null) {
                axisRules = new AxisRules();
            }
            Pair<Double, Double> pair = axisRules.apply(minMinValue, maxMaxValue);
            result.put(fullName, PriceRangeCalculationHelper.getGoodNumbersCalculation((double)((Double)pair.getLeft()), (double)((Double)pair.getRight()), (double)linesCount));
        }
        return result;
    }

    @Override
    public void addTimeListeners(TimeListener timeListener) {
        this.checkIfManualSubscriptionAllowed();
        this.timeListeners.add(timeListener);
    }

    @Override
    public void addDepthDataListeners(DepthDataListener depthDataListener) {
        this.checkIfManualSubscriptionAllowed();
        this.depthDataListeners.add(depthDataListener);
    }

    @Override
    public void addMarketByOrderDepthDataListeners(MarketByOrderDepthDataListener marketByOrderDepthDataListener) {
        this.checkIfManualSubscriptionAllowed();
        this.marketByOrderDepthDataListeners.add(marketByOrderDepthDataListener);
    }

    @Override
    public void addSnapshotEndListeners(SnapshotEndListener snapshotEndListener) {
        this.checkIfManualSubscriptionAllowed();
        this.snapshotEndListeners.add(snapshotEndListener);
    }

    @Override
    public void addTradeDataListeners(TradeDataListener tradeDataListener) {
        this.checkIfManualSubscriptionAllowed();
        this.tradeDataListeners.add(tradeDataListener);
    }

    @Override
    public void addIntervalListeners(IntervalListener intervalListener) {
        this.checkIfManualSubscriptionAllowed();
        this.interval = ((IntervalListener)((Object)this.instance)).getInterval();
        if (this.interval < Intervals.MIN_INTERVAL) {
            throw new IllegalArgumentException("IntervalListener#getInterval < Intervals#MIN_INTERVAL (" + this.interval + ")");
        }
        this.intervalListeners.add(intervalListener);
    }

    @Override
    public void addBarDataListeners(BarDataListener barDataListener) {
        this.checkIfManualSubscriptionAllowed();
        this.barDataListeners.add(barDataListener);
    }

    @Override
    public void addBboDataListeners(BboListener bboListener) {
        this.checkIfManualSubscriptionAllowed();
        this.bboDataListeners.add(bboListener);
    }

    @Override
    public void addOrdersListeners(OrdersListener ordersListener) {
        this.checkIfManualSubscriptionAllowed();
        this.ordersListeners.add(ordersListener);
    }

    @Override
    public void addStatusListeners(PositionListener positionListener) {
        this.checkIfManualSubscriptionAllowed();
        this.statusListeners.add(positionListener);
    }

    @Override
    public void addBalanceListeners(BalanceListener balanceListener) {
        this.checkIfManualSubscriptionAllowed();
        this.balanceListeners.add(balanceListener);
    }

    @Override
    public void addHistoricalModeListeners(HistoricalModeListener historicalModeListener) {
        this.checkIfManualSubscriptionAllowed();
        if (!HistoricalModeListener.class.isAssignableFrom(this.simplifiedL1ApiLoader.simpleStrategyClass)) {
            throw new IllegalStateException("This method can only be used if main class implements " + HistoricalModeListener.class.getSimpleName() + " directly or indirectly (it is used as a flag to activate certain logic)");
        }
        this.historicalModeListeners.add(historicalModeListener);
    }

    @Override
    public void addMultiInstrumentListeners(MultiInstrumentListener multiInstrumentListener) {
        this.checkIfManualSubscriptionAllowed();
        this.multiInstrumentListeners.add(multiInstrumentListener);
    }

    private void checkIfManualSubscriptionAllowed() {
        if (!this.simplifiedL1ApiLoader.simpleStrategyClass.isAnnotationPresent(NoAutosubscription.class)) {
            throw new IllegalStateException("This method can only be used if annotation @" + NoAutosubscription.class.getSimpleName() + " is present");
        }
    }

    @Override
    public void sendUserMessage(Object data) {
        this.simplifiedL1ApiLoader.sendUserMessage(data);
    }

    @Override
    public Layer1ApiProvider getProvider() {
        return this.simplifiedL1ApiLoader;
    }
}

