/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import velox.api.layer1.common.Log;
import velox.api.layer1.common.NanoClock;
import velox.api.layer1.layers.strategies.interfaces.CalculatedResultListener;
import velox.api.layer1.layers.strategies.interfaces.InvalidateInterface;
import velox.api.layer1.layers.strategies.interfaces.OnlineCalculatable;
import velox.api.layer1.layers.strategies.interfaces.OnlineValueCalculatorAdapter;
import velox.api.layer1.messages.CurrentTimeUserMessage;
import velox.api.layer1.messages.indicators.Layer1ApiUserMessageModifyIndicator;
import velox.api.layer1.simplified.IconStorage;
import velox.api.layer1.simplified.IndicatorImplementation;
import velox.api.layer1.simplified.IndicatorModifiable;
import velox.api.layer1.simplified.InstanceWrapper;
import velox.api.layer1.simplified.Point;
import velox.api.layer1.simplified.SimplifiedL1ApiLoader;
import velox.api.layer1.simplified.WidgetRules;
import velox.api.layer1.simplified.WidgetRulesCalculator;

class IndicatorArrayImplementation
extends IndicatorImplementation
implements IndicatorModifiable {
    protected static final int MAX_INMEMORY_POINTS = 400000;
    protected static final int INITIAL_POINTS_ARRAY_SIZE = 100;
    private SimplifiedL1ApiLoader<?> simplifiedL1ApiLoader;
    private InvalidateInterface invalidateInterface;
    private AtomicBoolean isTimerLaunched;
    private final int timerDelayMillis = 200;
    private BiFunction<Double, Double, Double> aggregationFunction;
    private final Object pointsLock = new Object();
    private int pointsCount;
    private long[] timestamps = new long[100];
    private double[] pointValues = new double[100];
    protected TreeMap<Long, List<Integer>> icons = new TreeMap();

    public IndicatorArrayImplementation(SimplifiedL1ApiLoader<?> simplifiedL1ApiLoader, String alias, String name, Layer1ApiUserMessageModifyIndicator.GraphType graphType, double initialValue, boolean isWidgetEnabledByDefault, boolean isLineEnabledByDefault, BiFunction<Double, Double, Double> aggregationFunction, InstanceWrapper wrapper) {
        super(simplifiedL1ApiLoader, alias, name, graphType, initialValue, isWidgetEnabledByDefault, isLineEnabledByDefault, wrapper);
        this.simplifiedL1ApiLoader = simplifiedL1ApiLoader;
        this.aggregationFunction = aggregationFunction;
        this.isTimerLaunched = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateValuesInRange(String indicatorName, String indicatorAlias, long t0, long intervalWidth, int intervalsNumber, CalculatedResultListener listener) {
        if (WidgetRulesCalculator.isCalculationOrReportingAllowed(this.consumer, this.widgetRules, this.widgetGroup)) {
            long actualTime = t0 + (long)intervalsNumber * intervalWidth;
            this.calculateAndReportWidgetRange(actualTime);
        }
        int pointIndex = this.findPreviousAggregationDotIndex(t0);
        Object object = this.pointsLock;
        synchronized (object) {
            for (int i = 0; i < intervalsNumber; ++i) {
                double value = pointIndex == -1 ? this.initialValue : this.pointValues[this.isTail(pointIndex) ? pointIndex : pointIndex + 1];
                long rightPixelEdgeTimestamp = t0 + intervalWidth * (long)i;
                boolean isFirstInInterval = true;
                while (pointIndex + 1 < this.pointsCount && this.timestamps[pointIndex + 1] < rightPixelEdgeTimestamp) {
                    ++pointIndex;
                    if (isFirstInInterval) {
                        isFirstInInterval = false;
                        value = this.pointValues[pointIndex];
                        continue;
                    }
                    value = this.aggregationFunction.apply(value, this.pointValues[pointIndex]);
                }
                List<Object> iconsInPixel = new ArrayList();
                IconStorage iconStorage = this.iconStorage;
                synchronized (iconStorage) {
                    if (!this.iconStorage.isClosed()) {
                        iconsInPixel = this.icons.subMap(rightPixelEdgeTimestamp - intervalWidth, false, rightPixelEdgeTimestamp, true).values().stream().flatMap(list -> list.stream().map(this.iconStorage::load)).collect(Collectors.toList());
                    }
                }
                if (iconsInPixel.size() > 0) {
                    List markers = iconsInPixel.stream().map(image -> image.marker).collect(Collectors.toList());
                    listener.provideResponse((Object)new OnlineCalculatable.ValueBundle((Object)value, markers));
                    continue;
                }
                listener.provideResponse((Object)value);
            }
        }
        listener.setCompleted();
    }

    private boolean isAggregation(int index) {
        if (index == 0) {
            return true;
        }
        return this.timestamps[index] != this.timestamps[index - 1];
    }

    private boolean isTail(int index) {
        if (index == this.timestamps.length - 1) {
            return true;
        }
        return this.timestamps[index] != this.timestamps[index + 1];
    }

    private int findPreviousAggregationDotIndex(long timestamp) {
        int pointIndex = this.findPreviousDotIndex(timestamp);
        if (pointIndex < 0) {
            return pointIndex;
        }
        if (this.isAggregation(pointIndex)) {
            return pointIndex;
        }
        return pointIndex - 1;
    }

    private int findPreviousDotIndex(long timestamp) {
        int pointIndex = Arrays.binarySearch(this.timestamps, 0, this.pointsCount, timestamp);
        if (pointIndex < 0) {
            pointIndex = -pointIndex - 1;
            --pointIndex;
        }
        return pointIndex;
    }

    public OnlineValueCalculatorAdapter createOnlineValueCalculator(String indicatorName, String indicatorAlias, long time, Consumer<Object> listener, InvalidateInterface invalidateInterface) {
        this.invalidateInterface = invalidateInterface;
        return new OnlineCalculator(listener, time);
    }

    protected long getPointTime() {
        long time = this.simplifiedL1ApiLoader.mode == SimplifiedL1ApiLoader.Mode.GENERATORS ? this.wrapper.getTime() : (this.simplifiedL1ApiLoader.mode == SimplifiedL1ApiLoader.Mode.MIXED && !this.wrapper.isRealtime ? this.wrapper.getTime() : this.simplifiedL1ApiLoader.getCurrentTime());
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(long fromTimestamp, long toTimestamp) {
        Object object = this.pointsLock;
        synchronized (object) {
            if (fromTimestamp != Long.MIN_VALUE || toTimestamp != Long.MAX_VALUE) {
                throw new IllegalArgumentException("This indicator only supports full erasure. Use Long#MIN_VALUE and Long#MAX_VALUE as parameters to achieve that.");
            }
            this.pointsCount = 0;
            this.timestamps = new long[100];
            this.pointValues = new double[100];
            this.invalidateInterfaceWithDelay(200);
        }
        object = this.iconStorage;
        synchronized (object) {
            if (!this.iconStorage.isClosed()) {
                SortedMap<Long, List<Integer>> removedSubmap = this.icons.subMap(fromTimestamp, toTimestamp);
                removedSubmap.values().stream().flatMap(Collection::stream).forEach(this.iconStorage::remove);
                removedSubmap.clear();
            }
        }
    }

    @Override
    public void addPoint(long timestamp, double value) {
        this.addPoint(timestamp, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(long timestamp, double value, boolean timestampIsCurrent) {
        Object object = this.pointsLock;
        synchronized (object) {
            long aggregationTimestamp;
            int tailIndex = this.pointsCount - 1;
            int aggregationIndex = this.pointsCount - 2;
            long tailTimestamp = this.pointsCount > 0 ? this.timestamps[tailIndex] : Long.MIN_VALUE;
            long l = aggregationTimestamp = this.pointsCount > 1 ? this.timestamps[aggregationIndex] : Long.MIN_VALUE;
            if (tailTimestamp == aggregationTimestamp && tailTimestamp == timestamp) {
                double aggregationValue = this.pointValues[aggregationIndex];
                double previousTail = this.pointValues[tailIndex];
                this.pointValues[aggregationIndex] = aggregationValue = this.aggregationFunction.apply(aggregationValue, previousTail).doubleValue();
                --this.pointsCount;
            } else if (tailTimestamp != timestamp && tailTimestamp > timestamp) {
                throw new IllegalArgumentException("This indicator does not support inserting values in the middle");
            }
            this.timestamps[this.pointsCount] = timestamp;
            this.pointValues[this.pointsCount] = value;
            ++this.pointsCount;
            if (this.pointsCount == 400000) {
                this.thinOutPoints();
            } else if (this.pointsCount == this.pointValues.length) {
                int newLength = this.pointValues.length * 2;
                newLength = Math.max(400000, newLength);
                this.timestamps = Arrays.copyOf(this.timestamps, newLength);
                this.pointValues = Arrays.copyOf(this.pointValues, newLength);
            }
            if (!timestampIsCurrent && this.invalidateInterface != null && timestamp != this.getPointTime()) {
                this.invalidateInterfaceWithDelay(200);
            }
        }
        if (!Double.isNaN(value) && this.widgetRules != null && this.widgetRules.getLifeSpan() != Long.MAX_VALUE) {
            if (this.nextTime == 0L) {
                this.nextTime = timestamp + this.widgetRules.getLifeSpan() / 100L;
            }
            ImmutableTriple<Double, Double, Long> returnedValues = WidgetRulesCalculator.processPoint(value, timestamp, this.nextTime, this.lower, this.upper, this.widgetRules, this.sampledWidgetRanges, this.spannedWidgetRanges);
            this.lower = (Double)returnedValues.left;
            this.upper = (Double)returnedValues.middle;
            this.nextTime = (Long)returnedValues.right;
        } else if (this.widgetGroup != null) {
            this.latestReportedLower = WidgetRulesCalculator.initializeOrUpdateLower(this.latestReportedLower, value);
            this.latestReportedUpper = WidgetRulesCalculator.initializeOrUpdateUpper(this.latestReportedUpper, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPoint(double value) {
        Object object = this.pointsLock;
        synchronized (object) {
            long time = this.getPointTime();
            if (time == 0L) {
                throw new IllegalStateException("time == 0 " + this.simplifiedL1ApiLoader.mode + " " + this.wrapper.isRealtime + " " + this.wrapper.getTime() + " " + this.simplifiedL1ApiLoader.getCurrentTime());
            }
            this.addPoint(time, value, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIcon(double value, BufferedImage icon, int iconCenterX, int iconCenterY) {
        IconStorage iconStorage = this.iconStorage;
        synchronized (iconStorage) {
            if (!this.iconStorage.isClosed()) {
                long time = this.getPointTime();
                if (time == 0L) {
                    throw new IllegalStateException("time == 0 " + this.simplifiedL1ApiLoader.mode + " " + this.wrapper.isRealtime + " " + this.wrapper.getTime() + " " + this.simplifiedL1ApiLoader.getCurrentTime());
                }
                IconStorage.IconInfo imageInfo = this.makeIcon(value, icon, iconCenterX, iconCenterY);
                this.icons.computeIfAbsent(time, v -> new ArrayList(1)).add(imageInfo.imageId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void thinOutPoints() {
        Object object = this.pointsLock;
        synchronized (object) {
            Log.info((String)(this.simplifiedL1ApiLoader.simpleStrategyClass.getName() + " indicator generated too many points (" + this.pointsCount + "), removing the oldest ones"));
            long dropStartTime = NanoClock.currentTimeNanos();
            if (this.pointsCount % 4 != 0) {
                throw new IllegalStateException("Can't thin out points when count is not multiple of 4: " + this.pointsCount);
            }
            int pointsDropped = this.pointsCount / 4;
            int thinOutInputEnd = pointsDropped * 2;
            int thinOutOutputEnd = pointsDropped;
            for (int i = 0; i < pointsDropped; ++i) {
                int from1 = i * 2;
                int from2 = from1 + 1;
                this.timestamps[i] = this.timestamps[from1];
                this.pointValues[i] = this.aggregationFunction.apply(this.pointValues[from1], this.pointValues[from2]);
            }
            int pointsToMove = this.pointsCount / 2;
            for (int i = 0; i < pointsToMove; ++i) {
                this.timestamps[thinOutOutputEnd + i] = this.timestamps[thinOutInputEnd + i];
                this.pointValues[thinOutOutputEnd + i] = this.pointValues[thinOutInputEnd + i];
            }
            this.pointsCount -= pointsDropped;
            Log.debug((String)("Dots dropped in " + (double)(NanoClock.currentTimeNanos() - dropStartTime) / 1000000.0 + "ms, new points count " + this.pointsCount));
        }
    }

    private void invalidateInterfaceWithDelay(final int millis) {
        if (!this.isTimerLaunched.get()) {
            this.isTimerLaunched.set(true);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException e) {
                        Log.warn((String)"", (Exception)e);
                    }
                    if (IndicatorArrayImplementation.this.invalidateInterface != null) {
                        IndicatorArrayImplementation.this.invalidateInterface.invalidate();
                    }
                    IndicatorArrayImplementation.this.isTimerLaunched.set(false);
                }
            });
            thread.setName("-> SimplifiedWrapper: invalidate interface for " + this.name);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onWidgetLifeSpanChanges(long lifeSpan) {
        List spannedWidgetRanges;
        List<Object> results;
        ArrayList<Pair<Long, Point>> pointz;
        Object object = this.pointsLock;
        synchronized (object) {
            pointz = new ArrayList<Pair<Long, Point>>(this.pointsCount);
            int sectionNumber = 0;
            for (int i = 0; i < this.pointsCount; ++i) {
                double value = this.pointValues[i];
                Point point = new Point(value, sectionNumber);
                if (Double.isNaN(value)) {
                    ++sectionNumber;
                }
                pointz.add((Pair<Long, Point>)new ImmutablePair((Object)this.timestamps[i], (Object)point));
            }
        }
        WidgetRules sectionNumber = this.widgetRules;
        synchronized (sectionNumber) {
            results = WidgetRulesCalculator.onBasicImplementationWidgetLifeSpanChanges(this.widgetRules, pointz);
        }
        List sampledWidgetRanges = (List)results.get(0);
        List list = spannedWidgetRanges = (List)results.get(1);
        synchronized (list) {
            List list2 = sampledWidgetRanges;
            synchronized (list2) {
                this.spannedWidgetRanges.addAll(0, spannedWidgetRanges);
                this.sampledWidgetRanges.addAll(0, sampledWidgetRanges);
            }
        }
    }

    protected class OnlineCalculator
    implements OnlineValueCalculatorAdapter {
        private Consumer<Object> listener;
        private long lastPublishedIconTime;
        private int lastPublishedIconIndexWithinBlock;
        private long leftTime;
        private long intervalWidth;
        private long prevPixelLeftEdgeTimestamp = 0L;
        private Double cachedAggregationValue = null;
        private int cachedAggregationIndex = 0;

        public OnlineCalculator(Consumer<Object> listener, long creationTime) {
            this.listener = listener;
            this.lastPublishedIconTime = creationTime;
            this.lastPublishedIconIndexWithinBlock = 0;
        }

        public void onLeftTimeChanged(long leftTime) {
            this.leftTime = leftTime;
            double accumulatedPixelValue = this.calculateNextValue();
            this.sendAccumulatedWithIcons(accumulatedPixelValue);
        }

        public void onIntervalWidth(long intervalWidth) {
            this.intervalWidth = intervalWidth;
        }

        public void onUserMessage(Object data) {
            if (data instanceof CurrentTimeUserMessage) {
                double accumulatedPixelValue = this.calculateNextValue();
                this.sendAccumulatedWithIcons(accumulatedPixelValue);
                if (WidgetRulesCalculator.isCalculationOrReportingAllowed(IndicatorArrayImplementation.this.consumer, IndicatorArrayImplementation.this.widgetRules, IndicatorArrayImplementation.this.widgetGroup)) {
                    long actualTime = IndicatorArrayImplementation.this.simplifiedL1ApiLoader.mode == SimplifiedL1ApiLoader.Mode.MIXED && !IndicatorArrayImplementation.this.wrapper.isRealtime ? IndicatorArrayImplementation.this.wrapper.getTime() : IndicatorArrayImplementation.this.simplifiedL1ApiLoader.getCurrentTime();
                    IndicatorArrayImplementation.this.calculateAndReportWidgetRange(actualTime);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected double calculateNextValue() {
            Object object = IndicatorArrayImplementation.this.pointsLock;
            synchronized (object) {
                boolean isFirstInInterval;
                Double value;
                int pointIndex;
                boolean isCached;
                long actualTime = this.getActualTime();
                long currentIntervalId = (actualTime - this.leftTime) / this.intervalWidth;
                long leftPixelEdgeTimestamp = this.leftTime + this.intervalWidth * currentIntervalId;
                if (this.prevPixelLeftEdgeTimestamp != leftPixelEdgeTimestamp) {
                    this.prevPixelLeftEdgeTimestamp = leftPixelEdgeTimestamp;
                    this.cachedAggregationValue = null;
                    this.cachedAggregationIndex = 0;
                }
                boolean bl = isCached = this.cachedAggregationValue != null;
                if (isCached) {
                    pointIndex = this.cachedAggregationIndex;
                    value = this.cachedAggregationValue;
                    isFirstInInterval = false;
                } else {
                    pointIndex = IndicatorArrayImplementation.this.findPreviousAggregationDotIndex(leftPixelEdgeTimestamp);
                    value = pointIndex == -1 ? IndicatorArrayImplementation.this.initialValue : IndicatorArrayImplementation.this.pointValues[IndicatorArrayImplementation.this.isTail(pointIndex) ? pointIndex : pointIndex + 1];
                    isFirstInInterval = true;
                }
                int cacheTillIndex = IndicatorArrayImplementation.this.findPreviousAggregationDotIndex(actualTime - 1L) - 2;
                while (pointIndex + 1 < IndicatorArrayImplementation.this.pointsCount && IndicatorArrayImplementation.this.timestamps[pointIndex + 1] < actualTime) {
                    ++pointIndex;
                    if (isFirstInInterval) {
                        isFirstInInterval = false;
                        value = IndicatorArrayImplementation.this.pointValues[pointIndex];
                    } else {
                        value = IndicatorArrayImplementation.this.aggregationFunction.apply(value, IndicatorArrayImplementation.this.pointValues[pointIndex]);
                    }
                    if (cacheTillIndex != pointIndex) continue;
                    this.cachedAggregationValue = value;
                    this.cachedAggregationIndex = cacheTillIndex;
                }
                return value;
            }
        }

        private long getActualTime() {
            return IndicatorArrayImplementation.this.simplifiedL1ApiLoader.mode == SimplifiedL1ApiLoader.Mode.MIXED && !IndicatorArrayImplementation.this.wrapper.isRealtime ? IndicatorArrayImplementation.this.wrapper.getTime() : IndicatorArrayImplementation.this.simplifiedL1ApiLoader.getCurrentTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendAccumulatedWithIcons(double accumulatedPixelValue) {
            long actualTime = this.getActualTime();
            List<Object> iconsToAdd = new ArrayList();
            IconStorage iconStorage = IndicatorArrayImplementation.this.iconStorage;
            synchronized (iconStorage) {
                if (!IndicatorArrayImplementation.this.iconStorage.isClosed()) {
                    iconsToAdd = this.lastPublishedIconTime <= actualTime ? IndicatorArrayImplementation.this.icons.subMap(this.lastPublishedIconTime, true, actualTime, true).entrySet().stream().flatMap(e -> {
                        List iconsInPixel = (List)e.getValue();
                        long iconsTime = (Long)e.getKey();
                        List iconsToPublish = iconsTime == this.lastPublishedIconTime ? iconsInPixel.subList(this.lastPublishedIconIndexWithinBlock + 1, iconsInPixel.size()) : iconsInPixel;
                        this.lastPublishedIconTime = iconsTime;
                        this.lastPublishedIconIndexWithinBlock = iconsInPixel.size() - 1;
                        return iconsToPublish.stream();
                    }).map(IndicatorArrayImplementation.this.iconStorage::load).collect(Collectors.toList()) : Collections.emptyList();
                }
            }
            if (iconsToAdd.size() > 0) {
                List markers = iconsToAdd.stream().map(image -> image.marker).collect(Collectors.toList());
                this.listener.accept(new OnlineCalculatable.ValueBundle((Object)accumulatedPixelValue, markers));
            } else {
                this.listener.accept(accumulatedPixelValue);
            }
        }
    }
}

