/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import velox.api.layer1.messages.indicators.WidgetDisplayInfo;

public class WidgetRules {
    private long lifeSpan = Long.MAX_VALUE;
    private WidgetDisplayInfo widgetDisplayInfo = null;
    private double forcedMin = Double.NaN;
    private double forcedMax = Double.NaN;
    private final double includedMin = Double.NaN;
    private final double includedMax = Double.NaN;
    private final boolean symmetrical = false;
    private final double margin = 0.0;

    public WidgetRules() {
    }

    public WidgetRules(double min, double max, long lifeSpan) {
        this.forcedMin = min;
        this.forcedMax = max;
        this.lifeSpan = lifeSpan;
    }

    public WidgetRules(long lifeSpan) {
        this.lifeSpan = lifeSpan;
    }

    public WidgetRules(double min, double max) {
        this.forcedMin = min;
        this.forcedMax = max;
    }

    public WidgetRules(double min, double max, long lifeSpan, WidgetDisplayInfo widgetDisplayInfo) {
        this.forcedMin = min;
        this.forcedMax = max;
        this.lifeSpan = lifeSpan;
        if (this.isDisplayInfoValid(min, max, widgetDisplayInfo)) {
            this.widgetDisplayInfo = widgetDisplayInfo;
        }
    }

    public WidgetRules(long lifeSpan, WidgetDisplayInfo widgetDisplayInfo) {
        this.lifeSpan = lifeSpan;
    }

    public WidgetRules(double min, double max, WidgetDisplayInfo widgetDisplayInfo) {
        this.forcedMin = min;
        this.forcedMax = max;
        if (this.isDisplayInfoValid(min, max, widgetDisplayInfo)) {
            this.widgetDisplayInfo = widgetDisplayInfo;
        }
    }

    public double getForcedMin() {
        return this.forcedMin;
    }

    public double getForcedMax() {
        return this.forcedMax;
    }

    public long getLifeSpan() {
        return this.lifeSpan;
    }

    public void setLifeSpan(long lifeSpan) {
        this.lifeSpan = lifeSpan;
    }

    public WidgetDisplayInfo getWidgetDisplayInfo() {
        return this.widgetDisplayInfo;
    }

    public boolean isSymmetrical() {
        return false;
    }

    public String toString() {
        return "[" + this.getForcedMin() + ", " + this.getForcedMax() + "]";
    }

    public Pair<Double, Double> apply(double min, double max) {
        double expansionValue;
        boolean maxLocked;
        boolean minLocked = !Double.isNaN(this.forcedMin);
        boolean bl = maxLocked = !Double.isNaN(this.forcedMax);
        if (minLocked) {
            min = this.forcedMin;
        }
        if (maxLocked) {
            max = this.forcedMax;
        }
        if (!minLocked && !Double.isNaN(Double.NaN)) {
            min = Math.min(min, Double.NaN);
        }
        if (!maxLocked && !Double.isNaN(Double.NaN)) {
            max = Math.max(max, Double.NaN);
        }
        if (!minLocked && !maxLocked && this.isSymmetrical()) {
            min = Math.min(min, -max);
            max = Math.max(max, -min);
        }
        if ((expansionValue = Double.NaN) > 0.0) {
            if (!minLocked && !maxLocked) {
                min -= expansionValue / 2.0;
                max += expansionValue / 2.0;
            }
            if (minLocked && !maxLocked) {
                max += expansionValue;
            }
            if (maxLocked && !minLocked) {
                min -= expansionValue;
            }
        }
        return new ImmutablePair((Object)min, (Object)max);
    }

    private boolean isDisplayInfoValid(double min, double max, WidgetDisplayInfo widgetDisplayInfo) {
        if (widgetDisplayInfo.type.equals((Object)WidgetDisplayInfo.Type.DEFAULT)) {
            return true;
        }
        if (Double.isNaN(widgetDisplayInfo.centerValue) || Double.isInfinite(widgetDisplayInfo.centerValue)) {
            throw new IllegalArgumentException("Invalid widget center value");
        }
        if (widgetDisplayInfo.centerValue > min && widgetDisplayInfo.centerValue < max) {
            return true;
        }
        throw new IllegalArgumentException("Symmetric widget center value does not fit the (min; max) interval");
    }
}

