/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import velox.api.layer1.layers.strategies.interfaces.CalculatedResultListener;
import velox.api.layer1.layers.strategies.interfaces.CustomGeneratedEvent;
import velox.api.layer1.layers.strategies.interfaces.CustomGeneratedEventAliased;
import velox.api.layer1.layers.strategies.interfaces.InvalidateInterface;
import velox.api.layer1.layers.strategies.interfaces.OnlineCalculatable;
import velox.api.layer1.layers.strategies.interfaces.OnlineValueCalculatorAdapter;
import velox.api.layer1.messages.indicators.DataStructureInterface;
import velox.api.layer1.messages.indicators.Layer1ApiUserMessageModifyIndicator;
import velox.api.layer1.simplified.CustomAggregationEvent;
import velox.api.layer1.simplified.CustomEvent;
import velox.api.layer1.simplified.IconStorage;
import velox.api.layer1.simplified.IndicatorImplementation;
import velox.api.layer1.simplified.InstanceWrapper;
import velox.api.layer1.simplified.Point;
import velox.api.layer1.simplified.SimplifiedL1ApiLoader;
import velox.api.layer1.simplified.WidgetRulesCalculator;

class IndicatorGeneratorImplementation
extends IndicatorImplementation {
    private SimplifiedL1ApiLoader simplifiedL1ApiLoader;
    private final int generatorIndicatorId;

    public IndicatorGeneratorImplementation(SimplifiedL1ApiLoader simplifiedL1ApiLoader, String alias, String name, Layer1ApiUserMessageModifyIndicator.GraphType graphType, double initialValue, boolean isWidgetEnabledByDefault, boolean isLineEnabledByDefault, InstanceWrapper wrapper, int generatorIndicatorId) {
        super(simplifiedL1ApiLoader, alias, name, graphType, initialValue, isWidgetEnabledByDefault, isLineEnabledByDefault, wrapper);
        this.simplifiedL1ApiLoader = simplifiedL1ApiLoader;
        this.generatorIndicatorId = generatorIndicatorId;
    }

    public void calculateValuesInRange(String indicatorName, String indicatorAlias, long t0, long intervalWidth, int intervalsNumber, CalculatedResultListener listener) {
        List result;
        Point currentPoint;
        if (intervalsNumber == 0 || this.simplifiedL1ApiLoader.dataStructureInterface == null) {
            listener.setCompleted();
            return;
        }
        if (WidgetRulesCalculator.isCalculationOrReportingAllowed(this.consumer, this.widgetRules, this.widgetGroup)) {
            long time = t0 + (long)intervalsNumber * intervalWidth;
            if (!this.spannedWidgetRanges.isEmpty() && (Long)((ImmutablePair)this.spannedWidgetRanges.get((int)0)).left < time) {
                this.calculateAndReportWidgetRange(time);
            }
        }
        if ((currentPoint = this.getValueFromEvent((DataStructureInterface.TreeResponseInterval)(result = this.simplifiedL1ApiLoader.dataStructureInterface.get(this.simplifiedL1ApiLoader.simpleStrategyClass, this.alias, t0, intervalWidth, intervalsNumber, this.alias, new Class[]{CustomEvent.class})).get(0))) == null) {
            currentPoint = new Point(this.initialValue, 1);
        }
        Point previousResponse = currentPoint;
        for (int i = 1; i <= intervalsNumber; ++i) {
            Point response = this.getValueFromEvent((DataStructureInterface.TreeResponseInterval)result.get(i));
            if (response != null) {
                currentPoint = response;
            }
            double value = previousResponse.getSectionNumber() != currentPoint.getSectionNumber() ? Double.NaN : currentPoint.getValue();
            previousResponse = currentPoint;
            List<Object> markersFromEvent = this.getMarkersFromEvent((DataStructureInterface.TreeResponseInterval)result.get(i));
            if (markersFromEvent.isEmpty()) {
                listener.provideResponse((Object)value);
                continue;
            }
            listener.provideResponse((Object)new OnlineCalculatable.ValueBundle((Object)value, markersFromEvent));
        }
        listener.setCompleted();
    }

    private Point getValueFromEvent(DataStructureInterface.TreeResponseInterval treeResponseInterval) {
        Object object = treeResponseInterval.events.get(CustomEvent.class.toString());
        if (object != null) {
            return ((CustomAggregationEvent)object).indicators.get(this.generatorIndicatorId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> getMarkersFromEvent(DataStructureInterface.TreeResponseInterval treeResponseInterval) {
        Object object = treeResponseInterval.events.get(CustomEvent.class.toString());
        if (object != null) {
            IconStorage iconStorage = this.iconStorage;
            synchronized (iconStorage) {
                List<Integer> iconIds;
                if (!this.iconStorage.isClosed() && (iconIds = ((CustomAggregationEvent)object).icons.get(this.generatorIndicatorId)) != null) {
                    return iconIds.stream().map(id -> this.iconStorage.load((int)id.intValue()).marker).collect(Collectors.toList());
                }
            }
        }
        return Collections.emptyList();
    }

    public OnlineValueCalculatorAdapter createOnlineValueCalculator(String indicatorName, final String indicatorAlias, long time, final Consumer<Object> listener, InvalidateInterface invalidateInterface) {
        final double lastValueFinal = Optional.ofNullable(this.simplifiedL1ApiLoader.dataStructureInterface).map(dataStructureInterface -> dataStructureInterface.get(this.simplifiedL1ApiLoader.simpleStrategyClass, this.alias, time, this.alias, new Class[]{CustomEvent.class})).map(this::getValueFromEvent).map(Point::getValue).orElse(this.initialValue);
        return new OnlineValueCalculatorAdapter(){
            double currentValue;
            {
                this.currentValue = lastValueFinal;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onUserMessage(Object data) {
                if (data instanceof CustomGeneratedEventAliased) {
                    CustomGeneratedEventAliased aliasedEvent = (CustomGeneratedEventAliased)data;
                    if (indicatorAlias.equals(aliasedEvent.alias) && aliasedEvent.event instanceof CustomEvent) {
                        CustomEvent event = (CustomEvent)aliasedEvent.event;
                        if (event.indicatorId == IndicatorGeneratorImplementation.this.generatorIndicatorId) {
                            if (event.indicatorPoint != null) {
                                if (WidgetRulesCalculator.isCalculationOrReportingAllowed(IndicatorGeneratorImplementation.this.consumer, IndicatorGeneratorImplementation.this.widgetRules, IndicatorGeneratorImplementation.this.widgetGroup)) {
                                    long actualTime = event.getTime();
                                    IndicatorGeneratorImplementation.this.calculateAndReportWidgetRange(actualTime);
                                }
                                this.currentValue = event.indicatorPoint.getValue();
                                listener.accept(this.currentValue);
                            }
                            if (event.iconId != null) {
                                IconStorage iconStorage = IndicatorGeneratorImplementation.this.iconStorage;
                                synchronized (iconStorage) {
                                    if (!IndicatorGeneratorImplementation.this.iconStorage.isClosed()) {
                                        IconStorage.IconInfo icon = IndicatorGeneratorImplementation.this.iconStorage.load(event.iconId);
                                        listener.accept(new OnlineCalculatable.ValueBundle((Object)this.currentValue, Collections.singletonList(icon.marker)));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        };
    }

    @Override
    public void addPoint(double value) {
        Point point;
        if (Double.isNaN(value)) {
            point = new Point(value);
            ++this.sectionNumber;
        } else {
            point = new Point(value, this.sectionNumber);
        }
        this.wrapper.generatorMessage.generator.getGeneratedEventsConsumer().accept(new CustomGeneratedEventAliased((CustomGeneratedEvent)new CustomEvent(this.wrapper.getTime(), this.generatorIndicatorId, point), this.alias));
        if (!Double.isNaN(value) && this.widgetRules != null && this.widgetRules.getLifeSpan() != Long.MAX_VALUE) {
            long time = this.wrapper.getTime();
            if (this.nextTime == 0L) {
                this.nextTime = time + this.widgetRules.getLifeSpan() / 100L;
            }
            ImmutableTriple<Double, Double, Long> returnedValues = WidgetRulesCalculator.processPoint(value, time, this.nextTime, this.lower, this.upper, this.widgetRules, this.sampledWidgetRanges, this.spannedWidgetRanges);
            this.lower = (Double)returnedValues.left;
            this.upper = (Double)returnedValues.middle;
            this.nextTime = (Long)returnedValues.right;
        } else if (this.widgetGroup != null) {
            this.latestReportedLower = WidgetRulesCalculator.initializeOrUpdateLower(this.latestReportedLower, value);
            this.latestReportedUpper = WidgetRulesCalculator.initializeOrUpdateUpper(this.latestReportedUpper, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIcon(double value, BufferedImage icon, int iconCenterX, int iconCenterY) {
        IconStorage.IconInfo imageInfo = null;
        IconStorage iconStorage = this.iconStorage;
        synchronized (iconStorage) {
            if (!this.iconStorage.isClosed()) {
                imageInfo = this.makeIcon(value, icon, iconCenterX, iconCenterY);
            }
        }
        if (imageInfo != null) {
            this.wrapper.generatorMessage.generator.getGeneratedEventsConsumer().accept(new CustomGeneratedEventAliased((CustomGeneratedEvent)new CustomEvent(this.wrapper.getTime(), this.generatorIndicatorId, imageInfo.imageId), this.alias));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWidgetLifeSpanChanges(long lifeSpan) {
        List list = this.spannedWidgetRanges;
        synchronized (list) {
            List list2 = this.sampledWidgetRanges;
            synchronized (list2) {
                this.spannedWidgetRanges = new LinkedList();
                this.sampledWidgetRanges = new LinkedList();
                if (this.simplifiedL1ApiLoader.dataStructureInterface != null) {
                    long widgetRangeT0 = this.wrapper.getTime();
                    long nextTime = 0L;
                    List result = this.simplifiedL1ApiLoader.dataStructureInterface.get(this.simplifiedL1ApiLoader.simpleStrategyClass, this.alias, widgetRangeT0 - this.widgetRules.getLifeSpan(), this.widgetRules.getLifeSpan() / 100L, 101, this.alias, new Class[]{CustomEvent.class});
                    DataStructureInterface.TreeResponseInterval initialInterval = (DataStructureInterface.TreeResponseInterval)result.get(0);
                    if (!initialInterval.events.isEmpty()) {
                        Point currentValue = this.getValueFromEvent((DataStructureInterface.TreeResponseInterval)result.get(0));
                        for (int i = 1; i <= 101; ++i) {
                            Point newValue = this.getValueFromEvent((DataStructureInterface.TreeResponseInterval)result.get(i));
                            if (newValue != null) {
                                currentValue = newValue;
                            }
                            if (Double.isNaN(currentValue.getValue())) continue;
                            long time = widgetRangeT0 + this.widgetRules.getLifeSpan() / 100L * (long)i;
                            if (nextTime == 0L) {
                                nextTime = widgetRangeT0 + this.widgetRules.getLifeSpan() / 100L;
                            }
                            ImmutableTriple<Double, Double, Long> returnedValues = WidgetRulesCalculator.processPoint(currentValue.getValue(), time, nextTime, this.lower, this.upper, this.widgetRules, this.sampledWidgetRanges, this.spannedWidgetRanges);
                            this.lower = (Double)returnedValues.left;
                            this.upper = (Double)returnedValues.middle;
                            nextTime = (Long)returnedValues.right;
                        }
                    }
                }
            }
        }
    }
}

