/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import velox.gui.StrategyPanel;

public class SimpleStrategyPanel
extends StrategyPanel {
    private static final long serialVersionUID = -1703664344713800834L;
    private static final int YGAP = 15;
    private int row = 0;

    public SimpleStrategyPanel(String title) {
        super(title);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
    }

    public void addItem(String label, Component c) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = this.row++;
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.fill = 2;
        if (this.row == 0) {
            constraints.insets.top = 15;
        }
        this.add(new JLabel(label), constraints);
        constraints.gridx = 1;
        this.add(c, constraints);
    }

    public void addItems(String label, Component ... components) {
        JLabel jlabel = new JLabel(label);
        Component[] labeledComponents = new Component[components.length + 1];
        labeledComponents[0] = jlabel;
        System.arraycopy(components, 0, labeledComponents, 1, components.length);
        this.addItems(labeledComponents);
    }

    public void addItems(Component ... components) {
        int x = 0;
        for (Component component : components) {
            GridBagConstraints constraints = this.getConstraints(x, 10);
            if (component.getClass() == JLabel.class) {
                JLabel jlabel = (JLabel)component;
                if (x == 0) {
                    jlabel.setHorizontalAlignment(2);
                } else {
                    jlabel.setHorizontalAlignment(0);
                }
            }
            if (this.row == 0) {
                constraints.insets.top = 15;
            }
            this.add(component, constraints);
            ++x;
        }
        ++this.row;
    }

    public void addItems(Component[] components, int[] gridWidths) {
        if (components.length != gridWidths.length) {
            throw new IllegalArgumentException("Components array length and gridWidth array length do not match");
        }
        int x = 0;
        for (int i = 0; i < components.length; ++i) {
            GridBagConstraints constraints = this.getConstraints(x, 10);
            constraints.gridwidth = gridWidths[i];
            if (components[i].getClass() == JLabel.class) {
                JLabel label = (JLabel)components[i];
                if (x == 0) {
                    label.setHorizontalAlignment(2);
                } else {
                    label.setHorizontalAlignment(0);
                }
            }
            if (this.row == 0) {
                constraints.insets.top = 15;
            }
            this.add(components[i], constraints);
            ++x;
        }
        ++this.row;
    }

    private GridBagConstraints getConstraints(int x, int anchor) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = this.row;
        constraints.gridwidth = 1;
        constraints.gridx = x;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = x;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.fill = 2;
        constraints.anchor = anchor;
        return constraints;
    }
}

