/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer0.credentialscomponents;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.apache.commons.lang3.ObjectUtils;
import velox.api.layer0.credentialscomponents.BaseCredentialsComponent;
import velox.api.layer0.credentialscomponents.CredentialsSerializationField;
import velox.api.layer1.annotations.Layer1ApiPublic;

@Layer1ApiPublic
public class CredentialsDropdown
extends BaseCredentialsComponent {
    protected JComboBox<String> comboBox;
    protected String[] values;

    public CredentialsDropdown(String name, boolean isKey, String label, String[] values) {
        super(name, isKey);
        this.values = values;
        this.initialize(label);
    }

    private void initialize(String label) {
        if (label != null) {
            this.components.add(new JLabel(label));
        }
        this.comboBox = new JComboBox<String>(this.values);
        this.comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CredentialsDropdown.this.onStatusChanged();
                }
            }
        });
        this.components.add(this.comboBox);
    }

    @Override
    public Map<String, CredentialsSerializationField> getValues() {
        HashMap<String, CredentialsSerializationField> fields = new HashMap<String, CredentialsSerializationField>();
        String value = this.getValue();
        fields.put(this.name, new CredentialsSerializationField(this.isKey, false, value));
        return fields;
    }

    @Override
    public void setValues(Map<String, CredentialsSerializationField> serializedFields) {
        String newValue;
        CredentialsSerializationField field = serializedFields.get(this.name);
        if (field != null && this.containsValue(newValue = field.getStringValue())) {
            this.comboBox.setSelectedItem(newValue);
        }
    }

    protected boolean containsValue(String value) {
        return Arrays.stream(this.values).anyMatch(p -> p.equals(value));
    }

    public String getValue() {
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{(String)this.comboBox.getSelectedItem(), ""});
    }
}

