/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.common.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import velox.api.layer1.annotations.PublishWithoutJavadoc;
import velox.api.layer1.messages.NbboEvent;
import velox.api.layer1.providers.dxfeed.DxProviderApi;
import velox.api.layer1.reading.UserDataUserMessage;

@PublishWithoutJavadoc
public class NbboHelper {
    public static Object createNbboEvent(byte[] data) {
        NbboEvent event = NbboHelper.deserialize("NBBO_EVENT", data);
        return new UserDataUserMessage("NBBO_EVENT", event.alias, data);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @DxProviderApi
    public static byte[] serialize(NbboEvent nbboEvent) {
        try (ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dataOutputStream = new DataOutputStream(byteOutputStream);){
                byte[] userData;
                dataOutputStream.writeShort(nbboEvent.alias.length());
                dataOutputStream.writeChars(nbboEvent.alias);
                dataOutputStream.writeBoolean(nbboEvent.isBid);
                dataOutputStream.writeDouble(nbboEvent.price);
                dataOutputStream.writeShort(nbboEvent.exchange.length());
                dataOutputStream.writeChars(nbboEvent.exchange);
                byArray = userData = byteOutputStream.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize", e);
        }
    }

    @DxProviderApi
    public static NbboEvent deserialize(String tag, byte[] data) {
        NbboEvent nbboEvent;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(data));
        try {
            String alias = NbboHelper.readStringFromStream(dataInputStream);
            boolean isBid = dataInputStream.readBoolean();
            double price = dataInputStream.readDouble();
            if (tag.equals("DXFEED_BBO_EVENT.2")) {
                dataInputStream.readLong();
            }
            String exchange = NbboHelper.readStringFromStream(dataInputStream);
            nbboEvent = new NbboEvent(alias, isBid, price, exchange);
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to deserialize " + tag, e);
            }
        }
        dataInputStream.close();
        return nbboEvent;
    }

    private static String readStringFromStream(DataInputStream stream) throws IOException {
        int length = stream.readShort();
        if (length == -1) {
            return null;
        }
        if (length < 0) {
            throw new RuntimeException("Negative string length " + (short)length);
        }
        byte[] bytes = new byte[length * 2];
        stream.readFully(bytes);
        char[] characters = new char[length];
        for (int i = 0; i < length; ++i) {
            characters[i] = (char)(((0xFF & bytes[i * 2]) << 8) + ((0xFF & bytes[i * 2 + 1]) << 0));
        }
        return new String(characters);
    }
}

