/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.data.OrderEntryType;

@Layer1ApiPublic
public class OrderUpdateParameters {
    public final String orderId;
    public final OrderEntryType orderEntryType;

    public OrderUpdateParameters(String orderId) {
        this(orderId, OrderEntryType.AUTO);
    }

    public OrderUpdateParameters(String orderId, OrderEntryType orderEntryType) {
        this.orderId = orderId;
        this.orderEntryType = orderEntryType;
    }

    protected OrderUpdateParameters(Builder<?> builder) {
        this.orderId = builder.orderId;
        this.orderEntryType = builder.orderEntryType;
    }

    public Builder<?> toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.getClass() + "{orderId=" + this.orderId + ", orderEntryType=" + this.orderEntryType + "}";
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Layer1ApiPublic
    public static class Builder<T extends Builder<T>> {
        private String orderId;
        private OrderEntryType orderEntryType = OrderEntryType.AUTO;

        public Builder(String orderId) {
            this.orderId = orderId;
        }

        protected Builder(OrderUpdateParameters parameters) {
            this.orderId = parameters.orderId;
            this.orderEntryType = parameters.orderEntryType;
        }

        protected T self() {
            return (T)this;
        }

        public T setOrderId(String orderId) {
            this.orderId = orderId;
            return this.self();
        }

        public String getOrderId() {
            return this.orderId;
        }

        public T setOrderEntryType(OrderEntryType orderEntryType) {
            this.orderEntryType = orderEntryType;
            return this.self();
        }

        public OrderEntryType getOrderEntryType() {
            return this.orderEntryType;
        }

        public OrderUpdateParameters build() {
            return new OrderUpdateParameters(this);
        }
    }
}

