/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.helper.OrderRepresentationHelper;
import velox.api.layer1.data.AbstractSimpleOrderSendParametersBuilder;
import velox.api.layer1.data.BracketTier;
import velox.api.layer1.data.OrderDuration;
import velox.api.layer1.data.OrderEntryType;
import velox.api.layer1.data.SimpleOrderSendParametersBuilder;
import velox.api.layer1.data.SingleOrderSendParameters;
import velox.api.layer1.utils.IdHelper;

@Layer1ApiPublic
public class SimpleOrderSendParameters
extends SingleOrderSendParameters {
    public final double limitPrice;
    public final double stopPrice;
    public final int takeProfitOffset;
    public final List<BracketTier> additionalTakeProfitTiers;
    public final int stopLossOffset;
    public final int stopLossTrailingStep;
    public final List<BracketTier> additionalStopLossTiers;
    public final String takeProfitClientId;
    public final String stopLossClientId;
    public final int trailingStep;
    public final boolean doNotIncrease;
    public final boolean reversingPositionHint;
    public final boolean closingPositionHint;
    public final Integer stopLossLimitOffset;
    @Deprecated
    public double sizeMultiplier = Double.NaN;

    @Deprecated
    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, double limitPrice, double stopPrice) {
        this(alias, isBuy, size, duration, limitPrice, stopPrice, 0, 0, 0, -1, false);
    }

    @Deprecated
    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, int trailingStep, double limitPrice, double stopPrice) {
        this(alias, isBuy, size, duration, limitPrice, stopPrice, 0, 0, 0, trailingStep, false);
    }

    @Deprecated
    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, double limitPrice, double stopPrice, int takeProfitOffset, int stopLossOffset, int stopLossTrailingStep, int trailingStep, boolean doNotIncrease) {
        this(alias, isBuy, size, duration, limitPrice, stopPrice, takeProfitOffset, stopLossOffset, stopLossTrailingStep, trailingStep, doNotIncrease, null);
    }

    @Deprecated
    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, double limitPrice, double stopPrice, int takeProfitOffset, int stopLossOffset, int stopLossTrailingStep, int trailingStep, boolean doNotIncrease, Integer stopLossLimitOffset) {
        super(alias, isBuy, size, duration);
        this.limitPrice = limitPrice;
        this.stopPrice = stopPrice;
        this.takeProfitOffset = takeProfitOffset;
        this.additionalTakeProfitTiers = Collections.emptyList();
        this.stopLossOffset = stopLossOffset;
        this.stopLossTrailingStep = stopLossTrailingStep;
        this.additionalStopLossTiers = Collections.emptyList();
        this.takeProfitClientId = IdHelper.generateShortUuid();
        this.stopLossClientId = IdHelper.generateShortUuid();
        this.trailingStep = trailingStep;
        this.doNotIncrease = doNotIncrease;
        this.reversingPositionHint = false;
        this.closingPositionHint = false;
        this.stopLossLimitOffset = stopLossLimitOffset;
    }

    SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, String clientId, double limitPrice, double stopPrice, int takeProfitOffset, List<BracketTier> additionalTakeProfitTiers, int stopLossOffset, int stopLossTrailingStep, List<BracketTier> additionalStopLossTiers, String takeProfitClientId, String stopLossClientId, int trailingStep, boolean doNotIncrease, boolean reversingPositionHint, boolean closingPositionHint, String accountId, OrderEntryType orderEntryType) {
        this(alias, isBuy, size, duration, clientId, limitPrice, stopPrice, takeProfitOffset, additionalTakeProfitTiers, stopLossOffset, stopLossTrailingStep, additionalStopLossTiers, takeProfitClientId, stopLossClientId, trailingStep, doNotIncrease, reversingPositionHint, closingPositionHint, accountId, orderEntryType, null);
    }

    SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, String clientId, double limitPrice, double stopPrice, int takeProfitOffset, List<BracketTier> additionalTakeProfitTiers, int stopLossOffset, int stopLossTrailingStep, List<BracketTier> additionalStopLossTiers, String takeProfitClientId, String stopLossClientId, int trailingStep, boolean doNotIncrease, boolean reversingPositionHint, boolean closingPositionHint, String accountId, OrderEntryType orderEntryType, Integer stopLossLimitOffset) {
        super(alias, isBuy, size, duration, clientId, accountId, orderEntryType);
        this.limitPrice = limitPrice;
        this.stopPrice = stopPrice;
        this.takeProfitOffset = takeProfitOffset;
        this.additionalTakeProfitTiers = Collections.unmodifiableList(new ArrayList<BracketTier>(additionalTakeProfitTiers));
        this.stopLossOffset = stopLossOffset;
        this.stopLossTrailingStep = stopLossTrailingStep;
        this.additionalStopLossTiers = Collections.unmodifiableList(new ArrayList<BracketTier>(additionalStopLossTiers));
        this.takeProfitClientId = takeProfitClientId;
        this.stopLossClientId = stopLossClientId;
        this.trailingStep = trailingStep;
        this.doNotIncrease = doNotIncrease;
        this.reversingPositionHint = reversingPositionHint;
        this.closingPositionHint = closingPositionHint;
        this.stopLossLimitOffset = stopLossLimitOffset;
    }

    @Deprecated
    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, String clientId, double limitPrice, double stopPrice, int takeProfitOffset, int stopLossOffset, int stopLossTrailingStep, int trailingStep, boolean doNotIncrease, boolean reversingPositionHint, boolean closingPositionHint) {
        this(alias, isBuy, size, duration, clientId, limitPrice, stopPrice, takeProfitOffset, Collections.emptyList(), stopLossOffset, stopLossTrailingStep, Collections.emptyList(), IdHelper.generateShortUuid(), IdHelper.generateShortUuid(), trailingStep, doNotIncrease, reversingPositionHint, closingPositionHint, null, OrderEntryType.AUTO);
    }

    @Deprecated
    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, String clientId, double limitPrice, double stopPrice, int takeProfitOffset, int stopLossOffset, int stopLossTrailingStep, int trailingStep, boolean doNotIncrease) {
        this(alias, isBuy, size, duration, clientId, limitPrice, stopPrice, takeProfitOffset, stopLossOffset, stopLossTrailingStep, trailingStep, doNotIncrease, false, false);
    }

    @Deprecated
    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, double limitPrice, double stopPrice, double sizeMultiplier) {
        this(alias, isBuy, size, duration, limitPrice, stopPrice);
    }

    @Deprecated
    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, int trailingStep, double limitPrice, double stopPrice, double sizeMultiplier) {
        this(alias, isBuy, size, duration, trailingStep, limitPrice, stopPrice);
    }

    @Deprecated
    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, double limitPrice, double stopPrice, int takeProfitOffset, int stopLossOffset, int stopLossTrailingStep, int trailingStep, boolean doNotIncrease, double sizeMultiplier) {
        this(alias, isBuy, size, duration, limitPrice, stopPrice, takeProfitOffset, stopLossOffset, stopLossTrailingStep, trailingStep, doNotIncrease);
    }

    @Deprecated
    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, String clientId, double limitPrice, double stopPrice, int takeProfitOffset, int stopLossOffset, int stopLossTrailingStep, int trailingStep, boolean doNotIncrease, double sizeMultiplier) {
        this(alias, isBuy, size, duration, clientId, limitPrice, stopPrice, takeProfitOffset, stopLossOffset, stopLossTrailingStep, trailingStep, doNotIncrease);
    }

    public AbstractSimpleOrderSendParametersBuilder<SimpleOrderSendParametersBuilder> toBuilder() {
        return new SimpleOrderSendParametersBuilder(this.alias, this.isBuy, this.size, this.duration, this.clientId, this.limitPrice, this.stopPrice, this.takeProfitOffset, this.additionalTakeProfitTiers, this.stopLossOffset, this.stopLossTrailingStep, this.additionalStopLossTiers, this.takeProfitClientId, this.stopLossClientId, this.trailingStep, this.doNotIncrease, this.reversingPositionHint, this.closingPositionHint, this.accountId, this.orderEntryType, this.stopLossLimitOffset);
    }

    @Override
    public String toString() {
        return this.getClass() + "{super=" + super.toString() + ", limitPrice=" + this.limitPrice + ", stopPrice=" + this.stopPrice + ", takeProfitOffset=" + this.takeProfitOffset + ", stopLossOffset=" + this.stopLossOffset + ", stopLossTrailingStep=" + this.stopLossTrailingStep + ", takeProfitClientId=" + this.takeProfitClientId + ", stopLossClientId=" + this.stopLossClientId + ", trailingStep=" + this.trailingStep + ", doNotIncrease=" + this.doNotIncrease + ", reversingPositionHint=" + this.reversingPositionHint + ", closingPositionHint=" + this.closingPositionHint + ", accountId=" + this.accountId + ", stopLossLimitOffset=" + this.stopLossLimitOffset + "}";
    }

    @Deprecated
    public String representation(PriceFormatter formatter, double sizeMultiplier) {
        return OrderRepresentationHelper.textRepresentation(this, formatter::format, sizeMultiplier);
    }

    @Deprecated
    public static interface PriceFormatter {
        public String format(double var1);
    }
}

