/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.providers.helper;

import java.util.function.Function;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.data.ProviderType;
import velox.api.layer1.providers.MultiplatformProvider;

@Layer1ApiPublic
public class InstrumentDataRequestRedirectHelper {
    public static Object redirectUserMessage(Object data, Function<Object, Object> forwardFunction, Function<String, String> aliasMapper) {
        return InstrumentDataRequestRedirectHelper.redirectUserMessage(data, forwardFunction, aliasMapper, false);
    }

    public static Object redirectUserMessage(Object data, Function<Object, Object> forwardFunction, Function<String, String> aliasMapper, boolean keepProvider) {
        if (data instanceof MultiplatformProvider.ProviderTypeRequest) {
            MultiplatformProvider.ProviderTypeRequest providerTypeRequest = (MultiplatformProvider.ProviderTypeRequest)data;
            String alias = providerTypeRequest.alias;
            String remappedAlias = aliasMapper.apply(alias);
            if (remappedAlias != null) {
                if (keepProvider) {
                    return forwardFunction.apply(new MultiplatformProvider.ProviderTypeRequest(remappedAlias));
                }
                return ProviderType.UNKNOWN;
            }
        } else if (data instanceof MultiplatformProvider.AliasTargetedRequest) {
            MultiplatformProvider.AliasTargetedRequest aliasTargetedRequest = (MultiplatformProvider.AliasTargetedRequest)data;
            String alias = aliasTargetedRequest.alias;
            Function request = aliasTargetedRequest.request;
            String remappedAlias = aliasMapper.apply(alias);
            if (remappedAlias != null) {
                return forwardFunction.apply(new MultiplatformProvider.AliasTargetedRequest(remappedAlias, request));
            }
        } else if (data instanceof MultiplatformProvider.AliasInfoRequest) {
            MultiplatformProvider.AliasInfoRequest aliasInfoRequest = (MultiplatformProvider.AliasInfoRequest)data;
            String alias = aliasInfoRequest.userAlias;
            String remappedAlias = aliasMapper.apply(alias);
            if (remappedAlias != null) {
                if (keepProvider) {
                    return forwardFunction.apply(new MultiplatformProvider.AliasInfoRequest(remappedAlias));
                }
                return new MultiplatformProvider.ProviderTypeAliasPair(ProviderType.UNKNOWN, alias);
            }
        }
        return forwardFunction.apply(data);
    }
}

