/*
 * Decompiled with CFR 0.152.
 */
package velox.gui.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.Utils;
import velox.api.layer1.utils.data.ResetPoint;
import velox.api.layer1.utils.data.ResetPointAddDialog;
import velox.api.layer1.utils.data.TimeItem;
import velox.gui.BookmapScrollPane;
import velox.gui.laf.newbookmap.NewBookmapTitledBorder;
import velox.gui.utils.ResetPointsLabelsPanel;
import velox.gui.utils.ResetPointsTitlePanel;
import velox.gui.utils.localization.LocalizedBundleImplLeve1Api;

@Layer1ApiPublic
public class GuiUtils {
    public static void setPanelEnabled(JPanel panel, Boolean isEnabled) {
        GuiUtils.doForEachComponentInPanel(panel, c -> c.setEnabled(isEnabled));
    }

    public static void doForEachComponentInPanel(JPanel panel, Consumer<Component> action) {
        action.accept(panel);
        Component[] components = panel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component view;
            JScrollPane scrollPane;
            JViewport viewport;
            Component component = components[i];
            if (component instanceof JScrollPane && (viewport = (scrollPane = (JScrollPane)component).getViewport()) != null && (view = viewport.getView()) != null) {
                action.accept(component);
                component = viewport.getView();
            }
            if (component instanceof JPanel) {
                GuiUtils.doForEachComponentInPanel((JPanel)component, action);
                continue;
            }
            action.accept(component);
        }
    }

    public static Utils.Pair<JPanel, JScrollPane> getPanelResetPoints() {
        JPanel panelResetPoints = new JPanel();
        panelResetPoints.setLayout(new BoxLayout(panelResetPoints, 1));
        BookmapScrollPane scrollPaneResetPoints = new BookmapScrollPane(panelResetPoints);
        scrollPaneResetPoints.setHorizontalScrollBarPolicy(31);
        scrollPaneResetPoints.setMinimumSize(new Dimension(400, 210));
        scrollPaneResetPoints.setPreferredSize(new Dimension(400, 210));
        scrollPaneResetPoints.setBorder((Border)new NewBookmapTitledBorder("", NewBookmapTitledBorder.TINY_BORDER));
        panelResetPoints.add((Component)new ResetPointsTitlePanel());
        panelResetPoints.add((Component)new ResetPointsLabelsPanel());
        return new Utils.Pair((Object)panelResetPoints, (Object)scrollPaneResetPoints);
    }

    public static JPanel getResetControlPanel(final ResetControlPanelCallbacks callbacks, final JPanel panelResetPoints, boolean isSessionStartTimeEnabled) {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridBagLayout());
        controlPanel.setBorder(new EmptyBorder(0, 20, 0, 0));
        LocalizedBundleImplLeve1Api localizedBundle = LocalizedBundleImplLeve1Api.getInstance();
        JButton btnResetNow = new JButton(localizedBundle.getString("GuiUtils.JButton.ResetNow"));
        JButton btnAdd = new JButton(localizedBundle.getString("GuiUtils.JButton.Add"));
        JButton btnClear = new JButton(localizedBundle.getString("GuiUtils.JButton.Clear"));
        JCheckBox cbSessionStart = new JCheckBox(localizedBundle.getString("GuiUtils.JCheckBox.SessionStart"), isSessionStartTimeEnabled);
        btnAdd.setPreferredSize(btnResetNow.getPreferredSize());
        btnClear.setPreferredSize(btnResetNow.getPreferredSize());
        btnResetNow.addActionListener(e -> {
            ResetPoint resetPoint = new ResetPoint();
            resetPoint.setTimeItem(TimeItem.TIMEITEM_NEVER);
            resetPoint.setStartTime(callbacks.getCurrentTime() / TimeUnit.MILLISECONDS.toNanos(1L));
            callbacks.onAddResetPoint(resetPoint);
            SwingUtilities.invokeLater(() -> {
                panelResetPoints.revalidate();
                panelResetPoints.repaint();
            });
        });
        btnClear.addActionListener(e -> {
            callbacks.onClearPoints();
            SwingUtilities.invokeLater(() -> {
                panelResetPoints.revalidate();
                panelResetPoints.repaint();
            });
        });
        btnAdd.addActionListener(e -> {
            ResetPointAddDialog addDialog = new ResetPointAddDialog(new ResetPointAddDialog.ResetPointAddDialogCallbacks(){

                public void onOk(ResetPoint resetPoint) {
                    callbacks.onAddResetPoint(resetPoint);
                    SwingUtilities.invokeLater(() -> {
                        panelResetPoints.revalidate();
                        panelResetPoints.repaint();
                    });
                }

                public void onCancel() {
                }
            }, callbacks.getCurrentTime());
            addDialog.setVisible(true);
        });
        cbSessionStart.addActionListener(e -> callbacks.onSessionStartTimeEnabled(cbSessionStart.isSelected()));
        GridBagConstraints gbConst = new GridBagConstraints();
        gbConst.gridx = 0;
        gbConst.gridy = 0;
        gbConst.gridwidth = 1;
        gbConst.fill = 2;
        gbConst.insets = new Insets(5, 5, 5, 5);
        gbConst.weightx = 1.0;
        controlPanel.add((Component)btnResetNow, gbConst);
        gbConst = new GridBagConstraints();
        gbConst.gridx = 2;
        gbConst.gridy = 0;
        gbConst.gridwidth = 1;
        gbConst.fill = 2;
        gbConst.insets = new Insets(5, 5, 5, 5);
        gbConst.weightx = 1.0;
        controlPanel.add((Component)btnAdd, gbConst);
        gbConst = new GridBagConstraints();
        gbConst.gridx = 3;
        gbConst.gridy = 0;
        gbConst.gridwidth = 1;
        gbConst.fill = 2;
        gbConst.insets = new Insets(5, 5, 5, 5);
        gbConst.weightx = 1.0;
        controlPanel.add((Component)btnClear, gbConst);
        gbConst = new GridBagConstraints();
        gbConst.gridx = 4;
        gbConst.gridy = 0;
        gbConst.gridwidth = 1;
        gbConst.fill = 2;
        gbConst.insets = new Insets(5, 5, 5, 5);
        gbConst.weightx = 1.0;
        controlPanel.add((Component)cbSessionStart, gbConst);
        return controlPanel;
    }

    public static GridBagConstraints getCommonGbc(int x, int y, int width) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        return gbc;
    }

    public static interface ResetControlPanelCallbacks {
        public void onAddResetPoint(ResetPoint var1);

        public void onClearPoints();

        public long getCurrentTime();

        public void onSessionStartTimeEnabled(boolean var1);
    }
}

