/*
 * Decompiled with CFR 0.152.
 */
package velox.gui.utils.localization.translatable;

import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.gui.utils.localization.LocalizedBundleImpl;
import velox.gui.utils.localization.translatable.TranslatableComponent;

@Layer1ApiPublic
public class TranslatableText
implements TranslatableComponent {
    private final String key;
    private final Map<String, Object> args;
    private final String bundleName;
    private final ClassLoader classLoader;
    private final boolean throwException;

    public TranslatableText(String key, Map<String, Object> args, String bundleName, ClassLoader classLoader, boolean throwException) {
        this.key = key;
        this.args = args;
        this.bundleName = bundleName;
        this.classLoader = classLoader;
        this.throwException = throwException;
    }

    public TranslatableText(String key, String bundleName, ClassLoader classLoader, boolean throwException) {
        this(key, null, bundleName, classLoader, throwException);
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public String toLocalizedString(ULocale locale) {
        String result;
        if (this.bundleName == null) {
            return this.key;
        }
        Map<String, Object> normalizedArgs = null;
        if (this.args != null && this.args.size() > 0) {
            normalizedArgs = this.getNormalizedArgs(locale);
        }
        LocalizedBundleImpl localizedBundle = new LocalizedBundleImpl(this.bundleName, locale, this.classLoader);
        try {
            result = normalizedArgs != null ? localizedBundle.getString(this.key, normalizedArgs) : localizedBundle.getString(this.key);
        }
        catch (MissingResourceException e) {
            if (this.throwException) {
                throw e;
            }
            result = this.key;
        }
        return result;
    }

    private Map<String, Object> getNormalizedArgs(ULocale locale) {
        HashMap<String, Object> normalizedArgs = new HashMap<String, Object>();
        for (Map.Entry<String, Object> argument : this.args.entrySet()) {
            if (argument.getValue() instanceof TranslatableComponent) {
                TranslatableComponent component = (TranslatableComponent)argument.getValue();
                normalizedArgs.put(argument.getKey(), component.toLocalizedString(locale));
                continue;
            }
            normalizedArgs.put(argument.getKey(), argument.getValue());
        }
        return normalizedArgs;
    }

    public int hashCode() {
        return Objects.hash(this.bundleName, this.key, this.args == null ? null : Integer.valueOf(this.args.hashCode()));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TranslatableText)) {
            return false;
        }
        TranslatableText translatableText = (TranslatableText)obj;
        return Objects.equals(this.bundleName, translatableText.bundleName) && Objects.equals(this.key, translatableText.key) && Objects.deepEquals(this.args, translatableText.args);
    }

    public String toString() {
        return "TranslatableText [defaultText=" + this.toDefaultString() + ", key=" + this.key + ", args=" + this.args + ", bundleName=" + this.bundleName + "]";
    }
}

