/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.common.helper;

import java.util.HashMap;
import java.util.Map;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.Utils;
import velox.api.layer1.data.AbsoluteBracketsValuesOrderSendParameters;
import velox.api.layer1.data.OrderType;
import velox.api.layer1.data.SimpleOrderSendParameters;
import velox.gui.utils.localization.LocalizedBundleImplLeve1Api;

@Layer1ApiPublic
public class OrderRepresentationHelper {
    public static String textRepresentation(SimpleOrderSendParameters order, PriceFormatter formatter, double sizeMultiplier) {
        if (order instanceof AbsoluteBracketsValuesOrderSendParameters) {
            return OrderRepresentationHelper.absoluteBracketsValuesOrderTextRepresentation((AbsoluteBracketsValuesOrderSendParameters)order, formatter, sizeMultiplier);
        }
        return OrderRepresentationHelper.simpleOrderTextRepresentation(order, formatter, sizeMultiplier);
    }

    private static String simpleOrderTextRepresentation(SimpleOrderSendParameters order, PriceFormatter formatter, double sizeMultiplier) {
        LocalizedBundleImplLeve1Api localizedBundle = LocalizedBundleImplLeve1Api.getInstance();
        OrderType type = OrderType.getTypeFromPrices(order.stopPrice, order.limitPrice);
        boolean hasTrailingStop = order.trailingStep > 0 && (OrderType.STP == type || OrderType.STP_LMT == type);
        String typeText = OrderType.STP == type ? localizedBundle.getString("OrderRepresentationHelper.String.StopMarketOrder") : type.toLocalizedString();
        String buySellText = order.isBuy ? localizedBundle.getString("OrderRepresentationHelper.String.Buy") : localizedBundle.getString("OrderRepresentationHelper.String.Sell");
        HashMap<String, Object> localizationArgs = new HashMap<String, Object>(Map.of("type", typeText, "buySell", buySellText, "size", Utils.doubleToString((double)((double)order.size / sizeMultiplier)), "duration", order.duration.toLocalizedString()));
        if (type == OrderType.MKT) {
            return localizedBundle.getString("OrderRepresentationHelper.String.MarketSimpleOrderRepresentation", localizationArgs);
        }
        localizationArgs.put("price", formatter.format(OrderType.STP == type || OrderType.STP_LMT == type ? order.stopPrice : order.limitPrice));
        if (type == OrderType.STP_LMT) {
            localizationArgs.put("limitPrice", formatter.format(order.limitPrice));
            if (hasTrailingStop) {
                localizationArgs.put("trailingStep", order.trailingStep);
                return localizedBundle.getString("OrderRepresentationHelper.String.StopLimitWithTrailingStopSimpleOrderRepresentation", localizationArgs);
            }
            return localizedBundle.getString("OrderRepresentationHelper.String.StopLimitSimpleOrderRepresentation", localizationArgs);
        }
        if (hasTrailingStop) {
            localizationArgs.put("trailingStep", order.trailingStep);
            return localizedBundle.getString("OrderRepresentationHelper.String.LimitWithTrailingStopSimpleOrderRepresentation", localizationArgs);
        }
        return localizedBundle.getString("OrderRepresentationHelper.String.LimitSimpleOrderRepresentation", localizationArgs);
    }

    private static String absoluteBracketsValuesOrderTextRepresentation(AbsoluteBracketsValuesOrderSendParameters order, PriceFormatter formatter, double sizeMultiplier) {
        LocalizedBundleImplLeve1Api localizedBundle = LocalizedBundleImplLeve1Api.getInstance();
        OrderType type = OrderType.getTypeFromPrices(order.stopPrice, order.limitPrice);
        StringBuilder builder = new StringBuilder();
        String buySellText = order.isBuy ? localizedBundle.getString("OrderRepresentationHelper.String.Buy") : localizedBundle.getString("OrderRepresentationHelper.String.Sell");
        HashMap<String, Object> localizationArgs = new HashMap<String, Object>(Map.of("type", type.toLocalizedString(), "buySell", buySellText, "size", Utils.doubleToString((double)((double)order.size / sizeMultiplier))));
        if (order.trailingStep > 0 && (OrderType.STP == type || OrderType.STP_LMT == type)) {
            localizationArgs.put("trailingStep", order.trailingStep);
            builder.append(localizedBundle.getString("OrderRepresentationHelper.String.AbsoluteBracketsValuesWithTrailingStopOrderRepresentation", localizationArgs));
        } else {
            builder.append(localizedBundle.getString("OrderRepresentationHelper.String.AbsoluteBracketsValuesOrderRepresentation", localizationArgs));
        }
        builder.append("<ul>");
        if (order.takeProfitOffset > 0) {
            builder.append("<li>");
            builder.append(localizedBundle.getString("OrderRepresentationHelper.String.TakeProfitPrice", Map.of("price", formatter.format(order.takeProfitPrice))));
            builder.append("</li>");
        }
        if (order.stopLossOffset > 0) {
            builder.append("<li>");
            builder.append(localizedBundle.getString("OrderRepresentationHelper.String.StopLossPrice", Map.of("price", formatter.format(order.stopLossPrice))));
            builder.append("</li>");
        }
        builder.append("</ul>");
        return builder.toString();
    }

    @Layer1ApiPublic
    public static interface PriceFormatter {
        public String format(double var1);
    }
}

