/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import java.util.List;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.data.AbstractSingleOrderSendParametersBuilder;
import velox.api.layer1.data.BracketTier;
import velox.api.layer1.data.OrderDuration;
import velox.api.layer1.data.OrderEntryType;
import velox.api.layer1.data.SimpleOrderSendParameters;

@Layer1ApiPublic
public abstract class AbstractSimpleOrderSendParametersBuilder<T extends AbstractSimpleOrderSendParametersBuilder<T>>
extends AbstractSingleOrderSendParametersBuilder<AbstractSimpleOrderSendParametersBuilder<T>> {
    protected double limitPrice;
    protected double stopPrice;
    protected int takeProfitOffset;
    protected List<BracketTier> additionalTakeProfitTiers;
    protected int stopLossOffset;
    protected int stopLossTrailingStep;
    protected List<BracketTier> additionalStopLossTiers;
    protected String takeProfitClientId;
    protected String stopLossClientId;
    protected int trailingStep;
    protected boolean doNotIncrease;
    protected boolean reversingPositionHint;
    protected boolean closingPositionHint;
    protected Integer stopLossLimitOffset;

    AbstractSimpleOrderSendParametersBuilder(String alias, boolean isBuy, int size, OrderDuration duration, String clientId, double limitPrice, double stopPrice, int takeProfitOffset, List<BracketTier> additionalTakeProfitTiers, int stopLossOffset, int stopLossTrailingStep, List<BracketTier> additionalStopLossTiers, String takeProfitClientId, String stopLossClientId, int trailingStep, boolean doNotIncrease, boolean reversingPositionHint, boolean closingPositionHint, String accountId, OrderEntryType orderEntryType, Integer stopLossLimitOffset) {
        super(alias, isBuy, size, duration, clientId, accountId, orderEntryType);
        this.limitPrice = limitPrice;
        this.stopPrice = stopPrice;
        this.takeProfitOffset = takeProfitOffset;
        this.additionalTakeProfitTiers = additionalTakeProfitTiers;
        this.stopLossOffset = stopLossOffset;
        this.stopLossTrailingStep = stopLossTrailingStep;
        this.additionalStopLossTiers = additionalStopLossTiers;
        this.takeProfitClientId = takeProfitClientId;
        this.stopLossClientId = stopLossClientId;
        this.trailingStep = trailingStep;
        this.doNotIncrease = doNotIncrease;
        this.reversingPositionHint = reversingPositionHint;
        this.closingPositionHint = closingPositionHint;
        this.stopLossLimitOffset = stopLossLimitOffset;
    }

    @Override
    public SimpleOrderSendParameters build() {
        return new SimpleOrderSendParameters(this.alias, this.isBuy, this.size, this.duration, this.clientId, this.limitPrice, this.stopPrice, this.takeProfitOffset, this.additionalTakeProfitTiers, this.stopLossOffset, this.stopLossTrailingStep, this.additionalStopLossTiers, this.takeProfitClientId, this.stopLossClientId, this.trailingStep, this.doNotIncrease, this.reversingPositionHint, this.closingPositionHint, this.accountId, this.orderEntryType, this.stopLossLimitOffset);
    }

    @Override
    public String toString() {
        return this.getClass() + "{super=" + super.toString() + ", limitPrice=" + this.limitPrice + ", stopPrice=" + this.stopPrice + ", takeProfitOffset=" + this.takeProfitOffset + ", stopLossOffset=" + this.stopLossOffset + ", stopLossTrailingStep=" + this.stopLossTrailingStep + ", takeProfitClientId=" + this.takeProfitClientId + ", stopLossClientId=" + this.stopLossClientId + ", trailingStep=" + this.trailingStep + ", doNotIncrease=" + this.doNotIncrease + ", reversingPositionHint=" + this.reversingPositionHint + ", closingPositionHint=" + this.closingPositionHint + ", stopLossLimitOffset=" + this.stopLossLimitOffset + "}";
    }

    public double getLimitPrice() {
        return this.limitPrice;
    }

    public T setLimitPrice(double limitPrice) {
        this.limitPrice = limitPrice;
        return (T)this;
    }

    public double getStopPrice() {
        return this.stopPrice;
    }

    public T setStopPrice(double stopPrice) {
        this.stopPrice = stopPrice;
        return (T)this;
    }

    public int getTakeProfitOffset() {
        return this.takeProfitOffset;
    }

    public T setTakeProfitOffset(int takeProfitOffset) {
        this.takeProfitOffset = takeProfitOffset;
        return (T)this;
    }

    public List<BracketTier> getAdditionalTakeProfitTiers() {
        return this.additionalTakeProfitTiers;
    }

    public T setAdditionalTakeProfitTiers(List<BracketTier> additionalTakeProfitTiers) {
        this.additionalTakeProfitTiers = additionalTakeProfitTiers;
        return (T)this;
    }

    public int getStopLossOffset() {
        return this.stopLossOffset;
    }

    public T setStopLossOffset(int stopLossOffset) {
        this.stopLossOffset = stopLossOffset;
        return (T)this;
    }

    public int getStopLossTrailingStep() {
        return this.stopLossTrailingStep;
    }

    public T setStopLossTrailingStep(int stopLossTrailingStep) {
        this.stopLossTrailingStep = stopLossTrailingStep;
        return (T)this;
    }

    public List<BracketTier> getAdditionalStopLossTiers() {
        return this.additionalStopLossTiers;
    }

    public T setAdditionalStopLossTiers(List<BracketTier> additionalStopLossTiers) {
        this.additionalStopLossTiers = additionalStopLossTiers;
        return (T)this;
    }

    public String getTakeProfitClientId() {
        return this.takeProfitClientId;
    }

    public T setTakeProfitClientId(String takeProfitClientId) {
        this.takeProfitClientId = takeProfitClientId;
        return (T)this;
    }

    public String getStopLossClientId() {
        return this.stopLossClientId;
    }

    public T setStopLossClientId(String stopLossClientId) {
        this.stopLossClientId = stopLossClientId;
        return (T)this;
    }

    public int getTrailingStep() {
        return this.trailingStep;
    }

    public T setTrailingStep(int trailingStep) {
        this.trailingStep = trailingStep;
        return (T)this;
    }

    public boolean isDoNotIncrease() {
        return this.doNotIncrease;
    }

    public T setDoNotIncrease(boolean doNotIncrease) {
        this.doNotIncrease = doNotIncrease;
        return (T)this;
    }

    public boolean isReversingPositionHint() {
        return this.reversingPositionHint;
    }

    public T setReversingPositionHint(boolean reversingPositionHint) {
        this.reversingPositionHint = reversingPositionHint;
        return (T)this;
    }

    public boolean isClosingPositionHint() {
        return this.closingPositionHint;
    }

    public T setClosingPositionHint(boolean closingPositionHint) {
        this.closingPositionHint = closingPositionHint;
        return (T)this;
    }

    @Deprecated
    public double getSizeMultiplier() {
        return Double.NaN;
    }

    @Deprecated
    public T setSizeMultiplier(double sizeMultiplier) {
        return (T)this;
    }

    public int getStopLossLimitOffset() {
        return this.stopLossLimitOffset;
    }

    public T setStopLossLimitOffset(int stopLossLimitOffset) {
        this.stopLossLimitOffset = stopLossLimitOffset;
        return (T)this;
    }
}

