/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;
import velox.api.layer1.annotations.Layer1ApiPublic;

@Layer1ApiPublic
public class TradeInfo
implements Serializable {
    private static final long serialVersionUID = -5266538964320734421L;
    public final boolean isOtc;
    public final boolean isBidAggressor;
    public final boolean isExecutionStart;
    public final boolean isExecutionEnd;
    public final @Nullable String aggressorOrderId;
    public final @Nullable String passiveOrderId;
    public final long id;

    public TradeInfo(boolean isOtc, boolean isBidAggressor) {
        this(isOtc, isBidAggressor, Long.MIN_VALUE);
    }

    public TradeInfo(boolean isOtc, boolean isBidAggressor, long id) {
        this(isOtc, isBidAggressor, true, true, id);
    }

    public TradeInfo(boolean isOtc, boolean isBidAggressor, boolean isExecutionStart, boolean isExecutionEnd) {
        this(isOtc, isBidAggressor, isExecutionStart, isExecutionEnd, null, null, Long.MIN_VALUE);
    }

    public TradeInfo(boolean isOtc, boolean isBidAggressor, boolean isExecutionStart, boolean isExecutionEnd, long id) {
        this(isOtc, isBidAggressor, isExecutionStart, isExecutionEnd, null, null, id);
    }

    public TradeInfo(boolean isOtc, boolean isBidAggressor, boolean isExecutionStart, boolean isExecutionEnd, @Nullable String aggressorOrderId, @Nullable String passiveOrderId) {
        this(isOtc, isBidAggressor, isExecutionStart, isExecutionEnd, aggressorOrderId, passiveOrderId, Long.MIN_VALUE);
    }

    public TradeInfo(boolean isOtc, boolean isBidAggressor, boolean isExecutionStart, boolean isExecutionEnd, @Nullable String aggressorOrderId, @Nullable String passiveOrderId, long id) {
        this.isOtc = isOtc;
        this.isBidAggressor = isBidAggressor;
        this.isExecutionStart = isExecutionStart;
        this.isExecutionEnd = isExecutionEnd;
        this.aggressorOrderId = aggressorOrderId;
        this.passiveOrderId = passiveOrderId;
        this.id = id;
    }

    public boolean compare(TradeInfo other) {
        return this.isBidAggressor == other.isBidAggressor && this.isOtc == other.isOtc && this.isExecutionStart == other.isExecutionStart && this.isExecutionEnd == other.isExecutionEnd;
    }

    public String toString() {
        return "TradeInfo{isOtc=" + this.isOtc + ", isBidAggressor=" + this.isBidAggressor + ", isExecutionStart=" + this.isExecutionStart + ", isExecutionEnd=" + this.isExecutionEnd + ", aggressorOrderId='" + this.aggressorOrderId + "', passiveOrderId='" + this.passiveOrderId + "'}";
    }
}

