/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.datastructure.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.datastructure.events.Event;
import velox.api.layer1.datastructure.events.EventType;

@Layer1ApiPublic
public class TradeAggregationEvent
extends Event {
    private static final long serialVersionUID = 6529871794977925342L;
    public Map<Double, Map<Integer, Integer>> bidAggressorMap = new HashMap<Double, Map<Integer, Integer>>();
    public Map<Double, Map<Integer, Integer>> askAggressorMap = new HashMap<Double, Map<Integer, Integer>>();
    public double lastPrice = Double.NaN;
    public Integer lastSize = null;
    public Boolean lastAggressorBid = null;
    public double firstPrice = Double.NaN;
    public Integer firstSize = null;
    public Boolean firstAggressorBid = null;
    public List<Long> aggregatedIds = new ArrayList<Long>();

    public TradeAggregationEvent(long time) {
        super(time, EventType.NONE);
    }

    @Override
    public Object clone() {
        TradeAggregationEvent event = new TradeAggregationEvent(this.time);
        for (Map.Entry<Double, Map<Integer, Integer>> entry : this.bidAggressorMap.entrySet()) {
            event.bidAggressorMap.put(entry.getKey(), (Map)((HashMap)entry.getValue()).clone());
        }
        for (Map.Entry<Double, Map<Integer, Integer>> entry : this.askAggressorMap.entrySet()) {
            event.askAggressorMap.put(entry.getKey(), (Map)((HashMap)entry.getValue()).clone());
        }
        event.lastPrice = this.lastPrice;
        event.lastSize = this.lastSize;
        event.lastAggressorBid = this.lastAggressorBid;
        event.firstPrice = this.firstPrice;
        event.firstSize = this.firstSize;
        event.firstAggressorBid = this.firstAggressorBid;
        event.aggregatedIds = new ArrayList<Long>(this.aggregatedIds);
        return event;
    }

    private int getMapSum(Map<Double, Map<Integer, Integer>> map) {
        int result = 0;
        for (Map.Entry<Double, Map<Integer, Integer>> priceEntry : map.entrySet()) {
            for (Map.Entry<Integer, Integer> entry : priceEntry.getValue().entrySet()) {
                result += entry.getValue() * entry.getKey();
            }
        }
        return result;
    }

    public int getBidTradeSize() {
        return this.getMapSum(this.bidAggressorMap);
    }

    public int getAskTradeSize() {
        return this.getMapSum(this.askAggressorMap);
    }

    public int getTotalTradeSize() {
        return this.getBidTradeSize() + this.getAskTradeSize();
    }

    public String toString() {
        return "TradeAggregationEvent{bidAggressorMap=" + this.bidAggressorMap + ", askAggressorMap=" + this.askAggressorMap + ", lastPrice=" + this.lastPrice + ", lastSize=" + this.lastSize + ", lastAggressorBid=" + this.lastAggressorBid + ", time=" + this.time + ", firstPrice=" + this.firstPrice + ", firstSize=" + this.firstSize + ", firstAggressorBid=" + this.firstAggressorBid + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TradeAggregationEvent)) {
            return false;
        }
        TradeAggregationEvent that = (TradeAggregationEvent)o;
        return Double.compare(this.lastPrice, that.lastPrice) == 0 && Double.compare(this.firstPrice, that.firstPrice) == 0 && Objects.equals(this.bidAggressorMap, that.bidAggressorMap) && Objects.equals(this.askAggressorMap, that.askAggressorMap) && Objects.equals(this.lastSize, that.lastSize) && Objects.equals(this.lastAggressorBid, that.lastAggressorBid) && Objects.equals(this.firstSize, that.firstSize) && Objects.equals(this.firstAggressorBid, that.firstAggressorBid);
    }

    public int hashCode() {
        return Objects.hash(this.bidAggressorMap, this.askAggressorMap, this.lastPrice, this.lastSize, this.lastAggressorBid, this.firstPrice, this.firstSize, this.firstAggressorBid);
    }
}

