/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.gui;

import java.awt.Image;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.Utils;

@Layer1ApiPublic
public class Layer1DefaultAlertIcons {
    private static final String NOT_INITIALIZED_ERROR = "Layer1DefaultAlertIcons has not been initialized";
    private static Image infoIcon;
    private static Image warnIcon;
    private static Image errorIcon;

    private Layer1DefaultAlertIcons() {
    }

    private static Image getImageOrThrowException(String imageKey) {
        ImageIcon imageIcon = (ImageIcon)UIManager.get(imageKey);
        if (imageIcon == null) {
            throw new RuntimeException("Cannot find an icon in L&F: " + imageKey);
        }
        return imageIcon.getImage();
    }

    public static void init() {
        Utils.throwExceptionIfNotFromEdt();
        infoIcon = Layer1DefaultAlertIcons.getImageOrThrowException("Popup.informationIcon");
        warnIcon = Layer1DefaultAlertIcons.getImageOrThrowException("Popup.warningIcon");
        errorIcon = Layer1DefaultAlertIcons.getImageOrThrowException("Popup.errorIcon");
    }

    public static Image getInfoIcon() {
        return Objects.requireNonNull(infoIcon, NOT_INITIALIZED_ERROR);
    }

    public static Image getWarnIcon() {
        return Objects.requireNonNull(warnIcon, NOT_INITIALIZED_ERROR);
    }

    public static Image getErrorIcon() {
        return Objects.requireNonNull(errorIcon, NOT_INITIALIZED_ERROR);
    }
}

