/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.layers.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.layers.utils.OrderBook;

@Layer1ApiPublic
public class OrderByOrderBook {
    private final OrderBook orderBook = new OrderBook();
    private Map<Long, Order> orders = new ConcurrentHashMap<Long, Order>();

    public OrderBook getOrderBook() {
        return this.orderBook;
    }

    public long addOrder(long id, boolean isBid, int price, long size) throws IllegalArgumentException {
        Order order = new Order(isBid, price, size);
        if (this.orders.put(id, order) != null) {
            throw new IllegalArgumentException("Order with id = " + id + " already exists");
        }
        if (size < 0L) {
            throw new IllegalArgumentException("Order size < 0:" + size);
        }
        long totalSize = this.orderBook.getSizeFor(isBid, price, 0L);
        this.orderBook.onUpdate(isBid, price, totalSize += size);
        return totalSize;
    }

    public OrderUpdateResult updateOrder(long id, int price, long size) throws IllegalArgumentException {
        long totalSizeOld;
        Order oldOrder = this.orders.get(id);
        if (oldOrder == null) {
            throw new IllegalArgumentException("Order with id = " + id + " does not exist");
        }
        if (size < 0L) {
            throw new IllegalArgumentException("Order size < 0:" + size);
        }
        boolean isBid = oldOrder.isBid;
        long oldSize = oldOrder.size;
        int oldPrice = oldOrder.price;
        Order newOrder = new Order(isBid, price, size);
        this.orders.put(id, newOrder);
        long totalSizeNew = this.orderBook.getSizeFor(isBid, price, 0L);
        if (oldPrice == price) {
            totalSizeOld = totalSizeNew -= oldSize;
        } else {
            totalSizeOld = this.orderBook.getSizeFor(isBid, oldPrice, 0L);
            this.orderBook.onUpdate(isBid, oldPrice, totalSizeOld -= oldSize);
        }
        this.orderBook.onUpdate(isBid, price, totalSizeNew += size);
        return new OrderUpdateResult(oldPrice, totalSizeOld, totalSizeNew);
    }

    public long removeOrder(long id) throws IllegalArgumentException {
        Order order = this.orders.remove(id);
        if (order == null) {
            throw new IllegalArgumentException("Order with id = " + id + " does not exist");
        }
        int price = order.price;
        long size = order.size;
        boolean isBid = order.isBid;
        long totalSize = this.orderBook.getSizeFor(isBid, price, 0L);
        this.orderBook.onUpdate(isBid, price, totalSize -= size);
        return totalSize;
    }

    public int getLastPriceOfOrder(long id) throws NullPointerException {
        return this.orders.get((Object)Long.valueOf((long)id)).price;
    }

    public boolean getSide(long id) throws NullPointerException {
        return this.orders.get((Object)Long.valueOf((long)id)).isBid;
    }

    public boolean hasOrder(long id) {
        return this.orders.containsKey(id);
    }

    public Order getOrder(long id) {
        return this.orders.get(id);
    }

    public Collection<Long> getAllIds() {
        return this.orders.keySet();
    }

    public void selfTest() {
        HashMap<Integer, Long> bid = new HashMap<Integer, Long>();
        HashMap ask = new HashMap();
        for (Order order : this.orders.values()) {
            HashMap<Integer, Long> map = order.isBid ? bid : ask;
            long newSize = map.getOrDefault(order.price, 0L) + order.size;
            if (newSize == 0L) {
                map.remove(order.price);
                continue;
            }
            map.put(order.price, newSize);
        }
        if (!this.orderBook.getBidMap().equals(bid) || !this.orderBook.getAskMap().equals(ask)) {
            HashSet bidSet = new HashSet(bid.keySet());
            bidSet.addAll(this.orderBook.getBidMap().keySet());
            Iterator iterator = bidSet.iterator();
            while (iterator.hasNext()) {
                int p = (Integer)iterator.next();
                if (Objects.equals(bid.get(p), this.orderBook.getBidMap().get(p))) continue;
                throw new IllegalStateException("Order book is not in valid state");
            }
            HashSet hashSet = new HashSet(ask.keySet());
            hashSet.addAll(this.orderBook.getAskMap().keySet());
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                int p = (Integer)iterator2.next();
                if (Objects.equals(ask.get(p), this.orderBook.getAskMap().get(p))) continue;
                throw new IllegalStateException("Order book is not in valid state");
            }
            throw new IllegalStateException("Order book is not in valid state");
        }
    }

    @Layer1ApiPublic
    public static class Order {
        public boolean isBid;
        public int price;
        public long size;

        public Order(boolean isBid, int price, long size) {
            this.isBid = isBid;
            this.price = price;
            this.size = size;
        }
    }

    @Layer1ApiPublic
    public static class OrderUpdateResult {
        public final int fromPrice;
        public final long fromSize;
        public final long toSize;

        public OrderUpdateResult(int fromPrice, long fromSize, long toSize) {
            this.fromPrice = fromPrice;
            this.fromSize = fromSize;
            this.toSize = toSize;
        }
    }
}

