/*
 * Decompiled with CFR 0.152.
 */
package velox.gui.utils.localization.translatable;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.gui.utils.localization.translatable.TranslatableComponent;

@Layer1ApiPublic
public class TranslatableList
implements TranslatableComponent {
    private final List<Object> lines;
    private final boolean isHtml;

    public TranslatableList(boolean isHtml) {
        this(isHtml, new ArrayList());
    }

    public TranslatableList(boolean isHtml, List<?> lines) {
        this.lines = lines;
        this.isHtml = isHtml;
    }

    public TranslatableList(boolean isHtml, Object ... lines) {
        this(isHtml, Arrays.asList(lines));
    }

    public void addLineObject(Object line) {
        this.lines.add(line);
    }

    public void addNewLine() {
        this.lines.add("");
    }

    @Override
    public String toLocalizedString(ULocale locale) {
        StringBuilder builder = new StringBuilder();
        boolean isFirstLine = true;
        for (Object line : this.lines) {
            if (isFirstLine) {
                isFirstLine = false;
            } else {
                builder.append(this.isHtml ? "<br>" : "\n");
            }
            if (line instanceof TranslatableComponent) {
                builder.append(((TranslatableComponent)line).toLocalizedString(locale));
                continue;
            }
            builder.append(line.toString());
        }
        return builder.toString();
    }
}

