/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.data.DefaultAndList;
import velox.api.layer1.data.HistoricalDataInfo;
import velox.api.layer1.data.Layer1ApiProviderSupportedFeaturesBuilder;
import velox.api.layer1.data.LookupInfo;
import velox.api.layer1.data.OrderDuration;
import velox.api.layer1.data.OrderType;
import velox.api.layer1.data.ProviderType;
import velox.api.layer1.data.SubscribeInfo;

@Layer1ApiPublic
public class Layer1ApiProviderSupportedFeatures {
    public final boolean trading;
    public ProviderType tradingVia;
    public final boolean oco;
    public final boolean oso;
    public final boolean mbo;
    public final boolean trailingStopsAsIndependentOrders;
    public final boolean trailingStopsAsBracketChildren;
    public final boolean brackets;
    public final boolean convertOrderToMkt;
    public final List<OrderDuration> supportedLimitDurations;
    public final List<OrderDuration> supportedStopDurations;
    public final List<OrderType> supportedStopOrders;
    public final boolean negativeStopLimitOffset;
    public final boolean marketMode;
    public final boolean isBalanceSupported;
    public final boolean tradingStartKnown;
    public final List<SubscribeInfo> knownInstruments;
    public final boolean exchangeUsedForSubscription;
    public final boolean typeUsedForSubscription;
    public final Function<SubscribeInfo, DefaultAndList<Double>> pipsFunction;
    public final Function<SubscribeInfo, DefaultAndList<Double>> sizeMultiplierFunction;
    public final HistoricalDataInfo historicalDataInfo;
    public final LookupInfo lookupInfo;

    public Layer1ApiProviderSupportedFeatures(boolean trading, ProviderType tradingVia, boolean oco, boolean oso, boolean mbo, boolean trailingStopsAsIndependentOrders, boolean trailingStopsAsBracketChildren, boolean brackets, boolean convertOrderToMkt, boolean marketMode, List<OrderDuration> supportedLimitDurations, List<OrderDuration> supportedStopDurations, List<OrderType> supportedStopOrders, boolean negativeStopLimitOffset, boolean isBalanceSupported, boolean tradingStartKnown, List<SubscribeInfo> knownInstruments, boolean exchangeUsedForSubscription, boolean typeUsedForSubscription, Function<SubscribeInfo, DefaultAndList<Double>> pipsFunction, Function<SubscribeInfo, DefaultAndList<Double>> sizeMultiplierFunction, HistoricalDataInfo historicalDataInfo, LookupInfo lookupInfo) {
        this.trading = trading;
        this.tradingVia = tradingVia;
        this.oco = oco;
        this.oso = oso;
        this.mbo = mbo;
        this.trailingStopsAsIndependentOrders = trailingStopsAsIndependentOrders;
        this.trailingStopsAsBracketChildren = trailingStopsAsBracketChildren;
        this.brackets = brackets;
        this.convertOrderToMkt = convertOrderToMkt;
        this.marketMode = marketMode;
        this.supportedLimitDurations = Collections.unmodifiableList(new ArrayList<OrderDuration>(supportedLimitDurations));
        this.supportedStopDurations = Collections.unmodifiableList(new ArrayList<OrderDuration>(supportedStopDurations));
        this.supportedStopOrders = Collections.unmodifiableList(new ArrayList<OrderType>(supportedStopOrders));
        this.negativeStopLimitOffset = negativeStopLimitOffset;
        this.isBalanceSupported = isBalanceSupported;
        this.tradingStartKnown = tradingStartKnown;
        this.knownInstruments = Collections.unmodifiableList(new ArrayList<SubscribeInfo>(knownInstruments));
        this.exchangeUsedForSubscription = exchangeUsedForSubscription;
        this.typeUsedForSubscription = typeUsedForSubscription;
        this.pipsFunction = pipsFunction;
        this.sizeMultiplierFunction = sizeMultiplierFunction;
        this.historicalDataInfo = historicalDataInfo;
        this.lookupInfo = lookupInfo;
    }

    public Layer1ApiProviderSupportedFeatures(boolean trading, ProviderType tradingVia, boolean oco, boolean oso, boolean trailingStopsAsIndependentOrders, boolean trailingStopsAsBracketChildren, boolean brackets, boolean convertOrderToMkt, boolean marketMode, List<OrderDuration> supportedLimitDurations, List<OrderDuration> supportedStopDurations, List<OrderType> supportedStopOrders, boolean negativeStopLimitOffset, boolean isBalanceSupported, boolean tradingStartKnown, List<SubscribeInfo> knownInstruments, boolean exchangeUsedForSubscription, boolean typeUsedForSubscription, Function<SubscribeInfo, DefaultAndList<Double>> pipsFunction, Function<SubscribeInfo, DefaultAndList<Double>> sizeMultiplierFunction, HistoricalDataInfo historicalDataInfo, LookupInfo lookupInfo) {
        this(trading, tradingVia, oco, oso, false, trailingStopsAsIndependentOrders, trailingStopsAsBracketChildren, brackets, convertOrderToMkt, marketMode, supportedLimitDurations, supportedStopDurations, supportedStopOrders, negativeStopLimitOffset, isBalanceSupported, tradingStartKnown, knownInstruments, exchangeUsedForSubscription, typeUsedForSubscription, pipsFunction, sizeMultiplierFunction, historicalDataInfo, lookupInfo);
    }

    public Layer1ApiProviderSupportedFeatures(boolean trading, ProviderType tradingVia, boolean oco, boolean oso, boolean trailingStopsAsIndependentOrders, boolean trailingStopsAsBracketChildren, boolean brackets, boolean convertOrderToMkt, boolean marketMode, List<OrderDuration> supportedLimitDurations, List<OrderDuration> supportedStopDurations, List<OrderType> supportedStopOrders, boolean negativeStopLimitOffset, boolean isBalanceSupported, boolean tradingStartKnown, List<SubscribeInfo> knownInstruments, boolean exchangeUsedForSubscription, boolean typeUsedForSubscription, Function<SubscribeInfo, DefaultAndList<Double>> pipsFunction, Function<SubscribeInfo, DefaultAndList<Double>> sizeMultiplierFunction, HistoricalDataInfo historicalDataInfo) {
        this(trading, tradingVia, oco, oso, trailingStopsAsIndependentOrders, trailingStopsAsBracketChildren, brackets, convertOrderToMkt, marketMode, supportedLimitDurations, supportedStopDurations, supportedStopOrders, negativeStopLimitOffset, isBalanceSupported, tradingStartKnown, knownInstruments, exchangeUsedForSubscription, typeUsedForSubscription, pipsFunction, sizeMultiplierFunction, historicalDataInfo, null);
    }

    public Layer1ApiProviderSupportedFeatures getCopyWithAppliedTradingParams(Layer1ApiProviderSupportedFeatures other) {
        Layer1ApiProviderSupportedFeaturesBuilder builder = other.toBuilder();
        builder.setMarketMode(this.marketMode);
        builder.setTradingVia(this.tradingVia);
        return builder.build();
    }

    public Layer1ApiProviderSupportedFeaturesBuilder toBuilder() {
        Layer1ApiProviderSupportedFeaturesBuilder builder = new Layer1ApiProviderSupportedFeaturesBuilder();
        builder.setTrading(this.trading);
        builder.setTradingVia(this.tradingVia);
        builder.setOco(this.oco);
        builder.setOso(this.oso);
        builder.setMbo(this.mbo);
        builder.setTrailingStopsAsIndependentOrders(this.trailingStopsAsIndependentOrders);
        builder.setTrailingStopsAsBracketChildren(this.trailingStopsAsBracketChildren);
        builder.setBrackets(this.brackets);
        builder.setConvertOrderToMkt(this.convertOrderToMkt);
        builder.setMarketMode(this.marketMode);
        builder.setSupportedLimitDurations(this.supportedLimitDurations);
        builder.setSupportedStopDurations(this.supportedStopDurations);
        builder.setSupportedStopOrders(this.supportedStopOrders);
        builder.setNegativeStopLimitOffset(this.negativeStopLimitOffset);
        builder.setBalanceSupported(this.isBalanceSupported);
        builder.setTradingStartKnown(this.tradingStartKnown);
        builder.setKnownInstruments(this.knownInstruments);
        builder.setExchangeUsedForSubscription(this.exchangeUsedForSubscription);
        builder.setTypeUsedForSubscription(this.typeUsedForSubscription);
        builder.setPipsFunction(this.pipsFunction);
        builder.setSizeMultiplierFunction(this.sizeMultiplierFunction);
        builder.setHistoricalDataInfo(this.historicalDataInfo);
        builder.setLookupInfo(this.lookupInfo);
        return builder;
    }

    public String toString() {
        return "Layer1ApiProviderSupportedFeatures [trading=" + this.trading + ", tradingVia=" + this.tradingVia + ", oco=" + this.oco + ", oso=" + this.oso + ", trailingStopsAsIndependentOrders=" + this.trailingStopsAsIndependentOrders + ", trailingStopsAsBracketChildren=" + this.trailingStopsAsBracketChildren + ", brackets=" + this.brackets + ", convertOrderToMkt=" + this.convertOrderToMkt + ", supportedLimitDurations=" + this.supportedLimitDurations + ", supportedStopDurations=" + this.supportedStopDurations + ", supportedStopOrders=" + this.supportedStopOrders + ", negativeStopLimitOffset=" + this.negativeStopLimitOffset + ", marketMode=" + this.marketMode + "]";
    }
}

