/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.datastructure.events;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.datastructure.events.Event;
import velox.api.layer1.datastructure.events.EventType;

@Layer1ApiPublic
public class MboAggregationEvent
extends Event {
    private static final long serialVersionUID = 1L;
    public Map<String, Order> newOrders = new HashMap<String, Order>();
    public Map<String, PriceSizeUpdate> updates = new HashMap<String, PriceSizeUpdate>();

    public MboAggregationEvent(long time) {
        super(time, EventType.NONE);
    }

    public String toString() {
        return "new: " + this.newOrders.size() + ", updates: " + this.updates.size();
    }

    @Override
    public Object clone() {
        MboAggregationEvent event = new MboAggregationEvent(this.time);
        event.newOrders.putAll(this.newOrders);
        event.updates.putAll(this.updates);
        return event;
    }

    @Layer1ApiPublic
    public static class Order
    extends PriceSizeUpdate {
        private static final long serialVersionUID = 1L;
        public final boolean isBid;

        public Order(boolean isBid, int price, int size) {
            super(price, size);
            this.isBid = isBid;
        }
    }

    @Layer1ApiPublic
    public static class PriceSizeUpdate
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final PriceSizeUpdate REMOVAL = new PriceSizeUpdate(Integer.MIN_VALUE, 0);
        public final int price;
        public final int size;

        public PriceSizeUpdate(int price, int size) {
            this.price = price;
            this.size = size;
        }
    }
}

