/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.common;

import java.util.Date;
import velox.api.layer1.activation.Layer1ApiPublic;

@Layer1ApiPublic
public class Log {
    private static LogListener listener = new SimpleConsoleLogger(0);

    public static void setListener(LogListener listener) {
        Log.listener = listener;
    }

    public static void trade(String message, Exception ex) {
        listener.trade(message, ex);
    }

    public static void trade(String message) {
        listener.trade(message);
    }

    public static void error(String message, Throwable ex) {
        listener.error(message, ex);
    }

    public static void error(String message) {
        listener.error(message);
    }

    public static void warn(String message, Exception ex) {
        listener.warn(message, ex);
    }

    public static void warn(String message) {
        listener.warn(message);
    }

    public static void info(String message, Exception ex) {
        listener.info(message, ex);
    }

    public static void info(String message) {
        listener.info(message);
    }

    public static void debug(String message, Exception ex) {
        listener.debug(message, ex);
    }

    public static void debug(String message) {
        listener.debug(message);
    }

    public static void trace(String message, Exception ex) {
        listener.trace(message, ex);
    }

    public static void trace(String message) {
        listener.trace(message);
    }

    public static class SimpleConsoleLogger
    implements LogListener {
        private final int logLevel;

        public SimpleConsoleLogger(int logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public synchronized void warn(String message) {
            this.printTimeStamp();
            System.err.println(message);
        }

        @Override
        public synchronized void warn(String message, Exception ex) {
            this.printTimeStamp();
            System.err.println(message);
            ex.printStackTrace();
        }

        @Override
        public synchronized void trade(String message) {
            this.printTimeStamp();
            System.err.println(message);
        }

        @Override
        public synchronized void trade(String message, Exception ex) {
            this.printTimeStamp();
            System.err.println(message);
            ex.printStackTrace();
        }

        @Override
        public synchronized void trace(String message) {
            if (this.logLevel <= 0) {
                this.printTimeStamp();
                System.err.println(message);
            }
        }

        @Override
        public synchronized void trace(String message, Exception ex) {
            if (this.logLevel <= 0) {
                this.printTimeStamp();
                System.err.println(message);
                ex.printStackTrace();
            }
        }

        @Override
        public synchronized void info(String message) {
            this.printTimeStamp();
            System.err.println(message);
        }

        @Override
        public synchronized void info(String message, Exception ex) {
            this.printTimeStamp();
            System.err.println(message);
            ex.printStackTrace();
        }

        @Override
        public synchronized void error(String message) {
            this.printTimeStamp();
            System.err.println(message);
        }

        @Override
        public synchronized void error(String message, Throwable ex) {
            this.printTimeStamp();
            System.err.println(message);
            ex.printStackTrace();
        }

        @Override
        public synchronized void debug(String message) {
            if (this.logLevel <= 1) {
                this.printTimeStamp();
                System.err.println(message);
            }
        }

        @Override
        public synchronized void debug(String message, Exception ex) {
            if (this.logLevel <= 1) {
                this.printTimeStamp();
                System.err.println(message);
                ex.printStackTrace();
            }
        }

        private synchronized void printTimeStamp() {
            System.err.print(new Date() + ": ");
        }
    }

    public static interface LogListener {
        public void trade(String var1, Exception var2);

        public void trade(String var1);

        public void error(String var1, Throwable var2);

        public void error(String var1);

        public void warn(String var1, Exception var2);

        public void warn(String var1);

        public void info(String var1, Exception var2);

        public void info(String var1);

        public void debug(String var1, Exception var2);

        public void debug(String var1);

        public void trace(String var1, Exception var2);

        public void trace(String var1);
    }
}

