/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.layers.strategies.interfaces;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.function.Consumer;
import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.exceptionwrapper.Fallback;
import velox.api.layer1.exceptionwrapper.OnlineCalculatableFallback;
import velox.api.layer1.layers.strategies.interfaces.CalculatedResultListener;
import velox.api.layer1.layers.strategies.interfaces.InvalidateInterface;
import velox.api.layer1.layers.strategies.interfaces.OnlineValueCalculatorAdapter;

@Fallback(value=OnlineCalculatableFallback.class)
@Layer1ApiPublic
public interface OnlineCalculatable {
    public void calculateValuesInRange(String var1, String var2, long var3, long var5, int var7, CalculatedResultListener var8);

    public OnlineValueCalculatorAdapter createOnlineValueCalculator(String var1, String var2, long var3, Consumer<Object> var5, InvalidateInterface var6);

    default public boolean allowPartialUpdates(String indicatorName, String alias) {
        return true;
    }

    @Layer1ApiPublic
    public static class ValueBundle {
        public Object value;
        public List<Object> additionalObjects;

        public ValueBundle(Object value, List<Object> additionalObjects) {
            this.value = value;
            this.additionalObjects = additionalObjects;
        }

        public String toString() {
            return "(" + this.value + ", " + (this.additionalObjects == null ? 0 : this.additionalObjects.size()) + " additional entries)";
        }
    }

    @Layer1ApiPublic
    public static class Marker {
        public final double markerY;
        public final int iconOffsetX;
        public final int iconOffsetY;
        public final BufferedImage icon;

        public Marker(double markerY, int iconOffsetX, int iconOffsetY, BufferedImage icon) {
            this.markerY = markerY;
            this.iconOffsetX = iconOffsetX;
            this.iconOffsetY = iconOffsetY;
            this.icon = new BufferedImage(icon.getWidth(), icon.getHeight(), icon.getType());
            Graphics g = this.icon.getGraphics();
            g.drawImage(icon, 0, 0, null);
            g.dispose();
        }

        public String toString() {
            return "Marker [markerY=" + this.markerY + ", iconOffsetX=" + this.iconOffsetX + ", iconOffsetY=" + this.iconOffsetY + ", icon=" + this.icon + "]";
        }
    }
}

