/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.messages;

import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.common.Utils;
import velox.api.layer1.messages.GeneratedEventInfo;
import velox.api.layer1.messages.Layer1ApiIgnorableUpwardMessage;
import velox.api.layer1.messages.indicators.StrategyUpdateGenerator;

@Layer1ApiPublic
public class Layer1ApiUserMessageAddStrategyUpdateGenerator
implements Layer1ApiIgnorableUpwardMessage {
    public final boolean isAdd;
    public final boolean shouldReceiveHistory;
    public final StrategyUpdateGenerator generator;
    public final Class<?> strategyClass;
    public final String generatorName;
    public final String fullName;
    public final GeneratedEventInfo[] info;
    public final boolean isAggregatable;

    public Layer1ApiUserMessageAddStrategyUpdateGenerator(Class<?> strategyClass, String generatorName, boolean isAdd, boolean shouldReceiveHistory, StrategyUpdateGenerator generator, GeneratedEventInfo[] info) {
        this.isAdd = isAdd;
        this.shouldReceiveHistory = shouldReceiveHistory;
        this.generator = generator;
        this.strategyClass = strategyClass;
        this.generatorName = generatorName;
        this.fullName = Utils.getCustomTreeName(strategyClass, (String)generatorName);
        this.info = info;
        boolean isAggregatable = false;
        boolean isNonAggregatable = false;
        for (GeneratedEventInfo eventInfo : info) {
            if (eventInfo.aggregator != null) {
                isAggregatable = true;
                continue;
            }
            isNonAggregatable = true;
        }
        if (isAggregatable && isNonAggregatable) {
            throw new IllegalArgumentException("All events should be either aggregatable (with provided aggregator class), or non aggregatable");
        }
        this.isAggregatable = isAggregatable;
    }
}

