/*
 * Decompiled with CFR 0.152.
 */
package velox.gui.colors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.common.Log;
import velox.api.layer1.common.Utils;
import velox.api.layer1.messages.indicators.IndicatorColorInterface;
import velox.colors.ColorsChangedListener;
import velox.gui.IconHelper;
import velox.gui.colors.ColorUtils;
import velox.gui.colors.ColorsConfigItemCallbacks;
import velox.gui.laf.newbookmap.enums.ButtonSize;
import velox.gui.laf.newbookmap.enums.ButtonType;
import velox.gui.laf.newbookmap.enums.Placement;

@Layer1ApiPublic
public class ColorsConfigItem
extends JPanel {
    private static final JMenuItem EXAMPLE_MENU_ITEM = new JMenuItem("test");
    private static final Color COLOR_POPUP_BG_HOVER = Utils.getUiColor((String)"MenuItem.hover.background");
    private static final Color COLOR_POPUP_BG = Utils.getUiColor((String)"PopupMenu.background");
    private ColorsConfigItemCallbacks callbacks;
    private final Color colorDefault;
    protected Color colorCurrent;
    private final String fullName;
    protected final String text;
    private ColorsChangedListener listener;
    private IndicatorColorInterface indicatorColorInterface;
    private JLabel label;
    private JButton buttonAdjust;
    private JButton buttonPick;
    private JButton buttonRestore;
    private JPanel backgroundPanel;
    private ColorsChangedListener colorsChangedListener;

    public String getColorConfigName() {
        return this.fullName;
    }

    public Color getColor() {
        return this.colorCurrent;
    }

    public ColorsConfigItem(Color currentColor, Color defaultColor, Consumer<Color> colorChangedListener) {
        this(currentColor, defaultColor, null, colorChangedListener);
    }

    public ColorsConfigItem(final Color currentColor, Color defaultColor, String label, final Consumer<Color> colorChangedListener) {
        this(null, label, label != null, defaultColor, new IndicatorColorInterface(){
            List<ColorsChangedListener> colorsChangedListeners = new CopyOnWriteArrayList<ColorsChangedListener>();
            Color color = currentColor;

            @Override
            public void set(String name, Color color) {
                this.color = color;
                colorChangedListener.accept(color);
                this.colorsChangedListeners.forEach(ColorsChangedListener::onColorsChanged);
            }

            @Override
            public Color getOrDefault(String name, Color defaultValue) {
                return this.color;
            }

            @Override
            public void addColorChangeListener(ColorsChangedListener listener) {
                this.colorsChangedListeners.add(listener);
            }
        }, () -> {});
    }

    public ColorsConfigItem(String fullName, String text, boolean showLabel, Color defaultColor, IndicatorColorInterface indicatorColorInterface, ColorsChangedListener listener) {
        this(fullName, text, showLabel, defaultColor, indicatorColorInterface, listener, null, false);
    }

    public ColorsConfigItem(String fullName, String text, boolean showLabel, Color defaultColor, IndicatorColorInterface indicatorColorInterface, ColorsChangedListener listener, ColorsConfigItemCallbacks callbacks, boolean styleAsMenuItem) {
        this(fullName, text, showLabel, defaultColor, indicatorColorInterface, listener, callbacks, styleAsMenuItem, null);
    }

    public ColorsConfigItem(String fullName, String text, Color defaultColor, IndicatorColorInterface indicatorColorInterface, ColorsChangedListener listener) {
        this(fullName, text, true, defaultColor, indicatorColorInterface, listener);
    }

    public ColorsConfigItem(String text, Color defaultColor, IndicatorColorInterface indicatorColorInterface, ColorsChangedListener listener) {
        this(text, text, defaultColor, indicatorColorInterface, listener);
    }

    public ColorsConfigItem(String fullName, String text, boolean showLabel, Color defaultColor, IndicatorColorInterface indicatorColorInterface, ColorsChangedListener listener, ColorsConfigItemCallbacks callbacks, boolean styleAsMenuItem, Insets insets) {
        this.listener = listener;
        this.indicatorColorInterface = indicatorColorInterface;
        this.fullName = fullName;
        this.text = text;
        this.callbacks = callbacks;
        this.colorDefault = new Color(defaultColor.getRGB(), true);
        if (indicatorColorInterface != null) {
            this.colorCurrent = indicatorColorInterface.getOrDefault(fullName, defaultColor);
        }
        if (this.colorCurrent == null) {
            this.colorCurrent = new Color(defaultColor.getRGB(), true);
        }
        this.initLayout(showLabel, styleAsMenuItem, insets);
        if (indicatorColorInterface != null) {
            indicatorColorInterface.set(fullName, this.colorCurrent);
            this.colorsChangedListener = () -> {
                this.colorCurrent = indicatorColorInterface.getOrDefault(fullName, defaultColor);
                this.onCurrentColorChanged();
            };
            indicatorColorInterface.addColorChangeListener(this.colorsChangedListener);
        }
        if (styleAsMenuItem) {
            this.backgroundPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ColorsConfigItem.this.backgroundPanel.setBackground(COLOR_POPUP_BG_HOVER);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!ColorsConfigItem.this.getVisibleRect().contains(e.getPoint())) {
                        ColorsConfigItem.this.backgroundPanel.setBackground(COLOR_POPUP_BG);
                    }
                }
            });
        }
    }

    private void initLayout(boolean showLabel, boolean styleAsMenuItem, Insets initInsets) {
        if (showLabel) {
            this.label = new JLabel(this.text);
            if (!styleAsMenuItem) {
                this.label.setPreferredSize(new Dimension(250, this.label.getPreferredSize().height));
            }
        }
        this.buttonAdjust = new Utils.SmallButton("");
        this.buttonAdjust.setBackground(ColorsConfigItem.removeTransparency(this.colorCurrent));
        this.buttonPick = ColorUtils.createColorPickButton((ColorUtils.SetColorCallback)new ColorUtils.SetColorCallback(){

            public void setColor(Color color) {
                ColorsConfigItem.this.setColor(color, true);
            }
        });
        this.buttonRestore = new Utils.SmallButton(this.getRestoreIcon());
        this.setLayout(new BorderLayout());
        this.buttonRestore.putClientProperty(Placement.class, Placement.COLORS_CONFIG);
        this.buttonRestore.putClientProperty(ButtonType.class, ButtonType.COLORS_ROUND);
        this.buttonRestore.setPreferredSize(ButtonSize.BUTTONS_WITH_ICONS_SIZE);
        this.buttonPick.putClientProperty(Placement.class, Placement.COLORS_CONFIG);
        this.buttonPick.putClientProperty(ButtonType.class, ButtonType.COLORS_ROUND);
        this.buttonPick.setPreferredSize(ButtonSize.BUTTONS_WITH_ICONS_SIZE);
        this.buttonAdjust.putClientProperty(Placement.class, Placement.COLORS_CONFIG);
        this.buttonAdjust.putClientProperty(ButtonType.class, ButtonType.COLORS_OVAL);
        this.buttonAdjust.setPreferredSize(styleAsMenuItem ? ButtonSize.BUTTONS_WITH_ICONS_SIZE : ButtonSize.BUTTONS_OVAL_SIZE);
        this.backgroundPanel = new JPanel(new GridBagLayout());
        Insets insets = initInsets == null ? (styleAsMenuItem ? EXAMPLE_MENU_ITEM.getInsets() : new Insets(5, 10, 5, 10)) : initInsets;
        int insetsRight = insets.right;
        if (styleAsMenuItem) {
            insets.right = 4;
        }
        int x = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = x++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 1.0;
        if (this.label != null) {
            this.backgroundPanel.add((Component)this.label, gridBagConstraints);
            if (styleAsMenuItem) {
                insets.left = 2;
            }
        }
        gridBagConstraints.gridx = x++;
        gridBagConstraints.weightx = 0.0;
        this.backgroundPanel.add((Component)this.buttonAdjust, gridBagConstraints);
        gridBagConstraints.gridx = x++;
        this.backgroundPanel.add((Component)this.buttonPick, gridBagConstraints);
        gridBagConstraints.gridx = x;
        if (styleAsMenuItem) {
            insets.right = insetsRight;
        }
        this.backgroundPanel.add((Component)this.buttonRestore, gridBagConstraints);
        ++x;
        this.add(this.backgroundPanel);
        this.buttonAdjust.addActionListener(e -> this.onAdjust());
        this.buttonRestore.addActionListener(e -> this.onRestore(true));
        if (styleAsMenuItem) {
            this.backgroundPanel.setBackground(COLOR_POPUP_BG);
        }
    }

    private static Color removeTransparency(Color color) {
        return new Color(color.getRGB(), false);
    }

    public void setColor(Color color, boolean call) {
        if (color != null) {
            this.colorCurrent = color;
            this.onCurrentColorChanged();
            if (this.indicatorColorInterface != null) {
                this.indicatorColorInterface.set(this.fullName, color);
            }
            if (call) {
                this.listener.onColorsChanged();
            }
        }
    }

    public void onCurrentColorChanged() {
        this.buttonAdjust.setBackground(ColorsConfigItem.removeTransparency(this.colorCurrent));
    }

    protected void onAdjust() {
        if (this.callbacks != null) {
            this.callbacks.onColorSelectionItemClicked();
        }
        Color newColor = JColorChooser.showDialog(this, "Choose " + this.text + " color", this.colorCurrent);
        this.setColor(newColor, true);
    }

    public void onRestore(boolean call) {
        this.setColor(new Color(this.colorDefault.getRGB(), true), call);
    }

    private ImageIcon getRestoreIcon() {
        ImageIcon icon = null;
        try {
            icon = new ImageIcon(IconHelper.loadImageBw((String)"resources/icons/newBookmapLAF/restore.png", (boolean)false));
        }
        catch (IOException ex) {
            Log.error("Fail to load icon", ex);
        }
        return icon;
    }

    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.buttonAdjust.setEnabled(enabled);
        this.buttonPick.setEnabled(enabled);
        this.buttonRestore.setEnabled(enabled);
    }
}

