/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.messages.indicators;

import java.awt.Color;
import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.exceptionwrapper.Fallback;
import velox.api.layer1.exceptionwrapper.IndicatorColorSchemeFallback;

@Fallback(value=IndicatorColorSchemeFallback.class)
@Layer1ApiPublic
public interface IndicatorColorScheme {
    public static String getColorFullName(String userName, Class<?> strategyClass) {
        return strategyClass.getCanonicalName() + "." + userName;
    }

    public ColorDescription[] getColors();

    public String getColorFor(Double var1);

    public ColorIntervalResponse getColorIntervalsList(double var1, double var3);

    default public String getMainColorName() {
        return this.getColors()[0].name;
    }

    default public Color getDefaultColor() {
        return this.getColors()[0].defaultColor;
    }

    @Layer1ApiPublic
    public static class ColorIntervalResponse {
        public final String[] colors;
        public final double[] dots;

        public ColorIntervalResponse(String[] colors, double[] dots) {
            if (colors.length - 1 != dots.length) {
                throw new IllegalArgumentException("colors.size() - 1 != dots.size() " + colors.length + " " + dots.length);
            }
            this.colors = colors;
            this.dots = dots;
        }
    }

    @Layer1ApiPublic
    public static class ColorDescription {
        public final Color defaultColor;
        public final String name;
        public final boolean isDisplayedInColorDialog;

        public ColorDescription(Class<?> strategyClass, String name, Color defaultColor, boolean isDisplayedInColorDialog) {
            if (name.length() <= 0) {
                throw new IllegalArgumentException("Color name " + name + " is illegal. Check javadoc.");
            }
            this.name = name;
            this.defaultColor = defaultColor;
            this.isDisplayedInColorDialog = isDisplayedInColorDialog;
        }
    }
}

