/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.messages;

import java.time.Duration;
import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.common.Utils;
import velox.api.layer1.layers.Layer1ApiStrategiesEchoMessagesLayer;

@Layer1ApiPublic
public class Layer1ApiSoundAlertMessage
implements Layer1ApiStrategiesEchoMessagesLayer.StrategyEchoMessageFromLayer {
    public static final long REPEAT_COUNT_INFINITE = Long.MAX_VALUE;
    public final byte[] sound;
    public final String textInfo;
    public final long repeatCount;
    public final Duration repeatDelay;
    public final String alertId;
    public final SoundAlertStatusListener statusListener;
    public final Class<?> source;
    public final Object metadata;

    public Layer1ApiSoundAlertMessage(byte[] sound, String textInfo, long repeatCount, Duration repeatDelay, SoundAlertStatusListener statusListener, Class<?> source, Object metadata) {
        this.sound = sound;
        this.textInfo = textInfo;
        this.repeatCount = repeatCount;
        this.repeatDelay = repeatDelay;
        this.alertId = Utils.generateShortUuid();
        this.statusListener = statusListener;
        this.source = source;
        this.metadata = metadata;
    }

    public Layer1ApiSoundAlertMessage(String alertId) {
        this.sound = null;
        this.textInfo = null;
        this.repeatCount = 0L;
        this.repeatDelay = null;
        this.alertId = alertId;
        this.statusListener = (a, s) -> {};
        this.source = null;
        this.metadata = null;
    }

    public String toString() {
        return "Layer1ApiSoundAlertMessage [textInfo=" + this.textInfo + ", alertId=" + this.alertId + "]";
    }

    @FunctionalInterface
    @Layer1ApiPublic
    public static interface SoundAlertStatusListener {
        public void onSoundAlertStatus(String var1, SoundAlertStatus var2);
    }

    @Layer1ApiPublic
    public static enum SoundAlertStatus {
        PENDING,
        PLAYING,
        DONE;

    }
}

