/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.common;

import java.util.concurrent.TimeUnit;
import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.common.Log;
import velox.api.layer1.common.Utils;

@Layer1ApiPublic
public class NanoClock {
    private static final long ADJUSTMENT_STEP_MS = 50L;
    private static final int ADJUSTMENT_BACK_SAFETY_INTERVAL = 5;
    private static final long RAPID_FORWARD_ADJUSTMENT_THRESHOLD_MS = TimeUnit.MINUTES.toMillis(1L);
    private static long nanoOffset;
    private static long stopUntil;
    private static long stopValue;
    private static final Object monitor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long currentTimeNanos() {
        Object object = monitor;
        synchronized (object) {
            long nanoTime = System.nanoTime();
            if (stopUntil > nanoTime) {
                return stopValue;
            }
            return nanoOffset + nanoTime;
        }
    }

    static {
        stopUntil = 0L;
        stopValue = 0L;
        monitor = new Object();
        nanoOffset = System.currentTimeMillis() * 1000000L - System.nanoTime();
        Thread thread = Utils.constructThread(() -> {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                        Object object = monitor;
                        synchronized (object) {
                            long msOffset = System.currentTimeMillis() - NanoClock.currentTimeNanos() / 1000000L;
                            if (msOffset > 50L) {
                                if (msOffset > RAPID_FORWARD_ADJUSTMENT_THRESHOLD_MS) {
                                    nanoOffset += msOffset * 1000000L;
                                    Log.debug("moving NanoClock forward rapidly to match current time");
                                } else {
                                    nanoOffset += 50000000L;
                                    Log.debug("moving NanoClock 50ms forward");
                                }
                                stopUntil = 0L;
                            } else if (msOffset < -50L) {
                                stopValue = NanoClock.currentTimeNanos();
                                stopUntil = System.nanoTime() + 55000000L;
                                nanoOffset -= 50000000L;
                                Log.debug("moving NanoClock 50ms back");
                            }
                        }
                    }
                }
                catch (InterruptedException ex) {
                    Log.error(ex.toString());
                    continue;
                }
                break;
            }
        });
        thread.setDaemon(true);
        thread.start();
    }
}

