/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.layers;

import velox.api.layer1.Layer1ApiListener;
import velox.api.layer1.Layer1ApiProvider;
import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.common.ListenableHelper;
import velox.api.layer1.data.Layer1ApiProviderSupportedFeatures;
import velox.api.layer1.data.LoginData;
import velox.api.layer1.data.OrderSendParameters;
import velox.api.layer1.data.OrderUpdateParameters;
import velox.api.layer1.data.SubscribeInfo;
import velox.api.layer1.layers.Layer1ApiTimeSource;
import velox.api.layer1.layers.Layer1ApiUpstreamRelay;

@Layer1ApiPublic
public class Layer1ApiRelay
extends Layer1ApiUpstreamRelay
implements Layer1ApiProvider,
Layer1ApiListener,
Layer1ApiTimeSource {
    protected Layer1ApiProvider provider;
    private Layer1ApiProvider timeSource;

    public Layer1ApiRelay(Layer1ApiProvider provider) {
        this(provider, true);
    }

    protected void setProvider(Layer1ApiProvider provider) {
        this.provider = provider;
        this.timeSource = provider == null ? null : this.getTimeSource();
    }

    protected Layer1ApiRelay(Layer1ApiProvider provider, boolean subscribeToProvider) {
        this.setProvider(provider);
        if (subscribeToProvider) {
            ListenableHelper.addListeners(provider, (Object)this);
        }
    }

    @Override
    public String formatPrice(String alias, double price) {
        return this.provider.formatPrice(alias, price);
    }

    @Override
    public void subscribe(SubscribeInfo subscribeInfo) {
        this.provider.subscribe(subscribeInfo);
    }

    @Override
    public void unsubscribe(String alias) {
        this.provider.unsubscribe(alias);
    }

    @Override
    public void sendOrder(OrderSendParameters orderSendParameters) {
        this.provider.sendOrder(orderSendParameters);
    }

    @Override
    public void updateOrder(OrderUpdateParameters orderUpdateParameters) {
        this.provider.updateOrder(orderUpdateParameters);
    }

    @Override
    public void login(LoginData loginData) {
        this.provider.login(loginData);
    }

    @Override
    @Layer1ApiTimeSource.Layer1TimeSourceShortcutAllowed
    public long getCurrentTime() {
        return this.timeSource.getCurrentTime();
    }

    @Override
    public void close() {
        super.close();
        this.provider.close();
    }

    @Override
    public String getSource() {
        return this.provider.getSource();
    }

    @Override
    public Object sendUserMessage(Object data) {
        return this.provider.sendUserMessage(data);
    }

    @Override
    public Layer1ApiProviderSupportedFeatures getSupportedFeatures() {
        return this.provider.getSupportedFeatures();
    }

    @Override
    public Layer1ApiProvider getTimeSource() {
        return Layer1ApiTimeSource.getTimeSource(this.provider);
    }
}

