/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.layers;

import java.util.concurrent.atomic.AtomicBoolean;
import velox.api.layer1.Layer1ApiAdminListener;
import velox.api.layer1.Layer1ApiBasicListenable;
import velox.api.layer1.Layer1ApiDataListener;
import velox.api.layer1.Layer1ApiInstrumentListener;
import velox.api.layer1.Layer1ApiListener;
import velox.api.layer1.Layer1ApiMboDataListener;
import velox.api.layer1.Layer1ApiTradingListener;
import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.data.BalanceInfo;
import velox.api.layer1.data.DisconnectionReason;
import velox.api.layer1.data.ExecutionInfo;
import velox.api.layer1.data.InstrumentInfo;
import velox.api.layer1.data.LoginFailedReason;
import velox.api.layer1.data.MarketMode;
import velox.api.layer1.data.OrderInfoUpdate;
import velox.api.layer1.data.StatusInfo;
import velox.api.layer1.data.SystemTextMessageType;
import velox.api.layer1.data.TradeInfo;

@Layer1ApiPublic
public class Layer1ApiUpstreamRelay
extends Layer1ApiBasicListenable
implements Layer1ApiListener {
    protected AtomicBoolean closed = new AtomicBoolean();

    @Override
    public void onInstrumentAdded(String alias, InstrumentInfo instrumentInfo) {
        for (Layer1ApiInstrumentListener listener : this.instrumentListeners) {
            if (this.closed.get()) continue;
            listener.onInstrumentAdded(alias, instrumentInfo);
        }
    }

    @Override
    public void onInstrumentRemoved(String alias) {
        for (Layer1ApiInstrumentListener listener : this.instrumentListeners) {
            if (this.closed.get()) continue;
            listener.onInstrumentRemoved(alias);
        }
    }

    @Override
    public void onInstrumentNotFound(String symbol, String exchange, String type) {
        for (Layer1ApiInstrumentListener listener : this.instrumentListeners) {
            if (this.closed.get()) continue;
            listener.onInstrumentNotFound(symbol, exchange, type);
        }
    }

    @Override
    public void onInstrumentAlreadySubscribed(String symbol, String exchange, String type) {
        for (Layer1ApiInstrumentListener listener : this.instrumentListeners) {
            if (this.closed.get()) continue;
            listener.onInstrumentAlreadySubscribed(symbol, exchange, type);
        }
    }

    @Override
    public void onTrade(String alias, double price, int size, TradeInfo tradeInfo) {
        for (Layer1ApiDataListener listener : this.dataListeners) {
            if (this.closed.get()) continue;
            listener.onTrade(alias, price, size, tradeInfo);
        }
    }

    @Override
    public void onDepth(String alias, boolean isBid, int price, int size) {
        for (Layer1ApiDataListener listener : this.dataListeners) {
            if (this.closed.get()) continue;
            listener.onDepth(alias, isBid, price, size);
        }
    }

    @Override
    public void onMboSend(String alias, String orderId, boolean isBid, int price, int size) {
        for (Layer1ApiMboDataListener listener : this.mboDataListeners) {
            if (this.closed.get()) continue;
            listener.onMboSend(alias, orderId, isBid, price, size);
        }
    }

    @Override
    public void onMboReplace(String alias, String orderId, int price, int size) {
        for (Layer1ApiMboDataListener listener : this.mboDataListeners) {
            if (this.closed.get()) continue;
            listener.onMboReplace(alias, orderId, price, size);
        }
    }

    @Override
    public void onMboCancel(String alias, String orderId) {
        for (Layer1ApiMboDataListener listener : this.mboDataListeners) {
            if (this.closed.get()) continue;
            listener.onMboCancel(alias, orderId);
        }
    }

    @Override
    public void onMarketMode(String alias, MarketMode marketMode) {
        for (Layer1ApiDataListener listener : this.dataListeners) {
            if (this.closed.get()) continue;
            listener.onMarketMode(alias, marketMode);
        }
    }

    @Override
    public void onOrderUpdated(OrderInfoUpdate orderInfoUpdate) {
        for (Layer1ApiTradingListener listener : this.tradingListeners) {
            if (this.closed.get()) continue;
            listener.onOrderUpdated(orderInfoUpdate);
        }
    }

    @Override
    public void onOrderExecuted(ExecutionInfo executionInfo) {
        for (Layer1ApiTradingListener listener : this.tradingListeners) {
            if (this.closed.get()) continue;
            listener.onOrderExecuted(executionInfo);
        }
    }

    @Override
    public void onStatus(StatusInfo statusInfo) {
        for (Layer1ApiTradingListener listener : this.tradingListeners) {
            if (this.closed.get()) continue;
            listener.onStatus(statusInfo);
        }
    }

    @Override
    public void onBalance(BalanceInfo balanceInfo) {
        for (Layer1ApiTradingListener listener : this.tradingListeners) {
            if (this.closed.get()) continue;
            listener.onBalance(balanceInfo);
        }
    }

    @Override
    public void onLoginFailed(LoginFailedReason reason, String message) {
        for (Layer1ApiAdminListener listener : this.adminListeners) {
            if (this.closed.get()) continue;
            listener.onLoginFailed(reason, message);
        }
    }

    @Override
    public void onLoginSuccessful() {
        for (Layer1ApiAdminListener listener : this.adminListeners) {
            if (this.closed.get()) continue;
            listener.onLoginSuccessful();
        }
    }

    @Override
    public void onConnectionLost(DisconnectionReason reason, String message) {
        for (Layer1ApiAdminListener listener : this.adminListeners) {
            if (this.closed.get()) continue;
            listener.onConnectionLost(reason, message);
        }
    }

    @Override
    public void onConnectionRestored() {
        for (Layer1ApiAdminListener listener : this.adminListeners) {
            if (this.closed.get()) continue;
            listener.onConnectionRestored();
        }
    }

    @Override
    public void onSystemTextMessage(String message, SystemTextMessageType messageType) {
        for (Layer1ApiAdminListener listener : this.adminListeners) {
            if (this.closed.get()) continue;
            listener.onSystemTextMessage(message, messageType);
        }
    }

    @Override
    public void onUserMessage(Object data) {
        for (Layer1ApiAdminListener listener : this.adminListeners) {
            if (this.closed.get()) continue;
            listener.onUserMessage(data);
        }
    }

    public void close() {
        this.closed.set(true);
    }
}

