/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.layers.utils.mbo;

import java.util.Collections;
import java.util.HashMap;
import java.util.TreeMap;
import velox.api.layer1.Layer1ApiMboDataAdapter;
import velox.api.layer1.Layer1ApiMboDataListener;
import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.layers.utils.mbo.Order;
import velox.api.layer1.layers.utils.mbo.PriceLevel;

@Layer1ApiPublic
public class OrderBookMbo {
    private final TreeMap<Integer, PriceLevel> bidsMbo = new TreeMap(Collections.reverseOrder());
    private final TreeMap<Integer, PriceLevel> asksMbo = new TreeMap();
    private final HashMap<String, Order> orders = new HashMap();

    public OrderBookMbo() {
    }

    public OrderBookMbo(OrderBookMbo other) {
        other.sendDataToListener(null, new Layer1ApiMboDataAdapter(){

            @Override
            public void onMboSend(String alias, String orderId, boolean isBid, int price, int size) {
                OrderBookMbo.this.send(orderId, isBid, price, size);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDataToListener(String alias, Layer1ApiMboDataListener listener) {
        HashMap<String, Order> hashMap = this.orders;
        synchronized (hashMap) {
            this.sendDataToListener(alias, listener, this.bidsMbo);
            this.sendDataToListener(alias, listener, this.asksMbo);
        }
    }

    private void sendDataToListener(String alias, Layer1ApiMboDataListener listener, TreeMap<Integer, PriceLevel> book) {
        for (PriceLevel priceLevel : book.values()) {
            for (Order order : priceLevel.getOrders()) {
                listener.onMboSend(alias, order.getOrderId(), order.isBid(), order.getPrice(), order.getSize());
            }
        }
    }

    public boolean isEmpty() {
        return this.bidsMbo.isEmpty() || this.asksMbo.isEmpty();
    }

    public int getBestBidPrice() {
        return this.bidsMbo.firstKey();
    }

    public int getBestAskPrice() {
        return this.asksMbo.firstKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String orderId, boolean isBid, int price, int size) {
        HashMap<String, Order> hashMap = this.orders;
        synchronized (hashMap) {
            this.addOrder(new Order(orderId, isBid, price, size));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(String orderId, int price, int size) {
        HashMap<String, Order> hashMap = this.orders;
        synchronized (hashMap) {
            Order order = this.orders.get(orderId);
            if (order == null) {
                throw new IllegalArgumentException("Order " + orderId + " does not exist");
            }
            if (order.getPrice() == price && order.getSize() > size) {
                order.setSize(size);
            } else {
                this.removeOrder(orderId);
                order.setPrice(price);
                order.setSize(size);
                this.addOrder(order);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(String orderId) {
        HashMap<String, Order> hashMap = this.orders;
        synchronized (hashMap) {
            this.removeOrder(orderId);
        }
    }

    private void addOrder(Order order) {
        Order previousOrder = this.orders.put(order.getOrderId(), order);
        if (previousOrder != null) {
            throw new IllegalArgumentException("Order " + order.getOrderId() + " already exists");
        }
        TreeMap<Integer, PriceLevel> book = order.isBid() ? this.bidsMbo : this.asksMbo;
        PriceLevel priceLevel = (PriceLevel)book.get(order.getPrice());
        if (priceLevel == null) {
            priceLevel = new PriceLevel();
            book.put(order.getPrice(), priceLevel);
        }
        priceLevel.add(order);
    }

    private void removeOrder(String orderId) {
        Order order = this.orders.remove(orderId);
        if (order == null) {
            throw new IllegalArgumentException("Order " + orderId + " does not exist");
        }
        TreeMap<Integer, PriceLevel> book = order.isBid() ? this.bidsMbo : this.asksMbo;
        PriceLevel priceLevel = (PriceLevel)book.get(order.getPrice());
        priceLevel.remove(order);
        if (priceLevel.isEmpty()) {
            book.remove(order.getPrice());
        }
    }

    public Order getOrder(String orderId) {
        return this.orders.get(orderId);
    }
}

