/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.utils;

import java.math.BigDecimal;
import java.util.Map;
import java.util.stream.Collectors;
import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.layers.strategies.interfaces.Layer1PriceAxisRangeCalculatable;
import velox.api.layer1.utils.CalculatePricesResult;

@Layer1ApiPublic
public class PriceRangeCalculationHelper {
    private static final double EPS = 1.0E-10;
    public static final int[] PRICES_STEPS_MULTIPLIERS = new int[]{1, 2, 5, 10, 25, 50};
    public static final int MAX_POSITIVE_PRICES_STEPS_MULTIPLIER_POWER = 4;
    public static final int MAX_NEGATIVE_PRICES_STEPS_MULTIPLIER_POWER = 4;
    private static double[] pricesSteps;

    public PriceRangeCalculationHelper() {
        PriceRangeCalculationHelper.calculateAvailablePricesSteps();
    }

    private static void calculateAvailablePricesSteps() {
        int i;
        int powerStep;
        int currentIndex = 0;
        double[] tmpSteps = new double[PRICES_STEPS_MULTIPLIERS.length * 4];
        int power = 1;
        for (powerStep = 0; powerStep < 4; ++powerStep) {
            for (i = 0; i < PRICES_STEPS_MULTIPLIERS.length; ++i) {
                tmpSteps[currentIndex] = power * PRICES_STEPS_MULTIPLIERS[i];
                ++currentIndex;
            }
            power *= 100;
        }
        pricesSteps = new double[PRICES_STEPS_MULTIPLIERS.length * 8];
        currentIndex = 0;
        for (int i2 = tmpSteps.length - 1; i2 >= 0; --i2) {
            PriceRangeCalculationHelper.pricesSteps[currentIndex++] = 1.0 / tmpSteps[i2];
        }
        power = 1;
        for (powerStep = 0; powerStep < 4; ++powerStep) {
            for (i = 0; i < PRICES_STEPS_MULTIPLIERS.length; ++i) {
                PriceRangeCalculationHelper.pricesSteps[currentIndex] = power * PRICES_STEPS_MULTIPLIERS[i];
                ++currentIndex;
            }
            power *= 100;
        }
    }

    public static Layer1PriceAxisRangeCalculatable.ResultPriceAxisInfo getGoodNumbersCalculation(double minValue, double maxValue, double linesCount) {
        CalculatePricesResult calculatePricesResult = PriceRangeCalculationHelper.getGoodNumbersPriceResult(minValue, maxValue, linesCount);
        if (calculatePricesResult != null) {
            return new Layer1PriceAxisRangeCalculatable.ResultPriceAxisInfo(calculatePricesResult.firstValue, calculatePricesResult.lastValue, calculatePricesResult.labels);
        }
        return new Layer1PriceAxisRangeCalculatable.ResultPriceAxisInfo(minValue, maxValue, new String[0]);
    }

    public static Map<String, Layer1PriceAxisRangeCalculatable.ResultPriceAxisInfo> getGoodNumbersCalculation(double linesCount, Map<String, Layer1PriceAxisRangeCalculatable.InputPriceAxisInfo> inputInfo) {
        return inputInfo.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> PriceRangeCalculationHelper.getGoodNumbersCalculation(((Layer1PriceAxisRangeCalculatable.InputPriceAxisInfo)e.getValue()).minValue, ((Layer1PriceAxisRangeCalculatable.InputPriceAxisInfo)e.getValue()).maxValue, linesCount)));
    }

    public static CalculatePricesResult getGoodNumbersPriceResult(double minValue, double maxValue, double linesCount) {
        CalculatePricesResult calculatePricesResult = null;
        for (int goodNumberStep = 1; goodNumberStep <= (int)linesCount; ++goodNumberStep) {
            for (int startingLine = 0; startingLine < goodNumberStep; ++startingLine) {
                CalculatePricesResult currentResult = PriceRangeCalculationHelper.getCalculatePricesResultOrNull(goodNumberStep, startingLine, minValue, maxValue, linesCount);
                if (currentResult == null || !currentResult.isBetterThan(calculatePricesResult)) continue;
                calculatePricesResult = currentResult;
            }
        }
        return calculatePricesResult;
    }

    private static CalculatePricesResult getCalculatePricesResultOrNull(int goodNumberStep, int startingLine, double minValue, double maxValue, double linesAtScreen) {
        if (startingLine + goodNumberStep > (int)linesAtScreen || startingLine == 0 && startingLine + 2 * goodNumberStep > (int)linesAtScreen) {
            return null;
        }
        for (int priceStepIndex = 0; priceStepIndex < pricesSteps.length; ++priceStepIndex) {
            double valueTop;
            double priceStep = pricesSteps[priceStepIndex];
            double value0 = priceStep - (double)startingLine / (double)goodNumberStep * priceStep;
            double y = minValue - value0;
            long x = 0L;
            x = y < 0.0 ? -((long)(-1.0 * y / priceStep) + 1L) : (long)(y / priceStep);
            if ((value0 += (double)x * priceStep) + priceStep < minValue) {
                value0 += priceStep;
            }
            if (!((valueTop = value0 + priceStep * linesAtScreen / (double)goodNumberStep) > maxValue)) continue;
            CalculatePricesResult result = new CalculatePricesResult();
            result.multiplier = priceStep / (double)goodNumberStep;
            result.priceStep = priceStep;
            result.firstValue = value0;
            result.lastValue = valueTop;
            result.emptyBottom = Math.abs(minValue - value0);
            result.emptyTop = Math.abs(maxValue - valueTop);
            int numberOfLines = (int)(linesAtScreen + 1.0E-10);
            double currentPrice = value0;
            result.labels = new String[numberOfLines];
            for (int i = 0; i < numberOfLines; ++i) {
                result.labels[i] = (i + 1) % goodNumberStep == startingLine ? PriceRangeCalculationHelper.formatPriceNumber(currentPrice += result.multiplier, priceStepIndex) : "";
            }
            return result;
        }
        return null;
    }

    private static String formatPriceNumber(double value, int priceStepIndex) {
        if (priceStepIndex >= PRICES_STEPS_MULTIPLIERS.length * 4) {
            return "" + Math.round(value);
        }
        BigDecimal bigDecimal = new BigDecimal(value);
        int digitsAfterPointNumber = (4 * PRICES_STEPS_MULTIPLIERS.length - priceStepIndex - 2) / 3 + 1;
        bigDecimal = bigDecimal.setScale(digitsAfterPointNumber, 4);
        return bigDecimal.toPlainString();
    }
}

