/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer0.credentialscomponents;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.ObjectUtils;
import velox.api.layer0.credentialscomponents.BaseCredentialsComponent;
import velox.api.layer0.credentialscomponents.CredentialsComponentTextCheckable;
import velox.api.layer0.credentialscomponents.CredentialsSerializationField;
import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.gui.StatusIconTextField;

@Layer1ApiPublic
public class CredentialsTextField
extends BaseCredentialsComponent
implements CredentialsComponentTextCheckable {
    protected String defaultValue;
    protected boolean isHidden;
    protected JTextField textField;
    protected StatusIconTextField statusIconTextField;

    public CredentialsTextField(String name, boolean isKey, String label, boolean isHidden) {
        this(name, isKey, label, isHidden, null);
    }

    public CredentialsTextField(String name, boolean isKey, String label, boolean isHidden, String defaultValue) {
        super(name, isKey);
        this.isHidden = isHidden;
        this.defaultValue = defaultValue;
        this.initialize(label, isHidden);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultText(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    private void initialize(String label, boolean isHidden) {
        if (label != null) {
            this.components.add(new JLabel(label));
        }
        JTextField jTextField = this.textField = isHidden ? new JPasswordField() : new JTextField();
        if (this.defaultValue != null) {
            this.textField.setText(this.defaultValue);
        }
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                CredentialsTextField.this.onStatusChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CredentialsTextField.this.onStatusChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CredentialsTextField.this.onStatusChanged();
            }
        });
        this.statusIconTextField = new StatusIconTextField(this.textField);
        this.components.add(this.statusIconTextField);
    }

    @Override
    public Map<String, CredentialsSerializationField> getValues() {
        HashMap<String, CredentialsSerializationField> fields = new HashMap<String, CredentialsSerializationField>();
        String value = this.getValue();
        fields.put(this.name, new CredentialsSerializationField(this.isKey, this.isHidden, value));
        return fields;
    }

    @Override
    public void setValues(Map<String, CredentialsSerializationField> serializedFields) {
        CredentialsSerializationField field = serializedFields.get(this.name);
        if (field != null) {
            this.textField.setText(field.getStringValue());
        }
    }

    @Override
    public StatusIconTextField[] getStatusIconTextFieldSpacesCheckable() {
        if (!this.isHidden) {
            return new StatusIconTextField[]{this.statusIconTextField};
        }
        return new StatusIconTextField[0];
    }

    @Override
    public StatusIconTextField[] getStatusIconTextFieldCapsLockSpacesCheckable() {
        if (this.isHidden) {
            return new StatusIconTextField[]{this.statusIconTextField};
        }
        return new StatusIconTextField[0];
    }

    public String getValue() {
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{this.textField.getText(), ""});
    }
}

