/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.common;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.SystemUtils;
import velox.api.layer1.activation.Layer1ApiPublic;

@Layer1ApiPublic
public class DirectoryResolver {
    private static final String WORK_DIR = DirectoryResolver.workDir();
    private static final String BOOKMAP_USER_HOME = DirectoryResolver.bookmapUserHome();

    public static Path getBookmapRootDirectory() {
        return Paths.get(BOOKMAP_USER_HOME, new String[0]).toAbsolutePath();
    }

    public static Path getBookmapDirectoryByName(String folderName) {
        return DirectoryResolver.getBookmapRootDirectory().resolve(folderName).toAbsolutePath();
    }

    public static Path getConfigDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Config");
    }

    public static Path getLogsDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Logs");
    }

    public static Path getFeedsDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Feeds");
    }

    public static Path getErrorReportsDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Error reports");
    }

    public static Path getScreenshotsDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Screenshots");
    }

    public static Path getDiagnosticLogsDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Diagnostics logs");
    }

    public static Path getSoundsDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Sounds");
    }

    public static Path getLayer0ApiModulesDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("API").resolve("Layer0ApiModules");
    }

    public static Path getCacheDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Cache");
    }

    public static Path getDataLibraryDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Data library");
    }

    private static String workDir() {
        if (SystemUtils.IS_OS_MAC) {
            Path bookmapWorkDir = Paths.get(System.getProperty("user.home"), new String[0]).resolve("Library/Application Support/Bookmap/Config");
            try {
                Files.createDirectories(bookmapWorkDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return bookmapWorkDir.toString();
        }
        return System.getProperty("user.dir");
    }

    private static String bookmapUserHome() {
        Path workDirPath = Paths.get(WORK_DIR, new String[0]);
        if (workDirPath.endsWith("Config")) {
            return workDirPath.getParent().toAbsolutePath().toString();
        }
        return workDirPath.toAbsolutePath().toString();
    }
}

