/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.data.OrderDuration;
import velox.api.layer1.data.SingleOrderSendParameters;
import velox.api.layer1.utils.IdHelper;

@Layer1ApiPublic
public abstract class AbstractSingleOrderSendParametersBuilder<T extends AbstractSingleOrderSendParametersBuilder<T>> {
    protected String alias;
    protected boolean isBuy;
    protected int size;
    protected OrderDuration duration;
    protected String clientId;

    protected AbstractSingleOrderSendParametersBuilder() {
        this.clientId = IdHelper.generateShortUuid();
    }

    protected AbstractSingleOrderSendParametersBuilder(String alias, boolean isBuy, int size, OrderDuration duration, String clientId) {
        this.alias = alias;
        this.isBuy = isBuy;
        this.size = size;
        this.duration = duration;
        this.clientId = clientId;
    }

    public SingleOrderSendParameters build() {
        return new SingleOrderSendParameters(this.alias, this.isBuy, this.size, this.duration, this.clientId);
    }

    public String getAlias() {
        return this.alias;
    }

    public T setAlias(String alias) {
        this.alias = alias;
        return (T)this;
    }

    public boolean isBuy() {
        return this.isBuy;
    }

    public T setBuy(boolean isBuy) {
        this.isBuy = isBuy;
        return (T)this;
    }

    public int getSize() {
        return this.size;
    }

    public T setSize(int size) {
        this.size = size;
        return (T)this;
    }

    public OrderDuration getDuration() {
        return this.duration;
    }

    public T setDuration(OrderDuration duration) {
        this.duration = duration;
        return (T)this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public T setClientId(String clientId) {
        this.clientId = clientId;
        return (T)this;
    }

    public String toString() {
        return this.getClass() + "{alias=" + this.alias + ", isBuy=" + this.isBuy + ", size=" + this.size + ", duration=" + (Object)((Object)this.duration) + ", clientId=" + this.clientId + "}";
    }
}

