/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.datastructure.events;

import java.util.HashMap;
import java.util.Map;
import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.datastructure.events.Event;
import velox.api.layer1.datastructure.events.EventType;

@Layer1ApiPublic
public class DepthAggregationEvent
extends Event {
    public Map<Integer, Integer> bidsMap = new HashMap<Integer, Integer>();
    public Map<Integer, Integer> asksMap = new HashMap<Integer, Integer>();

    public DepthAggregationEvent(long time) {
        super(time, EventType.NONE);
    }

    public Map<Integer, Integer> getMap(boolean isBid) {
        return isBid ? this.bidsMap : this.asksMap;
    }

    public String toString() {
        return "bids: " + this.bidsMap.size() + "|asks: " + this.asksMap.size();
    }

    public int bestBid() {
        int max = -1;
        for (Map.Entry<Integer, Integer> entry : this.bidsMap.entrySet()) {
            if (entry.getKey() <= max || entry.getValue() == 0) continue;
            max = entry.getKey();
        }
        return max;
    }

    @Override
    public Object clone() {
        DepthAggregationEvent event = new DepthAggregationEvent(this.time);
        event.bidsMap.putAll(this.bidsMap);
        event.asksMap.putAll(this.asksMap);
        return event;
    }
}

