/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.OverlayLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.gui.TextFieldState;

@Layer1ApiPublic
public class StatusIconTextField
extends JPanel {
    public final JTextField textField;
    private JLabel iconLabel;

    public StatusIconTextField(JTextField field) {
        this.setLayout(new OverlayLayout(this));
        JPanel panel = new JPanel();
        this.add(panel);
        panel.setOpaque(false);
        panel.setBackground(new Color(0, 0, 0, 0));
        this.textField = field;
        this.add(this.textField);
        panel.setCursor(this.textField.getCursor());
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{1, 1, 0};
        gbl_panel.rowHeights = new int[]{1, 0};
        gbl_panel.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        this.iconLabel = new JLabel("");
        this.iconLabel.setHorizontalAlignment(11);
        GridBagConstraints gbc_iconLabel = new GridBagConstraints();
        gbc_iconLabel.insets = new Insets(0, 0, 0, 5);
        gbc_iconLabel.gridx = 1;
        gbc_iconLabel.gridy = 0;
        panel.add((Component)this.iconLabel, gbc_iconLabel);
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public void changeTextFieldState(TextFieldState value) {
        this.textField.putClientProperty(TextFieldState.class, (Object)value);
        this.textField.repaint();
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setIconToolTip(String text) {
        this.iconLabel.setToolTipText(text);
    }

    public void setIcon(Icon icon) {
        if (icon != null && (icon.getIconWidth() > 16 || icon.getIconHeight() > 16)) {
            icon = new ImageIcon(((ImageIcon)icon).getImage().getScaledInstance(16, 16, 16));
        }
        this.iconLabel.setIcon(icon);
    }

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }

    public void setChangeListener(final Runnable callback) {
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                callback.run();
            }
        });
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        this.textField.addKeyListener(l);
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        this.textField.removeKeyListener(l);
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        this.textField.addFocusListener(l);
    }

    @Override
    public synchronized void removeFocusListener(FocusListener l) {
        this.textField.removeFocusListener(l);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField.setEnabled(enabled);
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.textField.setVisible(aFlag);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.textField.setToolTipText(text);
    }
}

