/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.layers.utils;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Semaphore;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import marytts.LocalMaryInterface;
import marytts.MaryInterface;
import marytts.exceptions.MaryConfigurationException;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.common.Log;

@Layer1ApiPublic
public class SoundSynthHelper {
    private static final int INIT_ATTEMPTS_MAX_COUNT = 10;
    private static MaryInterface marytts;
    private static Semaphore initializedSemaphore;

    public static synchronized void initialize() {
        try {
            System.setProperty("log4j.logger.marytts", "ERROR");
            int attemptsCount = 0;
            boolean success = false;
            do {
                ++attemptsCount;
                try {
                    marytts = new LocalMaryInterface();
                    success = true;
                }
                catch (MaryConfigurationException e) {
                    Log.error("When initializing marrytts: " + (Object)((Object)e) + ", will try again");
                }
            } while (!success && attemptsCount < 10);
            ArrayList<Logger> loggers = Collections.list(LogManager.getCurrentLoggers());
            for (Logger logger : loggers) {
                if (!logger.getName().startsWith("marytts.")) continue;
                logger.setLevel(Level.WARN);
            }
            if (marytts != null) {
                marytts.setVoice("cmu-bdl-hsmm");
            } else {
                Log.error("marrytts: max attempts count reached. synthesize won't work");
            }
            initializedSemaphore.release();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void waitUntilInitialized() throws InterruptedException {
        initializedSemaphore.acquire();
        initializedSemaphore.release();
    }

    /*
     * Exception decompiling
     */
    public static byte[] synthesize(String text) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static synchronized void say(String text) {
        byte[] data = SoundSynthHelper.synthesize(text);
        try (AudioInputStream audio = AudioSystem.getAudioInputStream(new ByteArrayInputStream(data));){
            Clip clip = AudioSystem.getClip();
            clip.open(audio);
            clip.start();
            final Semaphore semaphore = new Semaphore(0);
            clip.addLineListener(new LineListener(){

                @Override
                public void update(LineEvent event) {
                    if (event.getType() == LineEvent.Type.STOP) {
                        semaphore.release();
                    }
                }
            });
            semaphore.acquire();
            clip.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        initializedSemaphore = new Semaphore(0);
    }
}

