/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.messages.indicators;

import java.awt.Color;
import velox.api.layer1.activation.Layer1ApiPublic;
import velox.api.layer1.annotations.Layer1StrategyName;
import velox.api.layer1.layers.Layer1ApiStrategiesEchoMessagesLayer;
import velox.api.layer1.layers.strategies.interfaces.Layer1IndicatorColorInterface;
import velox.api.layer1.layers.strategies.interfaces.OnlineCalculatable;
import velox.api.layer1.messages.indicators.AliasFilter;
import velox.api.layer1.messages.indicators.BoundsInfo;
import velox.api.layer1.messages.indicators.HorizontalValueLinesInfo;
import velox.api.layer1.messages.indicators.IndicatorColorScheme;
import velox.api.layer1.messages.indicators.IndicatorContextMenuInformation;
import velox.api.layer1.messages.indicators.IndicatorDisplayLogic;
import velox.api.layer1.messages.indicators.IndicatorLineStyle;
import velox.api.layer1.messages.indicators.LimitsCalculator;
import velox.api.layer1.messages.indicators.LimitsResponse;
import velox.api.layer1.messages.indicators.WidgetDisplayInfo;

@Layer1ApiPublic
public class Layer1ApiUserMessageModifyIndicator
implements Layer1ApiStrategiesEchoMessagesLayer.StrategyEchoMessageFromLayer {
    private static final int GRAPH_LAYER_RENDER_PRIORITY_DEFAULT = LayerRenderPriority.ABOVE_BBO.priority;
    private static final int ICON_LAYER_RENDER_PRIORITY_DEFAULT = LayerRenderPriority.TOP.priority;
    public final String ownerClassName;
    public final String ownerUserName;
    public String fullName;
    public final String userName;
    public final boolean isAdd;
    public final IndicatorColorScheme indicatorColorScheme;
    public final Layer1IndicatorColorInterface colorInterface;
    public final IndicatorLineStyle indicatorLineStyle;
    public final Color defaultTooltipBackgrondColor;
    public final Color defaultTooltipTextColor;
    public final IndicatorDisplayLogic indicatorDisplayLogic;
    public final Double indicatorMinMarginPriceOut;
    public final Double indicatorMaxMarginPriceOut;
    public final Double minLimitsRange;
    public final BoundsInfo boundsInfo;
    public final GraphType graphType;
    public final boolean isSupportWidget;
    public final boolean isShowColorSettings;
    public final boolean isEnableSettingsFromConfigPopup;
    public final OnlineCalculatable onlineCalculatable;
    public final AliasFilter aliasFilter;
    public WidgetDisplayInfo widgetDisplayInfo;
    public boolean isWidgetEnabledByDefault;
    public IndicatorContextMenuInformation indicatorContextMenuInformation;
    public HorizontalValueLinesInfo horizontalValueLinesInfo;
    public int graphLayerRenderPriority = GRAPH_LAYER_RENDER_PRIORITY_DEFAULT;
    public int iconLayerRanderPriotity = ICON_LAYER_RENDER_PRIORITY_DEFAULT;

    private Layer1ApiUserMessageModifyIndicator(Builder builder) {
        this(builder.ownerClassName, builder.ownerUserName, builder.fullName, builder.userName, builder.isAdd, builder.indicatorColorScheme, builder.colorInterface, builder.indicatorLineStyle, builder.defaultTooltipBackgrondColor, builder.defaultTooltipTextColor, builder.indicatorDisplayLogic, builder.indicatorMinMarginPriceOut, builder.indicatorMaxMarginPriceOut, builder.minLimitsRange, builder.boundsInfo, builder.graphType, builder.isSupportWidget, builder.isShowColorSettings, builder.isEnableSettingsFromConfigPopup, builder.onlineCalculatable, builder.aliasFilter);
        this.widgetDisplayInfo = builder.widgetDisplayInfo;
        this.isWidgetEnabledByDefault = builder.isWidgetEnabledByDefault;
        this.indicatorContextMenuInformation = builder.indicatorContextMenuInformation;
        this.horizontalValueLinesInfo = builder.horizontalValueLinesInfo;
        this.graphLayerRenderPriority = builder.graphLayerRenderPriority;
        this.iconLayerRanderPriotity = builder.iconLayerRanderPriotity;
    }

    public Layer1ApiUserMessageModifyIndicator(Class<?> strategyClass, String userName, boolean isAdd, IndicatorColorScheme indicatorColorScheme, Layer1IndicatorColorInterface colorInterface, IndicatorLineStyle indicatorLineStyle, Color defaultTooltipBackgrondColor, Color defaultTooltipTextColor, IndicatorDisplayLogic indicatorDisplayLogic, Double indicatorMinMarginPriceOut, Double indicatorMaxMarginPriceOut, Double minLimitsRange, BoundsInfo boundsInfo, GraphType graphType, Boolean isSupportWidget, Boolean isShowColorSettings, Boolean isEnableSettingsFromConfigPopup, OnlineCalculatable onlineCalculatable, AliasFilter aliasFilter) {
        this(strategyClass.getCanonicalName(), Layer1ApiUserMessageModifyIndicator.getOwnerUserName(strategyClass), Layer1ApiUserMessageModifyIndicator.predictFullName(strategyClass, userName), userName, isAdd, indicatorColorScheme, colorInterface, indicatorLineStyle, defaultTooltipBackgrondColor, defaultTooltipTextColor, indicatorDisplayLogic, indicatorMinMarginPriceOut, indicatorMaxMarginPriceOut, minLimitsRange, boundsInfo, graphType, isSupportWidget, isShowColorSettings, isEnableSettingsFromConfigPopup, onlineCalculatable, aliasFilter);
    }

    private Layer1ApiUserMessageModifyIndicator(String ownerClassName, String ownerUserName, String fullName, String userName, boolean isAdd, IndicatorColorScheme indicatorColorScheme, Layer1IndicatorColorInterface colorInterface, IndicatorLineStyle indicatorLineStyle, Color defaultTooltipBackgrondColor, Color defaultTooltipTextColor, IndicatorDisplayLogic indicatorDisplayLogic, Double indicatorMinMarginPriceOut, Double indicatorMaxMarginPriceOut, Double minLimitsRange, BoundsInfo boundsInfo, GraphType graphType, Boolean isSupportWidget, Boolean isShowColorSettings, Boolean isEnableSettingsFromConfigPopup, OnlineCalculatable onlineCalculatable, AliasFilter aliasFilter) {
        this.ownerClassName = ownerClassName;
        this.ownerUserName = ownerUserName;
        this.fullName = fullName;
        this.userName = userName;
        this.isAdd = isAdd;
        this.indicatorColorScheme = indicatorColorScheme;
        this.colorInterface = colorInterface;
        this.indicatorLineStyle = indicatorLineStyle == null ? new IndicatorLineStyle() : indicatorLineStyle;
        this.defaultTooltipBackgrondColor = defaultTooltipBackgrondColor == null ? Color.BLACK : defaultTooltipBackgrondColor;
        this.defaultTooltipTextColor = defaultTooltipTextColor == null ? Color.WHITE : defaultTooltipTextColor;
        IndicatorDisplayLogic indicatorDisplayLogic2 = this.indicatorDisplayLogic = indicatorDisplayLogic == null ? new IndicatorDisplayLogic() : indicatorDisplayLogic;
        if (this.indicatorDisplayLogic.limitsCalculator == null) {
            this.indicatorDisplayLogic.limitsCalculator = new LimitsCalculator(){

                @Override
                public LimitsResponse getLimits(double minValue, double maxValue) {
                    if (Double.isNaN(maxValue) || Double.isNaN(minValue)) {
                        minValue = 0.0;
                        maxValue = Double.MIN_NORMAL;
                    } else {
                        double delta = Math.max(0.1, (maxValue - minValue) * 0.1);
                        maxValue += delta;
                        minValue -= delta;
                    }
                    return new LimitsResponse(minValue, maxValue);
                }
            };
        }
        this.indicatorMinMarginPriceOut = indicatorMinMarginPriceOut;
        this.indicatorMaxMarginPriceOut = indicatorMaxMarginPriceOut;
        this.minLimitsRange = minLimitsRange;
        this.boundsInfo = boundsInfo == null ? new BoundsInfo(null, null, null) : boundsInfo;
        this.graphType = graphType == null ? GraphType.NONE : graphType;
        this.isSupportWidget = isSupportWidget == null ? true : isSupportWidget;
        this.isShowColorSettings = isShowColorSettings == null ? true : isShowColorSettings;
        this.isEnableSettingsFromConfigPopup = isEnableSettingsFromConfigPopup == null ? true : isEnableSettingsFromConfigPopup;
        this.onlineCalculatable = onlineCalculatable;
        AliasFilter aliasFilter2 = this.aliasFilter = aliasFilter == null ? new AliasFilter(){} : aliasFilter;
        if (isAdd && this.graphType != GraphType.NONE && (indicatorColorScheme == null || indicatorColorScheme.getColors().length == 0)) {
            throw new NullPointerException("Can't add indicator with no deafult color specified");
        }
    }

    public Layer1ApiUserMessageModifyIndicator(Layer1ApiUserMessageModifyIndicator message) {
        this(message.ownerClassName, message.ownerUserName, message.fullName, message.userName, message.isAdd, message.indicatorColorScheme, message.colorInterface, message.indicatorLineStyle, message.defaultTooltipBackgrondColor, message.defaultTooltipTextColor, message.indicatorDisplayLogic, message.indicatorMinMarginPriceOut, message.indicatorMaxMarginPriceOut, message.minLimitsRange, message.boundsInfo, message.graphType, message.isSupportWidget, message.isShowColorSettings, message.isEnableSettingsFromConfigPopup, message.onlineCalculatable, message.aliasFilter);
    }

    public Layer1ApiUserMessageModifyIndicator(Layer1ApiUserMessageModifyIndicator message, boolean isAdd) {
        this(message.ownerClassName, message.ownerUserName, message.fullName, message.userName, isAdd, message.indicatorColorScheme, message.colorInterface, message.indicatorLineStyle, message.defaultTooltipBackgrondColor, message.defaultTooltipTextColor, message.indicatorDisplayLogic, message.indicatorMinMarginPriceOut, message.indicatorMaxMarginPriceOut, message.minLimitsRange, message.boundsInfo, message.graphType, message.isSupportWidget, message.isShowColorSettings, message.isEnableSettingsFromConfigPopup, message.onlineCalculatable, message.aliasFilter);
    }

    public void applyNameModifier(String modifier) {
        this.fullName = this.fullName.concat(modifier);
    }

    public Layer1ApiUserMessageModifyIndicator(Class<?> strategyClass, String userName, boolean isAdd) {
        this(strategyClass, userName, isAdd, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public static String predictFullName(Class<?> myClass, String myName) {
        return myClass.getCanonicalName() + "#" + myName;
    }

    public static Builder builder(Class<?> strategyClass, String userName) {
        return new Builder(strategyClass, userName);
    }

    public static String getOwnerUserName(Class<?> ownerClass) {
        Layer1StrategyName layer1ApiStrategyName = ownerClass.getAnnotation(Layer1StrategyName.class);
        String strategyName = ownerClass.getName();
        if (layer1ApiStrategyName != null) {
            strategyName = layer1ApiStrategyName.value();
        }
        return strategyName;
    }

    public String toString() {
        return "Layer1ApiUserMessageModifyIndicator [ownerClassName=" + this.ownerClassName + ", fullName=" + this.fullName + ", userName=" + this.userName + ", isAdd=" + this.isAdd + "]";
    }

    static /* synthetic */ int access$2800() {
        return GRAPH_LAYER_RENDER_PRIORITY_DEFAULT;
    }

    static /* synthetic */ int access$2900() {
        return ICON_LAYER_RENDER_PRIORITY_DEFAULT;
    }

    @Layer1ApiPublic
    public static final class Builder {
        private String ownerClassName;
        private String ownerUserName;
        private String fullName;
        private String userName;
        private boolean isAdd;
        private IndicatorColorScheme indicatorColorScheme;
        private Layer1IndicatorColorInterface colorInterface;
        private IndicatorLineStyle indicatorLineStyle;
        private Color defaultTooltipBackgrondColor;
        private Color defaultTooltipTextColor;
        private IndicatorDisplayLogic indicatorDisplayLogic;
        private Double indicatorMinMarginPriceOut;
        private Double indicatorMaxMarginPriceOut;
        private Double minLimitsRange;
        private BoundsInfo boundsInfo;
        private GraphType graphType;
        private boolean isSupportWidget;
        private boolean isShowColorSettings;
        private boolean isEnableSettingsFromConfigPopup;
        private OnlineCalculatable onlineCalculatable;
        private AliasFilter aliasFilter;
        private WidgetDisplayInfo widgetDisplayInfo;
        private boolean isWidgetEnabledByDefault;
        private IndicatorContextMenuInformation indicatorContextMenuInformation;
        private HorizontalValueLinesInfo horizontalValueLinesInfo;
        private int graphLayerRenderPriority = Layer1ApiUserMessageModifyIndicator.access$2800();
        private int iconLayerRanderPriotity = Layer1ApiUserMessageModifyIndicator.access$2900();

        public Builder(Layer1ApiUserMessageModifyIndicator message) {
            this.ownerClassName = message.ownerClassName;
            this.ownerUserName = message.ownerUserName;
            this.fullName = message.fullName;
            this.userName = message.userName;
            this.isAdd = message.isAdd;
            this.indicatorColorScheme = message.indicatorColorScheme;
            this.colorInterface = message.colorInterface;
            this.indicatorLineStyle = message.indicatorLineStyle;
            this.defaultTooltipBackgrondColor = message.defaultTooltipBackgrondColor;
            this.defaultTooltipTextColor = message.defaultTooltipTextColor;
            this.indicatorDisplayLogic = message.indicatorDisplayLogic;
            this.indicatorMinMarginPriceOut = message.indicatorMinMarginPriceOut;
            this.indicatorMaxMarginPriceOut = message.indicatorMaxMarginPriceOut;
            this.minLimitsRange = message.minLimitsRange;
            this.boundsInfo = message.boundsInfo;
            this.graphType = message.graphType;
            this.isSupportWidget = message.isSupportWidget;
            this.isShowColorSettings = message.isShowColorSettings;
            this.isEnableSettingsFromConfigPopup = message.isEnableSettingsFromConfigPopup;
            this.onlineCalculatable = message.onlineCalculatable;
            this.aliasFilter = message.aliasFilter;
            this.widgetDisplayInfo = message.widgetDisplayInfo;
            this.isWidgetEnabledByDefault = message.isWidgetEnabledByDefault;
            this.indicatorContextMenuInformation = message.indicatorContextMenuInformation;
            this.horizontalValueLinesInfo = message.horizontalValueLinesInfo;
            this.graphLayerRenderPriority = message.graphLayerRenderPriority;
            this.iconLayerRanderPriotity = message.iconLayerRanderPriotity;
        }

        private Builder(Class<?> strategyClass, String userName) {
            this.ownerClassName = strategyClass.getCanonicalName();
            this.ownerUserName = Layer1ApiUserMessageModifyIndicator.getOwnerUserName(strategyClass);
            this.fullName = Layer1ApiUserMessageModifyIndicator.predictFullName(strategyClass, userName);
            this.userName = userName;
        }

        public Builder setIsAdd(boolean isAdd) {
            this.isAdd = isAdd;
            return this;
        }

        public Builder setIndicatorColorScheme(IndicatorColorScheme indicatorColorScheme) {
            this.indicatorColorScheme = indicatorColorScheme;
            return this;
        }

        public Builder setColorInterface(Layer1IndicatorColorInterface colorInterface) {
            this.colorInterface = colorInterface;
            return this;
        }

        public Builder setIndicatorLineStyle(IndicatorLineStyle indicatorLineStyle) {
            this.indicatorLineStyle = indicatorLineStyle;
            return this;
        }

        public Builder setDefaultTooltipBackgrondColor(Color defaultTooltipBackgrondColor) {
            this.defaultTooltipBackgrondColor = defaultTooltipBackgrondColor;
            return this;
        }

        public Builder setDefaultTooltipTextColor(Color defaultTooltipTextColor) {
            this.defaultTooltipTextColor = defaultTooltipTextColor;
            return this;
        }

        public Builder setIndicatorDisplayLogic(IndicatorDisplayLogic indicatorDisplayLogic) {
            this.indicatorDisplayLogic = indicatorDisplayLogic;
            return this;
        }

        public Builder setIndicatorMinMarginPriceOut(Double indicatorMinMarginPriceOut) {
            this.indicatorMinMarginPriceOut = indicatorMinMarginPriceOut;
            return this;
        }

        public Builder setIndicatorMaxMarginPriceOut(Double indicatorMaxMarginPriceOut) {
            this.indicatorMaxMarginPriceOut = indicatorMaxMarginPriceOut;
            return this;
        }

        public Builder setMinLimitsRange(Double minLimitsRange) {
            this.minLimitsRange = minLimitsRange;
            return this;
        }

        public Builder setBoundsInfo(BoundsInfo boundsInfo) {
            this.boundsInfo = boundsInfo;
            return this;
        }

        public Builder setGraphType(GraphType graphType) {
            this.graphType = graphType;
            return this;
        }

        public Builder setIsSupportWidget(boolean isSupportWidget) {
            this.isSupportWidget = isSupportWidget;
            return this;
        }

        public Builder setIsShowColorSettings(boolean isShowColorSettings) {
            this.isShowColorSettings = isShowColorSettings;
            return this;
        }

        public Builder setIsEnableSettingsFromConfigPopup(boolean isEnableSettingsFromConfigPopup) {
            this.isEnableSettingsFromConfigPopup = isEnableSettingsFromConfigPopup;
            return this;
        }

        public Builder setOnlineCalculatable(OnlineCalculatable onlineCalculatable) {
            this.onlineCalculatable = onlineCalculatable;
            return this;
        }

        public Builder setAliasFiler(AliasFilter aliasFiler) {
            this.aliasFilter = aliasFiler;
            return this;
        }

        public Builder setWidgetDisplayInfo(WidgetDisplayInfo widgetDisplayInfo) {
            this.widgetDisplayInfo = widgetDisplayInfo;
            return this;
        }

        public Builder setIsWidgetEnabledByDefault(boolean isWidgetEnabledByDefault) {
            this.isWidgetEnabledByDefault = isWidgetEnabledByDefault;
            return this;
        }

        public Builder setIndicatorContextMenuInformation(IndicatorContextMenuInformation indicatorContextMenuInformation) {
            this.indicatorContextMenuInformation = indicatorContextMenuInformation;
            return this;
        }

        public Builder setHorizontalValueLinesInfo(HorizontalValueLinesInfo horizontalValueLinesInfo) {
            this.horizontalValueLinesInfo = horizontalValueLinesInfo;
            return this;
        }

        public Layer1ApiUserMessageModifyIndicator build() {
            return new Layer1ApiUserMessageModifyIndicator(this);
        }

        public Builder extendFullName(String suffix) {
            this.fullName = this.fullName + suffix;
            return this;
        }

        public Builder setGraphLayerRenderPriority(int graphLayerRenderPriority) {
            if (graphLayerRenderPriority < LayerRenderPriority.ABSOLUTE_BOTTOM.priority || graphLayerRenderPriority > LayerRenderPriority.ABSOLUTE_TOP.priority) {
                throw new IllegalArgumentException("Layer render priority should be in range [" + LayerRenderPriority.ABSOLUTE_BOTTOM.priority + " " + LayerRenderPriority.ABSOLUTE_TOP.priority + "]");
            }
            this.graphLayerRenderPriority = graphLayerRenderPriority;
            return this;
        }

        public Builder setGraphLayerRenderPriority(LayerRenderPriority graphLayerRenderPriority) {
            return this.setGraphLayerRenderPriority(graphLayerRenderPriority.priority);
        }

        public Builder setIconLayerRanderPriotity(int iconLayerRanderPriotity) {
            if (iconLayerRanderPriotity < LayerRenderPriority.ABSOLUTE_BOTTOM.priority || iconLayerRanderPriotity > LayerRenderPriority.ABSOLUTE_TOP.priority) {
                throw new IllegalArgumentException("Layer render priority should be in range [" + LayerRenderPriority.ABSOLUTE_BOTTOM.priority + " " + LayerRenderPriority.ABSOLUTE_TOP.priority + "]");
            }
            this.iconLayerRanderPriotity = iconLayerRanderPriotity;
            return this;
        }

        public Builder setIconLayerRanderPriotity(LayerRenderPriority iconLayerRanderPriotity) {
            return this.setIconLayerRanderPriotity(iconLayerRanderPriotity.priority);
        }
    }

    @Layer1ApiPublic
    public static enum LayerRenderPriority {
        ABSOLUTE_TOP(1000000),
        TOP(1000),
        ABOVE_BBO(500),
        ABSOLUTE_BOTTOM(0);

        public int priority;

        private LayerRenderPriority(int priority) {
            this.priority = priority;
        }
    }

    @Layer1ApiPublic
    public static enum GraphType {
        BOTTOM,
        PRIMARY,
        NONE;

    }
}

