/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.datastructure.events;

import java.util.HashMap;
import java.util.Map;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.datastructure.events.Event;
import velox.api.layer1.datastructure.events.EventType;

@Layer1ApiPublic
public class TradeAggregationEvent
extends Event {
    private static final long serialVersionUID = 6529871794977925342L;
    public Map<Double, Map<Integer, Integer>> bidAggressorMap = new HashMap<Double, Map<Integer, Integer>>();
    public Map<Double, Map<Integer, Integer>> askAggressorMap = new HashMap<Double, Map<Integer, Integer>>();
    public double lastPrice = Double.NaN;
    public Integer lastSize = null;
    public Boolean lastAggressorBid = null;

    public TradeAggregationEvent(long time) {
        super(time, EventType.NONE);
    }

    @Override
    public Object clone() {
        TradeAggregationEvent event = new TradeAggregationEvent(this.time);
        for (Map.Entry<Double, Map<Integer, Integer>> entry : this.bidAggressorMap.entrySet()) {
            event.bidAggressorMap.put(entry.getKey(), (Map)((HashMap)entry.getValue()).clone());
        }
        for (Map.Entry<Double, Map<Integer, Integer>> entry : this.askAggressorMap.entrySet()) {
            event.askAggressorMap.put(entry.getKey(), (Map)((HashMap)entry.getValue()).clone());
        }
        event.lastPrice = this.lastPrice;
        event.lastSize = this.lastSize;
        event.lastAggressorBid = this.lastAggressorBid;
        return event;
    }

    private int getMapSum(Map<Double, Map<Integer, Integer>> map) {
        int result = 0;
        for (Map.Entry<Double, Map<Integer, Integer>> priceEntry : map.entrySet()) {
            for (Map.Entry<Integer, Integer> entry : priceEntry.getValue().entrySet()) {
                result += entry.getValue() * entry.getKey();
            }
        }
        return result;
    }

    public int getBidTradeSize() {
        return this.getMapSum(this.bidAggressorMap);
    }

    public int getAskTradeSize() {
        return this.getMapSum(this.askAggressorMap);
    }

    public int getTotalTradeSize() {
        return this.getBidTradeSize() + this.getAskTradeSize();
    }
}

